/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import net.minecraft.server.Chunk;
import net.minecraft.server.ChunkLoader;
import net.minecraft.server.CompressedStreamTools;
import net.minecraft.server.IChunkLoader;
import net.minecraft.server.NBTBase;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.RegionFileCache;
import net.minecraft.server.World;
import net.minecraft.server.WorldData;

public class ChunkRegionLoader
implements IChunkLoader {
    private final File a;

    public ChunkRegionLoader(File file) {
        this.a = file;
    }

    @Override
    public Chunk a(World world, int n, int n2) throws IOException {
        DataInputStream dataInputStream = RegionFileCache.c(this.a, n, n2);
        if (dataInputStream != null) {
            NBTTagCompound nBTTagCompound = CompressedStreamTools.a(dataInputStream);
            if (!nBTTagCompound.hasKey("Level")) {
                System.out.println("Chunk file at " + n + "," + n2 + " is missing level data, skipping");
                return null;
            }
            if (!nBTTagCompound.k("Level").hasKey("Blocks")) {
                System.out.println("Chunk file at " + n + "," + n2 + " is missing block data, skipping");
                return null;
            }
            Chunk chunk = ChunkLoader.a(world, nBTTagCompound.k("Level"));
            if (!chunk.a(n, n2)) {
                System.out.println("Chunk file at " + n + "," + n2 + " is in the wrong location; relocating. (Expected " + n + ", " + n2 + ", got " + chunk.x + ", " + chunk.z + ")");
                nBTTagCompound.a("xPos", n);
                nBTTagCompound.a("zPos", n2);
                chunk = ChunkLoader.a(world, nBTTagCompound.k("Level"));
            }
            chunk.h();
            return chunk;
        }
        return null;
    }

    @Override
    public void a(World world, Chunk chunk) throws IOException {
        world.k();
        try {
            DataOutputStream dataOutputStream = RegionFileCache.d(this.a, chunk.x, chunk.z);
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
            nBTTagCompound.a("Level", (NBTBase)nBTTagCompound2);
            ChunkLoader.a(chunk, world, nBTTagCompound2);
            CompressedStreamTools.a(nBTTagCompound, dataOutputStream);
            dataOutputStream.close();
            WorldData worldData = world.q();
            worldData.b(worldData.g() + (long)RegionFileCache.b(this.a, chunk.x, chunk.z));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void b(World world, Chunk chunk) {
    }

    @Override
    public void a() {
    }

    @Override
    public void b() {
    }
}

