/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import net.minecraft.server.Chunk;
import net.minecraft.server.CompressedStreamTools;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityTypes;
import net.minecraft.server.IChunkLoader;
import net.minecraft.server.NBTBase;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NBTTagList;
import net.minecraft.server.NibbleArray;
import net.minecraft.server.TileEntity;
import net.minecraft.server.World;
import net.minecraft.server.WorldData;

public class ChunkLoader
implements IChunkLoader {
    private File a;
    private boolean b;

    public ChunkLoader(File file, boolean bl) {
        this.a = file;
        this.b = bl;
    }

    private File a(int n, int n2) {
        String string = "c." + Integer.toString(n, 36) + "." + Integer.toString(n2, 36) + ".dat";
        String string2 = Integer.toString(n & 0x3F, 36);
        String string3 = Integer.toString(n2 & 0x3F, 36);
        File file = new File(this.a, string2);
        if (!file.exists()) {
            if (!this.b) {
                return null;
            }
            file.mkdir();
        }
        if (!(file = new File(file, string3)).exists()) {
            if (!this.b) {
                return null;
            }
            file.mkdir();
        }
        return !(file = new File(file, string)).exists() && !this.b ? null : file;
    }

    @Override
    public Chunk a(World world, int n, int n2) {
        File file = this.a(n, n2);
        if (file != null && file.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                NBTTagCompound nBTTagCompound = CompressedStreamTools.a(fileInputStream);
                if (!nBTTagCompound.hasKey("Level")) {
                    System.out.println("Chunk file at " + n + "," + n2 + " is missing level data, skipping");
                    return null;
                }
                if (!nBTTagCompound.k("Level").hasKey("Blocks")) {
                    System.out.println("Chunk file at " + n + "," + n2 + " is missing block data, skipping");
                    return null;
                }
                Chunk chunk = ChunkLoader.a(world, nBTTagCompound.k("Level"));
                if (!chunk.a(n, n2)) {
                    System.out.println("Chunk file at " + n + "," + n2 + " is in the wrong location; relocating. (Expected " + n + ", " + n2 + ", got " + chunk.x + ", " + chunk.z + ")");
                    nBTTagCompound.a("xPos", n);
                    nBTTagCompound.a("zPos", n2);
                    chunk = ChunkLoader.a(world, nBTTagCompound.k("Level"));
                }
                chunk.h();
                return chunk;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public void a(World world, Chunk chunk) {
        Object object;
        world.k();
        File file = this.a(chunk.x, chunk.z);
        if (file.exists()) {
            object = world.q();
            ((WorldData)object).b(((WorldData)object).g() - file.length());
        }
        try {
            object = new File(this.a, "tmp_chunk.dat");
            FileOutputStream fileOutputStream = new FileOutputStream((File)object);
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
            nBTTagCompound.a("Level", (NBTBase)nBTTagCompound2);
            ChunkLoader.a(chunk, world, nBTTagCompound2);
            CompressedStreamTools.a(nBTTagCompound, fileOutputStream);
            fileOutputStream.close();
            if (file.exists()) {
                file.delete();
            }
            ((File)object).renameTo(file);
            WorldData worldData = world.q();
            worldData.b(worldData.g() + file.length());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void a(Chunk chunk, World world, NBTTagCompound nBTTagCompound) {
        NBTTagCompound nBTTagCompound2;
        world.k();
        nBTTagCompound.a("xPos", chunk.x);
        nBTTagCompound.a("zPos", chunk.z);
        nBTTagCompound.setLong("LastUpdate", world.getTime());
        nBTTagCompound.a("Blocks", chunk.b);
        nBTTagCompound.a("Data", chunk.e.a);
        nBTTagCompound.a("SkyLight", chunk.f.a);
        nBTTagCompound.a("BlockLight", chunk.g.a);
        nBTTagCompound.a("HeightMap", chunk.heightMap);
        nBTTagCompound.a("TerrainPopulated", chunk.done);
        chunk.q = false;
        NBTTagList nBTTagList = new NBTTagList();
        for (int i = 0; i < chunk.entitySlices.length; ++i) {
            for (Object object : chunk.entitySlices[i]) {
                chunk.q = true;
                nBTTagCompound2 = new NBTTagCompound();
                if (!((Entity)object).c(nBTTagCompound2)) continue;
                nBTTagList.a(nBTTagCompound2);
            }
        }
        nBTTagCompound.a("Entities", nBTTagList);
        NBTTagList nBTTagList2 = new NBTTagList();
        for (Object object : chunk.tileEntities.values()) {
            nBTTagCompound2 = new NBTTagCompound();
            ((TileEntity)object).b(nBTTagCompound2);
            nBTTagList2.a(nBTTagCompound2);
        }
        nBTTagCompound.a("TileEntities", nBTTagList2);
    }

    public static Chunk a(World world, NBTTagCompound nBTTagCompound) {
        NBTTagList nBTTagList;
        Object object;
        NBTTagList nBTTagList2;
        int n = nBTTagCompound.e("xPos");
        int n2 = nBTTagCompound.e("zPos");
        Chunk chunk = new Chunk(world, n, n2);
        chunk.b = nBTTagCompound.j("Blocks");
        chunk.e = new NibbleArray(nBTTagCompound.j("Data"));
        chunk.f = new NibbleArray(nBTTagCompound.j("SkyLight"));
        chunk.g = new NibbleArray(nBTTagCompound.j("BlockLight"));
        chunk.heightMap = nBTTagCompound.j("HeightMap");
        chunk.done = nBTTagCompound.m("TerrainPopulated");
        if (!chunk.e.a()) {
            chunk.e = new NibbleArray(chunk.b.length);
        }
        if (chunk.heightMap == null || !chunk.f.a()) {
            chunk.heightMap = new byte[256];
            chunk.f = new NibbleArray(chunk.b.length);
            chunk.initLighting();
        }
        if (!chunk.g.a()) {
            chunk.g = new NibbleArray(chunk.b.length);
            chunk.a();
        }
        if ((nBTTagList2 = nBTTagCompound.l("Entities")) != null) {
            for (int i = 0; i < nBTTagList2.c(); ++i) {
                NBTTagCompound nBTTagCompound2 = (NBTTagCompound)nBTTagList2.a(i);
                object = EntityTypes.a(nBTTagCompound2, world);
                chunk.q = true;
                if (object == null) continue;
                chunk.a((Entity)object);
            }
        }
        if ((nBTTagList = nBTTagCompound.l("TileEntities")) != null) {
            for (int i = 0; i < nBTTagList.c(); ++i) {
                object = (NBTTagCompound)nBTTagList.a(i);
                TileEntity tileEntity = TileEntity.c((NBTTagCompound)object);
                if (tileEntity == null) continue;
                chunk.a(tileEntity);
            }
        }
        return chunk;
    }

    @Override
    public void a() {
    }

    @Override
    public void b() {
    }

    @Override
    public void b(World world, Chunk chunk) {
    }
}

