/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.Random;
import net.minecraft.server.Block;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityTNTPrimed;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.Material;
import net.minecraft.server.World;

public class BlockTNT
extends Block {
    public BlockTNT(int n, int n2) {
        super(n, n2, Material.TNT);
    }

    @Override
    public int a(int n) {
        return n == 0 ? this.textureId + 2 : (n == 1 ? this.textureId + 1 : this.textureId);
    }

    @Override
    public void doPhysics(World world, int n, int n2, int n3, int n4) {
        if (n4 > 0 && Block.byId[n4].isPowerSource() && world.isBlockIndirectlyPowered(n, n2, n3)) {
            this.postBreak(world, n, n2, n3, 1);
            world.setTypeId(n, n2, n3, 0);
        }
    }

    @Override
    public int a(Random random) {
        return 0;
    }

    @Override
    public void c(World world, int n, int n2, int n3) {
        EntityTNTPrimed entityTNTPrimed = new EntityTNTPrimed(world, (float)n + 0.5f, (float)n2 + 0.5f, (float)n3 + 0.5f);
        entityTNTPrimed.fuseTicks = world.random.nextInt(entityTNTPrimed.fuseTicks / 4) + entityTNTPrimed.fuseTicks / 8;
        world.addEntity(entityTNTPrimed);
    }

    @Override
    public void postBreak(World world, int n, int n2, int n3, int n4) {
        if (!world.isStatic) {
            if ((n4 & 1) == 0) {
                this.a(world, n, n2, n3, new ItemStack(Block.TNT.id, 1, 0));
            } else {
                EntityTNTPrimed entityTNTPrimed = new EntityTNTPrimed(world, (float)n + 0.5f, (float)n2 + 0.5f, (float)n3 + 0.5f);
                world.addEntity(entityTNTPrimed);
                world.makeSound(entityTNTPrimed, "random.fuse", 1.0f, 1.0f);
            }
        }
    }

    @Override
    public void b(World world, int n, int n2, int n3, EntityHuman entityHuman) {
        if (entityHuman.G() != null && entityHuman.G().id == Item.FLINT_AND_STEEL.id) {
            world.setRawData(n, n2, n3, 1);
        }
        super.b(world, n, n2, n3, entityHuman);
    }

    @Override
    public boolean interact(World world, int n, int n2, int n3, EntityHuman entityHuman) {
        return super.interact(world, n, n2, n3, entityHuman);
    }
}

