/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.Random;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.Block;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityItem;
import net.minecraft.server.EnumSkyBlock;
import net.minecraft.server.IBlockAccess;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.Material;
import net.minecraft.server.StatisticList;
import net.minecraft.server.World;

public class BlockSnow
extends Block {
    protected BlockSnow(int n, int n2) {
        super(n, n2, Material.SNOW_LAYER);
        this.a(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
        this.a(true);
    }

    @Override
    public AxisAlignedBB d(World world, int n, int n2, int n3) {
        int n4 = world.getData(n, n2, n3) & 7;
        return n4 >= 3 ? AxisAlignedBB.b((double)n + this.minX, (double)n2 + this.minY, (double)n3 + this.minZ, (double)n + this.maxX, (float)n2 + 0.5f, (double)n3 + this.maxZ) : null;
    }

    @Override
    public boolean a() {
        return false;
    }

    @Override
    public boolean b() {
        return false;
    }

    @Override
    public void a(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        int n4 = iBlockAccess.getData(n, n2, n3) & 7;
        float f = (float)(2 * (1 + n4)) / 16.0f;
        this.a(0.0f, 0.0f, 0.0f, 1.0f, f, 1.0f);
    }

    @Override
    public boolean canPlace(World world, int n, int n2, int n3) {
        int n4 = world.getTypeId(n, n2 - 1, n3);
        return n4 != 0 && Block.byId[n4].a() ? world.getMaterial(n, n2 - 1, n3).isSolid() : false;
    }

    @Override
    public void doPhysics(World world, int n, int n2, int n3, int n4) {
        this.g(world, n, n2, n3);
    }

    private boolean g(World world, int n, int n2, int n3) {
        if (!this.canPlace(world, n, n2, n3)) {
            this.g(world, n, n2, n3, world.getData(n, n2, n3));
            world.setTypeId(n, n2, n3, 0);
            return false;
        }
        return true;
    }

    @Override
    public void a(World world, EntityHuman entityHuman, int n, int n2, int n3, int n4) {
        int n5 = Item.SNOW_BALL.id;
        float f = 0.7f;
        double d = (double)(world.random.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d2 = (double)(world.random.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d3 = (double)(world.random.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        EntityItem entityItem = new EntityItem(world, (double)n + d, (double)n2 + d2, (double)n3 + d3, new ItemStack(n5, 1, 0));
        entityItem.pickupDelay = 10;
        world.addEntity(entityItem);
        world.setTypeId(n, n2, n3, 0);
        entityHuman.a(StatisticList.C[this.id], 1);
    }

    @Override
    public int a(int n, Random random) {
        return Item.SNOW_BALL.id;
    }

    @Override
    public int a(Random random) {
        return 0;
    }

    @Override
    public void a(World world, int n, int n2, int n3, Random random) {
        if (world.a(EnumSkyBlock.BLOCK, n, n2, n3) > 11) {
            this.g(world, n, n2, n3, world.getData(n, n2, n3));
            world.setTypeId(n, n2, n3, 0);
        }
    }
}

