/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.Random;
import net.minecraft.server.Block;
import net.minecraft.server.BlockContainer;
import net.minecraft.server.EntityArrow;
import net.minecraft.server.EntityEgg;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityItem;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntitySnowball;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.Material;
import net.minecraft.server.MathHelper;
import net.minecraft.server.TileEntity;
import net.minecraft.server.TileEntityDispenser;
import net.minecraft.server.World;

public class BlockDispenser
extends BlockContainer {
    private Random a = new Random();

    protected BlockDispenser(int n) {
        super(n, Material.STONE);
        this.textureId = 45;
    }

    @Override
    public int c() {
        return 4;
    }

    @Override
    public int a(int n, Random random) {
        return Block.DISPENSER.id;
    }

    @Override
    public void e(World world, int n, int n2, int n3) {
        super.e(world, n, n2, n3);
        this.g(world, n, n2, n3);
    }

    private void g(World world, int n, int n2, int n3) {
        if (!world.isStatic) {
            int n4 = world.getTypeId(n, n2, n3 - 1);
            int n5 = world.getTypeId(n, n2, n3 + 1);
            int n6 = world.getTypeId(n - 1, n2, n3);
            int n7 = world.getTypeId(n + 1, n2, n3);
            int n8 = 3;
            if (Block.o[n4] && !Block.o[n5]) {
                n8 = 3;
            }
            if (Block.o[n5] && !Block.o[n4]) {
                n8 = 2;
            }
            if (Block.o[n6] && !Block.o[n7]) {
                n8 = 5;
            }
            if (Block.o[n7] && !Block.o[n6]) {
                n8 = 4;
            }
            world.setData(n, n2, n3, n8);
        }
    }

    @Override
    public int a(int n) {
        return n == 1 ? this.textureId + 17 : (n == 0 ? this.textureId + 17 : (n == 3 ? this.textureId + 1 : this.textureId));
    }

    @Override
    public boolean interact(World world, int n, int n2, int n3, EntityHuman entityHuman) {
        if (world.isStatic) {
            return true;
        }
        TileEntityDispenser tileEntityDispenser = (TileEntityDispenser)world.getTileEntity(n, n2, n3);
        entityHuman.a(tileEntityDispenser);
        return true;
    }

    private void dispense(World world, int n, int n2, int n3, Random random) {
        int n4 = world.getData(n, n2, n3);
        int n5 = 0;
        int n6 = 0;
        if (n4 == 3) {
            n6 = 1;
        } else if (n4 == 2) {
            n6 = -1;
        } else {
            n5 = n4 == 5 ? 1 : -1;
        }
        TileEntityDispenser tileEntityDispenser = (TileEntityDispenser)world.getTileEntity(n, n2, n3);
        ItemStack itemStack = tileEntityDispenser.b();
        double d = (double)n + (double)n5 * 0.6 + 0.5;
        double d2 = (double)n2 + 0.5;
        double d3 = (double)n3 + (double)n6 * 0.6 + 0.5;
        if (itemStack == null) {
            world.e(1001, n, n2, n3, 0);
        } else {
            if (itemStack.id == Item.ARROW.id) {
                EntityArrow entityArrow = new EntityArrow(world, d, d2, d3);
                entityArrow.a((double)n5, (double)0.1f, (double)n6, 1.1f, 6.0f);
                entityArrow.fromPlayer = true;
                world.addEntity(entityArrow);
                world.e(1002, n, n2, n3, 0);
            } else if (itemStack.id == Item.EGG.id) {
                EntityEgg entityEgg = new EntityEgg(world, d, d2, d3);
                entityEgg.a((double)n5, (double)0.1f, (double)n6, 1.1f, 6.0f);
                world.addEntity(entityEgg);
                world.e(1002, n, n2, n3, 0);
            } else if (itemStack.id == Item.SNOW_BALL.id) {
                EntitySnowball entitySnowball = new EntitySnowball(world, d, d2, d3);
                entitySnowball.a((double)n5, (double)0.1f, (double)n6, 1.1f, 6.0f);
                world.addEntity(entitySnowball);
                world.e(1002, n, n2, n3, 0);
            } else {
                EntityItem entityItem = new EntityItem(world, d, d2 - 0.3, d3, itemStack);
                double d4 = random.nextDouble() * 0.1 + 0.2;
                entityItem.motX = (double)n5 * d4;
                entityItem.motY = 0.2f;
                entityItem.motZ = (double)n6 * d4;
                entityItem.motX += random.nextGaussian() * (double)0.0075f * 6.0;
                entityItem.motY += random.nextGaussian() * (double)0.0075f * 6.0;
                entityItem.motZ += random.nextGaussian() * (double)0.0075f * 6.0;
                world.addEntity(entityItem);
                world.e(1000, n, n2, n3, 0);
            }
            world.e(2000, n, n2, n3, n5 + 1 + (n6 + 1) * 3);
        }
    }

    @Override
    public void doPhysics(World world, int n, int n2, int n3, int n4) {
        if (n4 > 0 && Block.byId[n4].isPowerSource()) {
            boolean bl;
            boolean bl2 = bl = world.isBlockIndirectlyPowered(n, n2, n3) || world.isBlockIndirectlyPowered(n, n2 + 1, n3);
            if (bl) {
                world.c(n, n2, n3, this.id, this.c());
            }
        }
    }

    @Override
    public void a(World world, int n, int n2, int n3, Random random) {
        if (world.isBlockIndirectlyPowered(n, n2, n3) || world.isBlockIndirectlyPowered(n, n2 + 1, n3)) {
            this.dispense(world, n, n2, n3, random);
        }
    }

    @Override
    protected TileEntity a_() {
        return new TileEntityDispenser();
    }

    @Override
    public void postPlace(World world, int n, int n2, int n3, EntityLiving entityLiving) {
        int n4 = MathHelper.floor((double)(entityLiving.yaw * 4.0f / 360.0f) + 0.5) & 3;
        if (n4 == 0) {
            world.setData(n, n2, n3, 2);
        }
        if (n4 == 1) {
            world.setData(n, n2, n3, 5);
        }
        if (n4 == 2) {
            world.setData(n, n2, n3, 3);
        }
        if (n4 == 3) {
            world.setData(n, n2, n3, 4);
        }
    }

    @Override
    public void remove(World world, int n, int n2, int n3) {
        TileEntityDispenser tileEntityDispenser = (TileEntityDispenser)world.getTileEntity(n, n2, n3);
        for (int i = 0; i < tileEntityDispenser.getSize(); ++i) {
            ItemStack itemStack = tileEntityDispenser.getItem(i);
            if (itemStack == null) continue;
            float f = this.a.nextFloat() * 0.8f + 0.1f;
            float f2 = this.a.nextFloat() * 0.8f + 0.1f;
            float f3 = this.a.nextFloat() * 0.8f + 0.1f;
            while (itemStack.count > 0) {
                int n4 = this.a.nextInt(21) + 10;
                if (n4 > itemStack.count) {
                    n4 = itemStack.count;
                }
                itemStack.count -= n4;
                EntityItem entityItem = new EntityItem(world, (float)n + f, (float)n2 + f2, (float)n3 + f3, new ItemStack(itemStack.id, n4, itemStack.getData()));
                float f4 = 0.05f;
                entityItem.motX = (float)this.a.nextGaussian() * f4;
                entityItem.motY = (float)this.a.nextGaussian() * f4 + 0.2f;
                entityItem.motZ = (float)this.a.nextGaussian() * f4;
                world.addEntity(entityItem);
            }
        }
        super.remove(world, n, n2, n3);
    }
}

