/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher.mod;

import com.pclewis.mcpatcher.MCPatcherUtils;
import com.pclewis.mcpatcher.mod.CustomAnimation;
import com.pclewis.mcpatcher.mod.TileSize;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.src.TextureFX;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextureUtils {
    public static Minecraft minecraft;
    private static boolean animatedFire;
    private static boolean animatedLava;
    private static boolean animatedWater;
    private static boolean animatedPortal;
    private static boolean customFire;
    private static boolean customLava;
    private static boolean customWater;
    private static boolean customPortal;
    public static final int LAVA_STILL_TEXTURE_INDEX = 237;
    public static final int LAVA_FLOWING_TEXTURE_INDEX = 238;
    public static final int WATER_STILL_TEXTURE_INDEX = 205;
    public static final int WATER_FLOWING_TEXTURE_INDEX = 206;
    public static final int FIRE_E_W_TEXTURE_INDEX = 31;
    public static final int FIRE_N_S_TEXTURE_INDEX = 47;
    public static final int PORTAL_TEXTURE_INDEX = 14;
    private static HashMap<String, Integer> expectedColumns;
    private static boolean useTextureCache;
    private static d lastTexturePack;
    private static HashMap<String, BufferedImage> cache;

    public static boolean setTileSize() {
        MCPatcherUtils.log("\nchanging skin to %s", TextureUtils.getTexturePackName(TextureUtils.getSelectedTexturePack()));
        int size = TextureUtils.getTileSize();
        if (size == TileSize.int_size) {
            MCPatcherUtils.log("tile size %d unchanged", size);
            return false;
        }
        MCPatcherUtils.log("setting tile size to %d (was %d)", size, TileSize.int_size);
        TileSize.setTileSize(size);
        return true;
    }

    public static void setFontRenderer() {
        MCPatcherUtils.log("setFontRenderer()", new Object[0]);
        TextureUtils.minecraft.o.initialize(TextureUtils.minecraft.y, "/font/default.png", TextureUtils.minecraft.n);
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public static void registerTextureFX(List textureList, ae textureFX) {
        ae fx2 = TextureUtils.refreshTextureFX(textureFX);
        if (fx2 != null) {
            MCPatcherUtils.log("registering new TextureFX class %s", textureFX.getClass().getName());
            textureList.add(fx2);
            fx2.a();
        }
    }

    private static ae refreshTextureFX(ae textureFX) {
        if (textureFX instanceof af || textureFX instanceof ha || textureFX instanceof bc || textureFX instanceof fj || textureFX instanceof ou || textureFX instanceof jn || textureFX instanceof me || textureFX instanceof fb || textureFX instanceof CustomAnimation) {
            return null;
        }
        Class<?> textureFXClass = textureFX.getClass();
        for (int i2 = 0; i2 < 3; ++i2) {
            try {
                switch (i2) {
                    case 0: {
                        Constructor<?> constructor = textureFXClass.getConstructor(Minecraft.class, Integer.TYPE);
                        return (ae)constructor.newInstance(minecraft, TileSize.int_size);
                    }
                    case 1: {
                        Constructor<?> constructor = textureFXClass.getConstructor(Minecraft.class);
                        return (ae)constructor.newInstance(minecraft);
                    }
                    case 2: {
                        Constructor<?> constructor = textureFXClass.getConstructor(new Class[0]);
                        return (ae)constructor.newInstance(new Object[0]);
                    }
                }
                continue;
            }
            catch (NoSuchMethodException e2) {
                continue;
            }
            catch (IllegalAccessException e3) {
                continue;
            }
            catch (Exception e4) {
                e4.printStackTrace();
            }
        }
        if (textureFX.a.length != TileSize.int_numBytes) {
            MCPatcherUtils.log("resizing %s buffer from %d to %d bytes", textureFXClass.getName(), textureFX.a.length, TileSize.int_numBytes);
            textureFX.a = new byte[TileSize.int_numBytes];
        }
        return textureFX;
    }

    public static void refreshTextureFX(List<TextureFX> textureList) {
        boolean bl2;
        MCPatcherUtils.log("refreshTextureFX()", new Object[0]);
        ArrayList<ae> savedTextureFX = new ArrayList<ae>();
        for (ae ae2 : textureList) {
            ae fx2 = TextureUtils.refreshTextureFX(ae2);
            if (fx2 == null) continue;
            savedTextureFX.add(fx2);
        }
        textureList.clear();
        textureList.add((TextureFX)new af(minecraft));
        textureList.add((TextureFX)new ha(minecraft));
        d selectedTexturePack = TextureUtils.getSelectedTexturePack();
        boolean bl3 = bl2 = selectedTexturePack == null || selectedTexturePack instanceof kb;
        if (!bl2 && customLava) {
            textureList.add((TextureFX)new CustomAnimation(237, 0, 1, "lava_still", -1, -1));
            textureList.add((TextureFX)new CustomAnimation(238, 0, 2, "lava_flowing", 3, 6));
        } else if (animatedLava) {
            textureList.add((TextureFX)new bc());
            textureList.add((TextureFX)new fj());
        }
        if (!bl2 && customWater) {
            textureList.add((TextureFX)new CustomAnimation(205, 0, 1, "water_still", -1, -1));
            textureList.add((TextureFX)new CustomAnimation(206, 0, 2, "water_flowing", 0, 0));
        } else if (animatedWater) {
            textureList.add((TextureFX)new ou());
            textureList.add((TextureFX)new jn());
        }
        if (!bl2 && customFire && TextureUtils.hasResource("/custom_fire_e_w.png") && TextureUtils.hasResource("/custom_fire_n_s.png")) {
            textureList.add((TextureFX)new CustomAnimation(47, 0, 1, "fire_n_s", 2, 4));
            textureList.add((TextureFX)new CustomAnimation(31, 0, 1, "fire_e_w", 2, 4));
        } else if (animatedFire) {
            textureList.add((TextureFX)new me(0));
            textureList.add((TextureFX)new me(1));
        }
        if (!bl2 && customPortal && TextureUtils.hasResource("/custom_portal.png")) {
            textureList.add((TextureFX)new CustomAnimation(14, 0, 1, "portal", -1, -1));
        } else if (animatedPortal) {
            textureList.add((TextureFX)new fb());
        }
        for (ae ae3 : savedTextureFX) {
            textureList.add((TextureFX)ae3);
        }
        for (ae ae4 : textureList) {
            ae4.a();
        }
        if (gd.a != gd.a) {
            TextureUtils.refreshColorizer(gd.a, "/misc/watercolor.png");
        }
        TextureUtils.refreshColorizer(ff.a, "/misc/grasscolor.png");
        TextureUtils.refreshColorizer(gd.a, "/misc/foliagecolor.png");
        System.gc();
    }

    public static d getSelectedTexturePack() {
        return minecraft == null ? null : (TextureUtils.minecraft.C == null ? null : TextureUtils.minecraft.C.a);
    }

    public static String getTexturePackName(d texturePack) {
        return texturePack == null ? "Default" : texturePack.a;
    }

    public static ByteBuffer getByteBuffer(ByteBuffer buffer, byte[] data) {
        buffer.clear();
        int have = buffer.capacity();
        int needed = data.length;
        if (needed > have || have >= 4 * needed) {
            buffer = dz.b(needed);
        }
        buffer.put(data);
        buffer.position(0).limit(needed);
        TileSize.int_glBufferSize = needed;
        return buffer;
    }

    public static boolean isRequiredResource(String resource) {
        return !resource.startsWith("/custom_") && !resource.equals("/terrain_nh.png") && !resource.equals("/terrain_s.png");
    }

    public static InputStream getResourceAsStream(d texturePack, String resource) {
        InputStream is2 = null;
        if (texturePack != null) {
            try {
                is2 = texturePack.a(resource);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        if (is2 == null) {
            is2 = TextureUtils.class.getResourceAsStream(resource);
        }
        if (is2 == null && TextureUtils.isRequiredResource(resource)) {
            is2 = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
            MCPatcherUtils.warn("falling back on thread class loader for %s: %s", resource, is2 == null ? "failed" : "success");
        }
        return is2;
    }

    public static InputStream getResourceAsStream(String resource) {
        return TextureUtils.getResourceAsStream(TextureUtils.getSelectedTexturePack(), resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getResourceAsBufferedImage(d texturePack, String resource) throws IOException {
        InputStream is2;
        BufferedImage image = null;
        boolean cached = false;
        if (useTextureCache && texturePack == lastTexturePack && (image = cache.get(resource)) != null) {
            cached = true;
        }
        if (image == null && (is2 = TextureUtils.getResourceAsStream(texturePack, resource)) != null) {
            try {
                image = ImageIO.read(is2);
            }
            finally {
                MCPatcherUtils.close(is2);
            }
        }
        if (image == null) {
            if (TextureUtils.isRequiredResource(resource)) {
                throw new IOException(resource + " image is null");
            }
            return null;
        }
        if (useTextureCache && !cached && texturePack != lastTexturePack) {
            MCPatcherUtils.log("clearing texture cache (%d items)", cache.size());
            cache.clear();
        }
        MCPatcherUtils.log("opened %s %dx%d from %s", resource, image.getWidth(), image.getHeight(), cached ? "cache" : TextureUtils.getTexturePackName(texturePack));
        if (!cached) {
            Integer i2 = expectedColumns.get(resource);
            if (i2 != null && image.getWidth() != i2 * TileSize.int_size) {
                image = TextureUtils.resizeImage(image, i2 * TileSize.int_size);
            }
            if (useTextureCache) {
                lastTexturePack = texturePack;
                cache.put(resource, image);
            }
            if (resource.contains("_eyes.")) {
                int p2 = 0;
                for (int x2 = 0; x2 < image.getWidth(); ++x2) {
                    for (int y2 = 0; y2 < image.getHeight(); ++y2) {
                        int argb = image.getRGB(x2, y2);
                        if ((argb & 0xFF000000) != 0 || argb == 0) continue;
                        image.setRGB(x2, y2, 0);
                        ++p2;
                    }
                }
                MCPatcherUtils.log("  fixed %d transparent pixels", p2, resource);
            }
        }
        return image;
    }

    public static BufferedImage getResourceAsBufferedImage(String resource) throws IOException {
        return TextureUtils.getResourceAsBufferedImage(TextureUtils.getSelectedTexturePack(), resource);
    }

    public static BufferedImage getResourceAsBufferedImage(Object o1, Object o2, String resource) throws IOException {
        return TextureUtils.getResourceAsBufferedImage(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getTileSize(d texturePack) {
        int size = 0;
        for (Map.Entry<String, Integer> entry : expectedColumns.entrySet()) {
            InputStream is2;
            block5: {
                is2 = null;
                try {
                    is2 = TextureUtils.getResourceAsStream(texturePack, entry.getKey());
                    if (is2 == null) break block5;
                    BufferedImage bi2 = ImageIO.read(is2);
                    int newSize = bi2.getWidth() / entry.getValue();
                    MCPatcherUtils.log("  %s tile size is %d", entry.getKey(), newSize);
                    size = Math.max(size, newSize);
                }
                catch (Exception e2) {
                    try {
                        e2.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        MCPatcherUtils.close(is2);
                        throw throwable;
                    }
                    MCPatcherUtils.close(is2);
                    continue;
                }
            }
            MCPatcherUtils.close(is2);
        }
        return size > 0 ? size : 16;
    }

    public static int getTileSize() {
        return TextureUtils.getTileSize(TextureUtils.getSelectedTexturePack());
    }

    public static boolean hasResource(d texturePack, String resource) {
        InputStream is2 = TextureUtils.getResourceAsStream(texturePack, resource);
        boolean has = is2 != null;
        MCPatcherUtils.close(is2);
        return has;
    }

    public static boolean hasResource(String s2) {
        return TextureUtils.hasResource(TextureUtils.getSelectedTexturePack(), s2);
    }

    private static BufferedImage resizeImage(BufferedImage image, int width) {
        int height = image.getHeight() * width / image.getWidth();
        MCPatcherUtils.log("  resizing to %dx%d", width, height);
        BufferedImage newImage = new BufferedImage(width, height, 2);
        Graphics2D graphics2D = newImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, width, height, null);
        return newImage;
    }

    private static void refreshColorizer(int[] colorBuffer, String resource) {
        try {
            BufferedImage bi2 = TextureUtils.getResourceAsBufferedImage(resource);
            if (bi2 != null) {
                bi2.getRGB(0, 0, 256, 256, colorBuffer, 0, 256);
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public static void setMinecraft(Minecraft minecraft) {
        TextureUtils.minecraft = minecraft;
    }

    public static Minecraft getMinecraft() {
        return minecraft;
    }

    static {
        expectedColumns = new HashMap();
        lastTexturePack = null;
        cache = new HashMap();
        animatedFire = MCPatcherUtils.getBoolean("HD Textures", "animatedFire", true);
        animatedLava = MCPatcherUtils.getBoolean("HD Textures", "animatedLava", true);
        animatedWater = MCPatcherUtils.getBoolean("HD Textures", "animatedWater", true);
        animatedPortal = MCPatcherUtils.getBoolean("HD Textures", "animatedPortal", true);
        customFire = MCPatcherUtils.getBoolean("HD Textures", "customFire", true);
        customLava = MCPatcherUtils.getBoolean("HD Textures", "customLava", true);
        customWater = MCPatcherUtils.getBoolean("HD Textures", "customWater", true);
        customPortal = MCPatcherUtils.getBoolean("HD Textures", "customPortal", true);
        useTextureCache = MCPatcherUtils.getBoolean("HD Textures", "useTextureCache", false);
        expectedColumns.put("/terrain.png", 16);
        expectedColumns.put("/gui/items.png", 16);
        expectedColumns.put("/misc/dial.png", 1);
        expectedColumns.put("/custom_lava_still.png", 1);
        expectedColumns.put("/custom_lava_flowing.png", 1);
        expectedColumns.put("/custom_water_still.png", 1);
        expectedColumns.put("/custom_water_flowing.png", 1);
        expectedColumns.put("/custom_fire_n_s.png", 1);
        expectedColumns.put("/custom_fire_e_w.png", 1);
        expectedColumns.put("/custom_portal.png", 1);
    }
}

