/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import java.applet.Applet;
import java.applet.AppletStub;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.util.HashMap;
import java.util.Map;
import legacyfix.LegacyURLStreamHandlerFactory;
import uk.betacraft.mcwrapper.BCWrapper;
import uk.betacraft.mcwrapper.applet.AppletUtils;

public class Launcher
extends Applet
implements AppletStub {
    private static final long serialVersionUID = 2031802022722032801L;
    public Map<String, String> applet_parameters = new HashMap<String, String>();
    public Applet game_applet;
    public int width;
    public int height;
    private boolean active = false;
    private int context = 0;

    public Launcher(Applet game_applet, int x, int y) {
        this.width = x;
        this.height = y;
        this.game_applet = game_applet;
        this.game_applet.setStub(this);
        this.game_applet.setSize(this.width, this.height);
        this.setLayout(new BorderLayout());
        this.add((Component)this.game_applet, "Center");
    }

    public boolean setAppletParameter(String param, String value) {
        String lastValue = this.getParameter(param);
        if (lastValue != null) {
            System.out.println("Warning: The applet parameter \"" + param + "\" was overwrote from \"" + lastValue + "\" to \"" + value + "\".");
        }
        return this.setAppletParameter(param, value, true);
    }

    public boolean setAppletParameter(String param, String value, boolean force) {
        if (this.applet_parameters.containsKey(param) && !force) {
            return false;
        }
        this.applet_parameters.put(param, value);
        return true;
    }

    public String getParameter(String param) {
        if (this.active) {
            System.out.println("Client asked for parameter: " + param);
        }
        if (!this.applet_parameters.containsKey(param)) {
            return null;
        }
        return this.applet_parameters.get(param);
    }

    public void replace(Applet game_applet) {
        this.game_applet = game_applet;
        this.game_applet.setStub(this);
        this.game_applet.setSize(this.width, this.height);
        this.setLayout(new BorderLayout());
        this.add((Component)this.game_applet, "Center");
        this.init();
        this.start();
        this.validate();
    }

    public void init() {
        this.active = true;
        this.game_applet.init();
        if (!"true".equals(System.getProperty("lf.present", "false"))) {
            this.applyFixes();
        }
    }

    public void applyFixes() {
        boolean result;
        boolean cant_accept_server_from_applet;
        System.out.println("Applying fixes...");
        boolean disable_appletMode = System.getProperty("betacraft.disable_appletMode") != null;
        boolean force_resolution = System.getProperty("betacraft.force_resolution") != null;
        boolean force_fullscreen = System.getProperty("betacraft.force_fullscreen") != null;
        boolean bl = cant_accept_server_from_applet = System.getProperty("betacraft.cant_accept_server_from_applet") != null;
        if (disable_appletMode || force_fullscreen) {
            System.out.println("Disabling appletMode...");
            result = AppletUtils.disableAppletMode(this.game_applet, System.getProperty("betacraft.applet.game_field"), System.getProperty("betacraft.applet.appletMode_field"));
            System.out.println(result ? "Disabled appletMode." : "Failed to disable appletMode");
        }
        if (force_resolution) {
            System.out.println("Forcing custom resolution...");
            result = AppletUtils.setResolution(this.game_applet, System.getProperty("betacraft.applet.game_field"), System.getProperty("betacraft.applet.width_field"), System.getProperty("betacraft.applet.height_field"), this.width, this.height);
            System.out.println(result ? "Forced custom resolution." : "Failed to force resolution");
        }
        if (force_fullscreen) {
            System.out.println("Forcing fullscreen...");
            result = AppletUtils.setFullscreen(this.game_applet, System.getProperty("betacraft.applet.game_field"), System.getProperty("betacraft.applet.fullscreen_field"), System.getProperty("betacraft.applet.canvas_field"), true);
            System.out.println(result ? "Forced fullscreen." : "Failed to force fullscreen");
        }
        if (cant_accept_server_from_applet) {
            System.out.println("Manually setting server...");
            result = AppletUtils.setServer(this.game_applet, System.getProperty("betacraft.applet.game_field"), System.getProperty("betacraft.applet.server_field"), System.getProperty("betacraft.server_class"), System.getProperty("betacraft.server_constructor_arguments"));
            System.out.println(result ? "Set the server." : "Failed to set the server");
        }
    }

    public void start() {
        try {
            URL.setURLStreamHandlerFactory((URLStreamHandlerFactory)new LegacyURLStreamHandlerFactory());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.game_applet.start();
    }

    public void stop() {
        this.active = false;
        this.game_applet.stop();
    }

    public void destroy() {
        this.game_applet.destroy();
    }

    public boolean isActive() {
        return this.active;
    }

    public URL getDocumentBase() {
        try {
            int port = this.game_applet.getClass().getCanonicalName().startsWith("com.mojang") ? 80 : -1;
            URL url = new URL("http", "www.minecraft.net", port, "/game/");
            return url;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public URL getCodeBase() {
        try {
            return new URL("http", "www.minecraft.net", 80, "/game/");
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public Dimension getMinimumSize() {
        String widthstr = BCWrapper.arguments.get("minWidth");
        String heightstr = BCWrapper.arguments.get("minHeight");
        Integer width = null;
        if (widthstr != null) {
            width = Integer.parseInt(widthstr);
        }
        Integer height = null;
        if (heightstr != null) {
            height = Integer.parseInt(heightstr);
        }
        if (width != null && height != null) {
            return new Dimension(width, height);
        }
        if (width != null) {
            return new Dimension(width, (int)super.getMinimumSize().getHeight());
        }
        if (height != null) {
            return new Dimension((int)super.getMinimumSize().getWidth(), height);
        }
        return super.getMinimumSize();
    }

    public Dimension getMaximumSize() {
        String widthstr = BCWrapper.arguments.get("maxWidth");
        String heightstr = BCWrapper.arguments.get("maxHeight");
        Integer width = null;
        if (widthstr != null) {
            width = Integer.parseInt(widthstr);
        }
        Integer height = null;
        if (heightstr != null) {
            height = Integer.parseInt(heightstr);
        }
        if (width != null && height != null) {
            return new Dimension(width, height);
        }
        if (width != null) {
            return new Dimension(width, (int)super.getMaximumSize().getHeight());
        }
        if (height != null) {
            return new Dimension((int)super.getMaximumSize().getWidth(), height);
        }
        return super.getMaximumSize();
    }

    public void appletResize(int width, int height) {
    }
}

