/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.generator.opengl;

import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeKind;
import org.lwjgl.PointerBuffer;
import org.lwjgl.util.generator.NativeTypeTranslator;
import org.lwjgl.util.generator.PointerWrapper;
import org.lwjgl.util.generator.Signedness;
import org.lwjgl.util.generator.TypeMap;
import org.lwjgl.util.generator.opengl.GLbitfield;
import org.lwjgl.util.generator.opengl.GLboolean;
import org.lwjgl.util.generator.opengl.GLbyte;
import org.lwjgl.util.generator.opengl.GLchar;
import org.lwjgl.util.generator.opengl.GLcharARB;
import org.lwjgl.util.generator.opengl.GLclampd;
import org.lwjgl.util.generator.opengl.GLclampf;
import org.lwjgl.util.generator.opengl.GLdouble;
import org.lwjgl.util.generator.opengl.GLenum;
import org.lwjgl.util.generator.opengl.GLfloat;
import org.lwjgl.util.generator.opengl.GLhalf;
import org.lwjgl.util.generator.opengl.GLhandleARB;
import org.lwjgl.util.generator.opengl.GLint;
import org.lwjgl.util.generator.opengl.GLint64;
import org.lwjgl.util.generator.opengl.GLint64EXT;
import org.lwjgl.util.generator.opengl.GLintptr;
import org.lwjgl.util.generator.opengl.GLintptrARB;
import org.lwjgl.util.generator.opengl.GLreturn;
import org.lwjgl.util.generator.opengl.GLshort;
import org.lwjgl.util.generator.opengl.GLsizei;
import org.lwjgl.util.generator.opengl.GLsizeiptr;
import org.lwjgl.util.generator.opengl.GLsizeiptrARB;
import org.lwjgl.util.generator.opengl.GLubyte;
import org.lwjgl.util.generator.opengl.GLuint;
import org.lwjgl.util.generator.opengl.GLuint64;
import org.lwjgl.util.generator.opengl.GLuint64EXT;
import org.lwjgl.util.generator.opengl.GLushort;
import org.lwjgl.util.generator.opengl.GLvoid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GLTypeMap
implements TypeMap {
    private static final Map<Class, TypeKind> native_types_to_primitive = new HashMap<Class, TypeKind>();

    public TypeKind getPrimitiveTypeFromNativeType(Class native_type) {
        TypeKind kind = native_types_to_primitive.get(native_type);
        if (kind == null) {
            throw new RuntimeException("Unsupported type " + native_type);
        }
        return kind;
    }

    @Override
    public void printCapabilitiesInit(PrintWriter writer) {
        writer.println("\t\tContextCapabilities caps = GLContext.getCapabilities();");
    }

    @Override
    public String getCapabilities() {
        return "caps";
    }

    @Override
    public String getAPIUtilParam(boolean comma) {
        return comma ? "caps, " : "caps";
    }

    @Override
    public void printErrorCheckMethod(PrintWriter writer, ExecutableElement method, String tabs) {
        writer.println(tabs + "Util.checkGLError();");
    }

    @Override
    public String getRegisterNativesFunctionName() {
        return "extgl_InitializeClass";
    }

    public Signedness getSignednessFromType(Class type) {
        if (GLuint.class.equals((Object)type)) {
            return Signedness.UNSIGNED;
        }
        if (GLint.class.equals((Object)type)) {
            return Signedness.SIGNED;
        }
        if (GLushort.class.equals((Object)type)) {
            return Signedness.UNSIGNED;
        }
        if (GLshort.class.equals((Object)type)) {
            return Signedness.SIGNED;
        }
        if (GLubyte.class.equals((Object)type)) {
            return Signedness.UNSIGNED;
        }
        if (GLbyte.class.equals((Object)type)) {
            return Signedness.SIGNED;
        }
        if (GLuint64EXT.class.equals((Object)type)) {
            return Signedness.UNSIGNED;
        }
        if (GLint64EXT.class.equals((Object)type)) {
            return Signedness.SIGNED;
        }
        if (GLuint64.class.equals((Object)type)) {
            return Signedness.UNSIGNED;
        }
        if (GLint64.class.equals((Object)type)) {
            return Signedness.SIGNED;
        }
        return Signedness.NONE;
    }

    public String translateAnnotation(Class annotation_type) {
        if (annotation_type.equals(GLuint.class) || annotation_type.equals(GLint.class)) {
            return "i";
        }
        if (annotation_type.equals(GLushort.class) || annotation_type.equals(GLshort.class)) {
            return "s";
        }
        if (annotation_type.equals(GLubyte.class) || annotation_type.equals(GLbyte.class)) {
            return "b";
        }
        if (annotation_type.equals(GLfloat.class) || annotation_type.equals(GLclampf.class)) {
            return "f";
        }
        if (annotation_type.equals(GLdouble.class) || annotation_type.equals(GLclampd.class)) {
            return "d";
        }
        if (annotation_type.equals(GLhalf.class)) {
            return "h";
        }
        if (annotation_type.equals(GLuint64EXT.class) || annotation_type.equals(GLint64EXT.class) || annotation_type.equals(GLuint64.class) || annotation_type.equals(GLint64.class)) {
            return "i64";
        }
        if (annotation_type.equals(GLboolean.class) || annotation_type.equals(GLvoid.class)) {
            return "";
        }
        throw new RuntimeException(annotation_type + " is not allowed");
    }

    @Override
    public Class getNativeTypeFromPrimitiveType(TypeKind kind) {
        Class type;
        switch (kind) {
            case INT: {
                type = GLint.class;
                break;
            }
            case DOUBLE: {
                type = GLdouble.class;
                break;
            }
            case FLOAT: {
                type = GLfloat.class;
                break;
            }
            case SHORT: {
                type = GLshort.class;
                break;
            }
            case BYTE: {
                type = GLbyte.class;
                break;
            }
            case LONG: {
                type = GLint64EXT.class;
                break;
            }
            case BOOLEAN: {
                type = GLboolean.class;
                break;
            }
            default: {
                throw new RuntimeException((Object)((Object)kind) + " is not allowed");
            }
        }
        return type;
    }

    @Override
    public Class<? extends Annotation> getVoidType() {
        return GLvoid.class;
    }

    @Override
    public Class<? extends Annotation> getStringElementType() {
        return GLubyte.class;
    }

    @Override
    public Class<? extends Annotation> getStringArrayType() {
        return GLchar.class;
    }

    @Override
    public Class<? extends Annotation> getByteBufferArrayType() {
        return GLchar.class;
    }

    private static Class[] getValidBufferTypes(Class type) {
        if (type.equals(IntBuffer.class)) {
            return new Class[]{GLbitfield.class, GLenum.class, GLhandleARB.class, GLint.class, GLsizei.class, GLuint.class, GLvoid.class};
        }
        if (type.equals(FloatBuffer.class)) {
            return new Class[]{GLclampf.class, GLfloat.class};
        }
        if (type.equals(ByteBuffer.class)) {
            return new Class[]{GLboolean.class, GLbyte.class, GLcharARB.class, GLchar.class, GLubyte.class, GLvoid.class};
        }
        if (type.equals(ShortBuffer.class)) {
            return new Class[]{GLhalf.class, GLshort.class, GLushort.class};
        }
        if (type.equals(DoubleBuffer.class)) {
            return new Class[]{GLclampd.class, GLdouble.class};
        }
        if (type.equals(LongBuffer.class)) {
            return new Class[]{GLint64EXT.class, GLuint64EXT.class, GLint64.class, GLuint64.class};
        }
        return new Class[0];
    }

    private static Class[] getValidPrimitiveTypes(Class type) {
        if (type.equals(Long.TYPE)) {
            return new Class[]{GLintptrARB.class, GLuint.class, GLintptr.class, GLsizeiptrARB.class, GLsizeiptr.class, GLint64EXT.class, GLuint64EXT.class, GLint64.class, GLuint64.class};
        }
        if (type.equals(Integer.TYPE)) {
            return new Class[]{GLbitfield.class, GLenum.class, GLhandleARB.class, GLint.class, GLuint.class, GLsizei.class};
        }
        if (type.equals(Double.TYPE)) {
            return new Class[]{GLclampd.class, GLdouble.class};
        }
        if (type.equals(Float.TYPE)) {
            return new Class[]{GLclampf.class, GLfloat.class};
        }
        if (type.equals(Short.TYPE)) {
            return new Class[]{GLhalf.class, GLshort.class, GLushort.class};
        }
        if (type.equals(Byte.TYPE)) {
            return new Class[]{GLbyte.class, GLcharARB.class, GLchar.class, GLubyte.class};
        }
        if (type.equals(Boolean.TYPE)) {
            return new Class[]{GLboolean.class};
        }
        if (type.equals(Void.TYPE)) {
            return new Class[]{GLvoid.class, GLreturn.class};
        }
        return new Class[0];
    }

    @Override
    public String getTypedefPostfix() {
        return "";
    }

    @Override
    public String getFunctionPrefix() {
        return "APIENTRY";
    }

    @Override
    public void printNativeIncludes(PrintWriter writer) {
        writer.println("#include \"extgl.h\"");
    }

    @Override
    public Class[] getValidAnnotationTypes(Class type) {
        Class[] valid_types = Buffer.class.isAssignableFrom(type) ? GLTypeMap.getValidBufferTypes(type) : (type.isPrimitive() ? GLTypeMap.getValidPrimitiveTypes(type) : (String.class.equals((Object)type) ? new Class[]{GLubyte.class} : (org.lwjgl.PointerWrapper.class.isAssignableFrom(type) ? new Class[]{PointerWrapper.class} : (Void.TYPE.equals(type) ? new Class[]{GLreturn.class} : (PointerBuffer.class.equals((Object)type) ? new Class[]{GLintptr.class, GLintptrARB.class, GLsizeiptr.class, GLsizeiptrARB.class} : new Class[]{})))));
        return valid_types;
    }

    public Class<? extends Annotation> getInverseType(Class type) {
        if (GLuint.class.equals((Object)type)) {
            return GLint.class;
        }
        if (GLint.class.equals((Object)type)) {
            return GLuint.class;
        }
        if (GLushort.class.equals((Object)type)) {
            return GLshort.class;
        }
        if (GLshort.class.equals((Object)type)) {
            return GLushort.class;
        }
        if (GLubyte.class.equals((Object)type)) {
            return GLbyte.class;
        }
        if (GLbyte.class.equals((Object)type)) {
            return GLubyte.class;
        }
        if (GLuint64EXT.class.equals((Object)type)) {
            return GLint64EXT.class;
        }
        if (GLint64EXT.class.equals((Object)type)) {
            return GLuint64EXT.class;
        }
        if (GLuint64.class.equals((Object)type)) {
            return GLint64.class;
        }
        if (GLint64.class.equals((Object)type)) {
            return GLuint64.class;
        }
        return null;
    }

    @Override
    public String getAutoTypeFromAnnotation(AnnotationMirror annotation) {
        Class<? extends Annotation> annotation_class = NativeTypeTranslator.getClassFromType(annotation.getAnnotationType());
        if (annotation_class.equals(GLint.class)) {
            return "GL11.GL_INT";
        }
        if (annotation_class.equals(GLbyte.class)) {
            return "GL11.GL_BYTE";
        }
        if (annotation_class.equals(GLshort.class)) {
            return "GL11.GL_SHORT";
        }
        if (annotation_class.equals(GLuint.class)) {
            return "GL11.GL_UNSIGNED_INT";
        }
        if (annotation_class.equals(GLubyte.class)) {
            return "GL11.GL_UNSIGNED_BYTE";
        }
        if (annotation_class.equals(GLushort.class)) {
            return "GL11.GL_UNSIGNED_SHORT";
        }
        if (annotation_class.equals(GLfloat.class)) {
            return "GL11.GL_FLOAT";
        }
        if (annotation_class.equals(GLdouble.class)) {
            return "GL11.GL_DOUBLE";
        }
        return null;
    }

    static {
        native_types_to_primitive.put(GLbitfield.class, TypeKind.INT);
        native_types_to_primitive.put(GLcharARB.class, TypeKind.BYTE);
        native_types_to_primitive.put(GLclampf.class, TypeKind.FLOAT);
        native_types_to_primitive.put(GLfloat.class, TypeKind.FLOAT);
        native_types_to_primitive.put(GLint.class, TypeKind.INT);
        native_types_to_primitive.put(GLshort.class, TypeKind.SHORT);
        native_types_to_primitive.put(GLsizeiptr.class, TypeKind.LONG);
        native_types_to_primitive.put(GLuint.class, TypeKind.INT);
        native_types_to_primitive.put(GLboolean.class, TypeKind.BOOLEAN);
        native_types_to_primitive.put(GLchar.class, TypeKind.BYTE);
        native_types_to_primitive.put(GLdouble.class, TypeKind.DOUBLE);
        native_types_to_primitive.put(GLhalf.class, TypeKind.SHORT);
        native_types_to_primitive.put(GLintptrARB.class, TypeKind.LONG);
        native_types_to_primitive.put(GLsizei.class, TypeKind.INT);
        native_types_to_primitive.put(GLushort.class, TypeKind.SHORT);
        native_types_to_primitive.put(GLbyte.class, TypeKind.BYTE);
        native_types_to_primitive.put(GLclampd.class, TypeKind.DOUBLE);
        native_types_to_primitive.put(GLenum.class, TypeKind.INT);
        native_types_to_primitive.put(GLhandleARB.class, TypeKind.INT);
        native_types_to_primitive.put(GLintptr.class, TypeKind.LONG);
        native_types_to_primitive.put(GLsizeiptrARB.class, TypeKind.LONG);
        native_types_to_primitive.put(GLubyte.class, TypeKind.BYTE);
        native_types_to_primitive.put(GLvoid.class, TypeKind.BYTE);
        native_types_to_primitive.put(GLint64EXT.class, TypeKind.LONG);
        native_types_to_primitive.put(GLuint64EXT.class, TypeKind.LONG);
        native_types_to_primitive.put(GLint64.class, TypeKind.LONG);
        native_types_to_primitive.put(GLuint64.class, TypeKind.LONG);
    }
}

