/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.generator.opengl;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import org.lwjgl.util.generator.Alternate;
import org.lwjgl.util.generator.CachedReference;
import org.lwjgl.util.generator.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedAnnotationTypes(value={"*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_5)
@SupportedOptions(value={"generatechecks", "contextspecific"})
public class GLReferencesGeneratorProcessor
extends AbstractProcessor {
    private static final String REFERENCES_CLASS_NAME = "References";
    private static final String REFERENCES_PARAMETER_NAME = "references";
    private static boolean first_round = true;

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver() || !first_round) {
            System.exit(0);
            return true;
        }
        try {
            this.generateReferencesSource(this.processingEnv, ElementFilter.typesIn(roundEnv.getRootElements()));
            first_round = false;
            return true;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void generateClearsFromParameters(PrintWriter writer, TypeElement interface_decl, ExecutableElement method) {
        for (VariableElement variableElement : method.getParameters()) {
            CachedReference cached_reference_annotation = variableElement.getAnnotation(CachedReference.class);
            if (cached_reference_annotation == null || cached_reference_annotation.name().length() != 0) continue;
            Class<?> nio_type = Utils.getNIOBufferType(variableElement.asType());
            String reference_name = Utils.getReferenceName(interface_decl, method, variableElement);
            writer.println("\t\tthis." + reference_name + " = null;");
        }
    }

    private static void generateCopiesFromParameters(PrintWriter writer, TypeElement interface_decl, ExecutableElement method) {
        for (VariableElement variableElement : method.getParameters()) {
            CachedReference cached_reference_annotation = variableElement.getAnnotation(CachedReference.class);
            if (cached_reference_annotation == null || cached_reference_annotation.name().length() != 0) continue;
            Class<?> nio_type = Utils.getNIOBufferType(variableElement.asType());
            String reference_name = Utils.getReferenceName(interface_decl, method, variableElement);
            writer.print("\t\t\tthis." + reference_name + " = ");
            writer.println("references." + reference_name + ";");
        }
    }

    private static void generateClearsFromMethods(ProcessingEnvironment env, PrintWriter writer, TypeElement interface_decl) {
        for (ExecutableElement method : Utils.getMethods(interface_decl)) {
            if (method.getAnnotation(Alternate.class) != null) continue;
            GLReferencesGeneratorProcessor.generateClearsFromParameters(writer, interface_decl, method);
        }
    }

    private static void generateCopiesFromMethods(ProcessingEnvironment env, PrintWriter writer, TypeElement interface_decl) {
        for (ExecutableElement method : Utils.getMethods(interface_decl)) {
            if (method.getAnnotation(Alternate.class) != null) continue;
            GLReferencesGeneratorProcessor.generateCopiesFromParameters(writer, interface_decl, method);
        }
    }

    private static void generateReferencesFromParameters(PrintWriter writer, TypeElement interface_decl, ExecutableElement method) {
        for (VariableElement variableElement : method.getParameters()) {
            CachedReference cached_reference_annotation = variableElement.getAnnotation(CachedReference.class);
            if (cached_reference_annotation == null || cached_reference_annotation.name().length() != 0) continue;
            Class<?> nio_type = Utils.getNIOBufferType(variableElement.asType());
            if (nio_type == null) {
                throw new RuntimeException(variableElement + " in method " + method + " in " + interface_decl + " is annotated with " + cached_reference_annotation.annotationType().getSimpleName() + " but the parameter is not a NIO buffer");
            }
            writer.print("\t" + nio_type.getName() + " " + Utils.getReferenceName(interface_decl, method, variableElement));
            writer.println(";");
        }
    }

    private static void generateReferencesFromMethods(ProcessingEnvironment env, PrintWriter writer, TypeElement interface_decl) {
        for (ExecutableElement method : Utils.getMethods(interface_decl)) {
            if (method.getAnnotation(Alternate.class) != null) continue;
            GLReferencesGeneratorProcessor.generateReferencesFromParameters(writer, interface_decl, method);
        }
    }

    private void generateReferencesSource(ProcessingEnvironment env, Set<TypeElement> templates) throws IOException {
        PrintWriter writer = new PrintWriter(this.processingEnv.getFiler().createSourceFile("org.lwjgl.opengl.References", this.processingEnv.getElementUtils().getPackageElement("org.lwjgl.opengl")).openWriter());
        writer.println("/* MACHINE GENERATED FILE, DO NOT EDIT */");
        writer.println();
        writer.println("package org.lwjgl.opengl;");
        writer.println();
        writer.println("class References extends BaseReferences {");
        writer.println("\tReferences(ContextCapabilities caps) {");
        writer.println("\t\tsuper(caps);");
        writer.println("\t}");
        for (TypeElement interface_decl : templates) {
            if (!interface_decl.getKind().isInterface()) continue;
            GLReferencesGeneratorProcessor.generateReferencesFromMethods(env, writer, interface_decl);
        }
        writer.println();
        writer.println("\tvoid copy(References references, int mask) {");
        writer.println("\t\tsuper.copy(references, mask);");
        writer.println("\t\tif ( (mask & GL11.GL_CLIENT_VERTEX_ARRAY_BIT) != 0 ) {");
        for (TypeElement interface_decl : templates) {
            if (!interface_decl.getKind().isInterface()) continue;
            GLReferencesGeneratorProcessor.generateCopiesFromMethods(this.processingEnv, writer, interface_decl);
        }
        writer.println("\t\t}");
        writer.println("\t}");
        writer.println("\tvoid clear() {");
        writer.println("\t\tsuper.clear();");
        for (TypeElement interface_decl : templates) {
            if (!interface_decl.getKind().isInterface()) continue;
            GLReferencesGeneratorProcessor.generateClearsFromMethods(this.processingEnv, writer, interface_decl);
        }
        writer.println("\t}");
        writer.println("}");
        writer.close();
    }
}

