/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.generator.opengl;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.lwjgl.util.generator.Utils;
import org.lwjgl.util.generator.opengl.GLESCapabilitiesGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedAnnotationTypes(value={"*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_5)
@SupportedOptions(value={"contextspecific", "generatechecks"})
public class GLESGeneratorProcessor
extends AbstractProcessor {
    private static boolean first_round = true;

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver() || !first_round) {
            System.exit(0);
            return true;
        }
        Map<String, String> options = this.processingEnv.getOptions();
        boolean generate_error_checks = options.containsKey("generatechecks");
        boolean context_specific = options.containsKey("contextspecific");
        try {
            this.generateContextCapabilitiesSource(ElementFilter.typesIn(roundEnv.getRootElements()), context_specific, generate_error_checks);
            first_round = false;
            return true;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void generateContextCapabilitiesSource(Set<TypeElement> templates, boolean context_specific, boolean generate_error_checks) throws IOException {
        PrintWriter writer = new PrintWriter(this.processingEnv.getFiler().createSourceFile("org.lwjgl.opengles.ContextCapabilities", this.processingEnv.getElementUtils().getPackageElement("org.lwjgl.opengles")).openWriter());
        writer.println("/* MACHINE GENERATED FILE, DO NOT EDIT */");
        writer.println();
        writer.println("package org.lwjgl.opengles;");
        writer.println();
        writer.println("import org.lwjgl.LWJGLException;");
        writer.println("import org.lwjgl.LWJGLUtil;");
        writer.println("import java.util.Set;");
        writer.println("import java.util.HashSet;");
        writer.println();
        GLESCapabilitiesGenerator.generateClassPrologue(writer, context_specific, generate_error_checks);
        for (TypeElement interface_decl : templates) {
            if (!interface_decl.getKind().isInterface() || !Utils.isFinal(interface_decl)) continue;
            GLESCapabilitiesGenerator.generateField(writer, interface_decl);
        }
        writer.println();
        if (context_specific) {
            for (TypeElement interface_decl : templates) {
                if (!interface_decl.getKind().isInterface()) continue;
                GLESCapabilitiesGenerator.generateSymbolAddresses(this.processingEnv, writer, interface_decl);
            }
            writer.println();
            for (TypeElement interface_decl : templates) {
                if (!interface_decl.getKind().isInterface()) continue;
                GLESCapabilitiesGenerator.generateAddressesInitializers(this.processingEnv, writer, interface_decl);
            }
            writer.println();
        }
        if (context_specific) {
            writer.println("\tprivate static void remove(Set supported_extensions, String extension) {");
            writer.println("\t\tLWJGLUtil.log(extension + \" was reported as available but an entry point is missing\");");
            writer.println("\t\tsupported_extensions.remove(extension);");
            writer.println("\t}\n");
        }
        GLESCapabilitiesGenerator.generateInitStubsPrologue(writer, context_specific);
        for (TypeElement interface_decl : templates) {
            if (!interface_decl.getKind().isInterface()) continue;
            GLESCapabilitiesGenerator.generateSuperClassAdds(writer, interface_decl, this.processingEnv);
        }
        for (TypeElement interface_decl : templates) {
            if (!interface_decl.getKind().isInterface() || "GLES20".equals(interface_decl.getSimpleName().toString())) continue;
            GLESCapabilitiesGenerator.generateInitStubs(this.processingEnv, writer, interface_decl, context_specific);
        }
        GLESCapabilitiesGenerator.generateInitStubsEpilogue(writer, context_specific);
        writer.println();
        writer.println("\tstatic void unloadAllStubs() {");
        if (!context_specific) {
            writer.println("\t\tif (!loaded_stubs)");
            writer.println("\t\t\treturn;");
            for (TypeElement interface_decl : templates) {
                if (!interface_decl.getKind().isInterface()) continue;
                GLESCapabilitiesGenerator.generateUnloadStubs(this.processingEnv, writer, interface_decl);
            }
            writer.println("\t\tloaded_stubs = false;");
        }
        writer.println("\t}");
        writer.println();
        GLESCapabilitiesGenerator.generateInitializerPrologue(writer);
        for (TypeElement interface_decl : templates) {
            if (!interface_decl.getKind().isInterface() || !Utils.isFinal(interface_decl)) continue;
            GLESCapabilitiesGenerator.generateInitializer(writer, interface_decl, this.processingEnv);
        }
        writer.println("\t}");
        writer.println("}");
        writer.close();
    }
}

