/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.generator.opencl;

import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import org.lwjgl.PointerBuffer;
import org.lwjgl.util.generator.Check;
import org.lwjgl.util.generator.PointerWrapper;
import org.lwjgl.util.generator.Signedness;
import org.lwjgl.util.generator.TypeMap;
import org.lwjgl.util.generator.Utils;
import org.lwjgl.util.generator.opencl.cl_bitfield;
import org.lwjgl.util.generator.opencl.cl_bool;
import org.lwjgl.util.generator.opencl.cl_byte;
import org.lwjgl.util.generator.opencl.cl_char;
import org.lwjgl.util.generator.opencl.cl_double;
import org.lwjgl.util.generator.opencl.cl_float;
import org.lwjgl.util.generator.opencl.cl_int;
import org.lwjgl.util.generator.opencl.cl_long;
import org.lwjgl.util.generator.opencl.cl_short;
import org.lwjgl.util.generator.opencl.cl_uchar;
import org.lwjgl.util.generator.opencl.cl_uint;
import org.lwjgl.util.generator.opencl.cl_void;
import org.lwjgl.util.generator.opencl.size_t;
import org.lwjgl.util.generator.opengl.GLreturn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLTypeMap
implements TypeMap {
    private static final Map<Class, TypeKind> native_types_to_primitive = new HashMap<Class, TypeKind>();

    public TypeKind getPrimitiveTypeFromNativeType(Class native_type) {
        TypeKind kind = native_types_to_primitive.get(native_type);
        if (kind == null) {
            throw new RuntimeException("Unsupported type " + native_type);
        }
        return kind;
    }

    @Override
    public void printCapabilitiesInit(PrintWriter writer) {
    }

    @Override
    public String getCapabilities() {
        return "CLCapabilities";
    }

    @Override
    public String getAPIUtilParam(boolean comma) {
        return "";
    }

    @Override
    public void printErrorCheckMethod(PrintWriter writer, ExecutableElement method, String tabs) {
        Check check = method.getAnnotation(Check.class);
        if (check != null) {
            writer.println(tabs + "Util.checkCLError(" + check.value() + ".get(" + check.value() + ".position()));");
        } else {
            Class return_type = Utils.getJavaType(method.getReturnType());
            if (return_type == Integer.TYPE) {
                writer.println(tabs + "Util.checkCLError(__result);");
            } else {
                boolean hasErrCodeParam = false;
                for (VariableElement variableElement : method.getParameters()) {
                    if (!"errcode_ret".equals(variableElement.getSimpleName().toString()) || Utils.getJavaType(variableElement.asType()) != IntBuffer.class) continue;
                    hasErrCodeParam = true;
                    break;
                }
                if (hasErrCodeParam) {
                    throw new RuntimeException("A method is missing the @Check annotation: " + method.toString());
                }
            }
        }
    }

    @Override
    public String getRegisterNativesFunctionName() {
        return "extcl_InitializeClass";
    }

    public Signedness getSignednessFromType(Class type) {
        if (cl_uint.class.equals((Object)type)) {
            return Signedness.UNSIGNED;
        }
        if (cl_int.class.equals((Object)type)) {
            return Signedness.SIGNED;
        }
        return Signedness.NONE;
    }

    public String translateAnnotation(Class annotation_type) {
        if (annotation_type.equals(cl_uint.class) || annotation_type.equals(cl_int.class)) {
            return "i";
        }
        if (annotation_type.equals(cl_short.class)) {
            return "s";
        }
        if (annotation_type.equals(cl_byte.class)) {
            return "b";
        }
        if (annotation_type.equals(cl_float.class)) {
            return "f";
        }
        if (annotation_type.equals(cl_double.class)) {
            return "d";
        }
        throw new RuntimeException(annotation_type + " is not allowed");
    }

    @Override
    public Class getNativeTypeFromPrimitiveType(TypeKind kind) {
        Class type;
        switch (kind) {
            case INT: {
                type = cl_int.class;
                break;
            }
            case DOUBLE: {
                type = cl_double.class;
                break;
            }
            case FLOAT: {
                type = cl_float.class;
                break;
            }
            case SHORT: {
                type = cl_short.class;
                break;
            }
            case BYTE: {
                type = cl_byte.class;
                break;
            }
            case LONG: {
                type = cl_long.class;
                break;
            }
            case BOOLEAN: {
                type = cl_bool.class;
                break;
            }
            default: {
                throw new RuntimeException((Object)((Object)kind) + " is not allowed");
            }
        }
        return type;
    }

    @Override
    public Class<? extends Annotation> getVoidType() {
        return cl_void.class;
    }

    @Override
    public Class<? extends Annotation> getStringElementType() {
        return cl_char.class;
    }

    @Override
    public Class<? extends Annotation> getStringArrayType() {
        return cl_char.class;
    }

    @Override
    public Class<? extends Annotation> getByteBufferArrayType() {
        return cl_uchar.class;
    }

    private static Class[] getValidBufferTypes(Class type) {
        if (type.equals(IntBuffer.class)) {
            return new Class[]{cl_int.class, cl_uint.class};
        }
        if (type.equals(FloatBuffer.class)) {
            return new Class[]{cl_float.class};
        }
        if (type.equals(ByteBuffer.class)) {
            return new Class[]{cl_byte.class, cl_char.class, cl_uchar.class, cl_void.class};
        }
        if (type.equals(ShortBuffer.class)) {
            return new Class[]{cl_short.class};
        }
        if (type.equals(DoubleBuffer.class)) {
            return new Class[]{cl_double.class};
        }
        if (type.equals(LongBuffer.class)) {
            return new Class[]{cl_long.class};
        }
        if (type.equals(PointerBuffer.class)) {
            return new Class[]{size_t.class};
        }
        return new Class[0];
    }

    private static Class[] getValidPrimitiveTypes(Class type) {
        if (type.equals(Long.TYPE)) {
            return new Class[]{cl_long.class, size_t.class, cl_bitfield.class};
        }
        if (type.equals(Integer.TYPE)) {
            return new Class[]{cl_int.class, cl_uint.class, cl_bool.class};
        }
        if (type.equals(Double.TYPE)) {
            return new Class[]{cl_double.class};
        }
        if (type.equals(Float.TYPE)) {
            return new Class[]{cl_float.class};
        }
        if (type.equals(Short.TYPE)) {
            return new Class[]{cl_short.class};
        }
        if (type.equals(Byte.TYPE)) {
            return new Class[]{cl_byte.class, cl_char.class, cl_uchar.class};
        }
        if (type.equals(Boolean.TYPE)) {
            return new Class[]{cl_bool.class};
        }
        if (type.equals(Void.TYPE)) {
            return new Class[]{cl_void.class};
        }
        return new Class[0];
    }

    @Override
    public String getTypedefPostfix() {
        return "CL_API_ENTRY ";
    }

    @Override
    public String getFunctionPrefix() {
        return "CL_API_CALL";
    }

    @Override
    public void printNativeIncludes(PrintWriter writer) {
        writer.println("#include \"extcl.h\"");
    }

    @Override
    public Class[] getValidAnnotationTypes(Class type) {
        Class[] valid_types = Buffer.class.isAssignableFrom(type) || PointerBuffer.class.isAssignableFrom(type) ? CLTypeMap.getValidBufferTypes(type) : (type.isPrimitive() ? CLTypeMap.getValidPrimitiveTypes(type) : (String.class.equals((Object)type) ? new Class[]{cl_byte.class} : (org.lwjgl.PointerWrapper.class.isAssignableFrom(type) ? new Class[]{PointerWrapper.class} : (ByteBuffer[].class == type ? new Class[]{cl_char.class, cl_uchar.class} : (Void.TYPE.equals(type) ? new Class[]{GLreturn.class} : new Class[]{})))));
        return valid_types;
    }

    public Class<? extends Annotation> getInverseType(Class type) {
        return null;
    }

    @Override
    public String getAutoTypeFromAnnotation(AnnotationMirror annotation) {
        return null;
    }

    static {
        native_types_to_primitive.put(cl_void.class, TypeKind.BYTE);
        native_types_to_primitive.put(cl_byte.class, TypeKind.BYTE);
        native_types_to_primitive.put(cl_char.class, TypeKind.BYTE);
        native_types_to_primitive.put(cl_uchar.class, TypeKind.BYTE);
        native_types_to_primitive.put(cl_short.class, TypeKind.SHORT);
        native_types_to_primitive.put(cl_bool.class, TypeKind.INT);
        native_types_to_primitive.put(cl_int.class, TypeKind.INT);
        native_types_to_primitive.put(cl_uint.class, TypeKind.INT);
        native_types_to_primitive.put(cl_long.class, TypeKind.LONG);
        native_types_to_primitive.put(size_t.class, TypeKind.LONG);
        native_types_to_primitive.put(cl_bitfield.class, TypeKind.LONG);
        native_types_to_primitive.put(cl_float.class, TypeKind.FLOAT);
        native_types_to_primitive.put(cl_double.class, TypeKind.DOUBLE);
    }
}

