/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.generator;

import java.io.PrintWriter;
import java.util.Collection;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.lwjgl.util.generator.Alternate;
import org.lwjgl.util.generator.Helper;
import org.lwjgl.util.generator.Indirect;
import org.lwjgl.util.generator.NativeTypeTranslator;
import org.lwjgl.util.generator.PointerArray;
import org.lwjgl.util.generator.Result;
import org.lwjgl.util.generator.Reuse;
import org.lwjgl.util.generator.TypeMap;
import org.lwjgl.util.generator.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypedefsGenerator {
    private static void generateNativeTypedefs(TypeMap type_map, PrintWriter writer, ExecutableElement method) {
        TypeMirror return_type = method.getReturnType();
        writer.print("typedef ");
        writer.print(type_map.getTypedefPostfix());
        NativeTypeTranslator translator = new NativeTypeTranslator(type_map, method);
        return_type.accept(translator, null);
        writer.print(translator.getSignature());
        writer.print(" (");
        writer.print(type_map.getFunctionPrefix());
        writer.print(" *" + Utils.getTypedefName(method) + ") (");
        TypedefsGenerator.generateNativeTypedefsParameters(type_map, writer, method.getParameters());
        writer.println(");");
    }

    private static void generateNativeTypedefsParameters(TypeMap type_map, PrintWriter writer, Collection<? extends VariableElement> params) {
        if (params.size() > 0) {
            boolean first = true;
            for (VariableElement variableElement : params) {
                if (variableElement.getAnnotation(Helper.class) != null) continue;
                if (first) {
                    first = false;
                } else {
                    writer.print(", ");
                }
                TypedefsGenerator.generateNativeTypedefsParameter(type_map, writer, variableElement);
            }
        }
    }

    private static void generateNativeTypedefsParameter(TypeMap type_map, PrintWriter writer, VariableElement param) {
        NativeTypeTranslator translator = new NativeTypeTranslator(type_map, param);
        param.asType().accept(translator, null);
        writer.print(translator.getSignature());
        if (param.getAnnotation(Result.class) != null || param.getAnnotation(Indirect.class) != null || param.getAnnotation(PointerArray.class) != null) {
            writer.print("*");
        }
        writer.print(" " + param.getSimpleName());
    }

    public static void generateNativeTypedefs(TypeMap type_map, PrintWriter writer, Collection<? extends ExecutableElement> methods) {
        for (ExecutableElement executableElement : methods) {
            if (executableElement.getAnnotation(Alternate.class) != null || executableElement.getAnnotation(Reuse.class) != null) continue;
            TypedefsGenerator.generateNativeTypedefs(type_map, writer, executableElement);
        }
    }
}

