/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.generator;

import java.lang.annotation.Annotation;
import java.lang.constant.Constable;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.lwjgl.PointerBuffer;
import org.lwjgl.util.generator.NativeType;
import org.lwjgl.util.generator.NativeTypeTranslator;
import org.lwjgl.util.generator.PointerType;
import org.lwjgl.util.generator.Signedness;
import org.lwjgl.util.generator.TypeMap;
import org.lwjgl.util.generator.Utils;
import org.lwjgl.util.generator.opengl.GLvoid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeInfo {
    public static final String UNSIGNED_PARAMETER_NAME = "unsigned";
    private final Signedness signedness;
    private final Class type;
    private final String auto_type;

    private TypeInfo(Class type, Signedness signedness, String auto_type) {
        this.type = type;
        this.signedness = signedness;
        this.auto_type = auto_type;
    }

    public Class getType() {
        return this.type;
    }

    public Signedness getSignedness() {
        return this.signedness;
    }

    public String getAutoType() {
        if (this.auto_type == null) {
            throw new RuntimeException("No auto type assigned");
        }
        return this.auto_type;
    }

    private static Class getTypeFromPrimitiveKind(TypeKind kind) {
        Class<Constable> type;
        switch (kind) {
            case LONG: {
                type = Long.TYPE;
                break;
            }
            case INT: {
                type = Integer.TYPE;
                break;
            }
            case FLOAT: {
                type = Float.TYPE;
                break;
            }
            case DOUBLE: {
                type = Double.TYPE;
                break;
            }
            case SHORT: {
                type = Short.TYPE;
                break;
            }
            case BYTE: {
                type = Byte.TYPE;
                break;
            }
            case BOOLEAN: {
                type = Boolean.TYPE;
                break;
            }
            default: {
                throw new RuntimeException((Object)((Object)kind) + " is not allowed");
            }
        }
        return type;
    }

    private static Class getBufferTypeFromPrimitiveKind(TypeKind kind, AnnotationMirror annotation) {
        Class type;
        switch (kind) {
            case INT: {
                type = IntBuffer.class;
                break;
            }
            case FLOAT: {
                type = FloatBuffer.class;
                break;
            }
            case DOUBLE: {
                type = DoubleBuffer.class;
                break;
            }
            case SHORT: {
                type = ShortBuffer.class;
                break;
            }
            case LONG: {
                if (annotation.getAnnotationType().asElement().getAnnotation(PointerType.class) != null) {
                    type = PointerBuffer.class;
                    break;
                }
                type = LongBuffer.class;
                break;
            }
            case BYTE: 
            case BOOLEAN: {
                type = ByteBuffer.class;
                break;
            }
            default: {
                throw new RuntimeException((Object)((Object)kind) + " is not allowed");
            }
        }
        return type;
    }

    private static TypeInfo getDefaultTypeInfo(TypeMirror t) {
        Class java_type = Utils.getJavaType(t);
        return new TypeInfo(java_type, Signedness.NONE, null);
    }

    public static Map<VariableElement, TypeInfo> getDefaultTypeInfoMap(ExecutableElement method) {
        HashMap<VariableElement, TypeInfo> map = new HashMap<VariableElement, TypeInfo>();
        for (VariableElement variableElement : method.getParameters()) {
            TypeInfo type_info = TypeInfo.getDefaultTypeInfo(variableElement.asType());
            map.put(variableElement, type_info);
        }
        return map;
    }

    private static Collection<TypeInfo> getTypeInfos(TypeMap type_map, VariableElement param) {
        List<AnnotationMirror> annotations = Utils.getSortedAnnotations(param.getAnnotationMirrors());
        GLvoid void_annotation = param.getAnnotation(GLvoid.class);
        HashMap<Class<? extends Annotation>, TypeInfo> types = new HashMap<Class<? extends Annotation>, TypeInfo>();
        ArrayList<TypeInfo> multityped_result = new ArrayList<TypeInfo>();
        boolean add_default_type = true;
        for (AnnotationMirror annotation : annotations) {
            NativeType native_type_annotation = NativeTypeTranslator.getAnnotation(annotation, NativeType.class);
            if (native_type_annotation == null) continue;
            Class<? extends Annotation> annotation_type = NativeTypeTranslator.getClassFromType(annotation.getAnnotationType());
            Signedness signedness = type_map.getSignednessFromType(annotation_type);
            Class<? extends Annotation> inverse_type = type_map.getInverseType(annotation_type);
            String auto_type = type_map.getAutoTypeFromAnnotation(annotation);
            if (inverse_type != null && types.containsKey(inverse_type)) {
                TypeInfo inverse_type_info = (TypeInfo)types.get(inverse_type);
                String inverse_auto_type = inverse_type_info.getAutoType();
                auto_type = signedness == Signedness.UNSIGNED ? auto_type + " : " + inverse_auto_type : inverse_auto_type + " : " + auto_type;
                auto_type = "unsigned ? " + auto_type;
                signedness = Signedness.BOTH;
                types.remove(inverse_type);
                multityped_result.remove(inverse_type_info);
            }
            TypeKind kind = void_annotation == null ? type_map.getPrimitiveTypeFromNativeType(annotation_type) : void_annotation.value();
            Class type = Utils.getNIOBufferType(param.asType()) != null ? TypeInfo.getBufferTypeFromPrimitiveKind(kind, annotation) : TypeInfo.getTypeFromPrimitiveKind(kind);
            TypeInfo type_info = new TypeInfo(type, signedness, auto_type);
            types.put(annotation_type, type_info);
            multityped_result.add(type_info);
            add_default_type = false;
        }
        if (add_default_type) {
            TypeInfo default_type_info = TypeInfo.getDefaultTypeInfo(param.asType());
            ArrayList<TypeInfo> result = new ArrayList<TypeInfo>();
            result.add(default_type_info);
            return result;
        }
        return multityped_result;
    }

    private static Map<VariableElement, Collection<TypeInfo>> getTypeInfoMap(TypeMap type_map, ExecutableElement method) {
        HashMap<VariableElement, Collection<TypeInfo>> map = new HashMap<VariableElement, Collection<TypeInfo>>();
        for (VariableElement variableElement : method.getParameters()) {
            Collection<TypeInfo> types = TypeInfo.getTypeInfos(type_map, variableElement);
            map.put(variableElement, types);
        }
        return map;
    }

    public static Collection<Map<VariableElement, TypeInfo>> getTypeInfoCrossProduct(TypeMap type_map, ExecutableElement method) {
        List<? extends VariableElement> parameter_collection = method.getParameters();
        ArrayList<Map<VariableElement, TypeInfo>> cross_product = new ArrayList<Map<VariableElement, TypeInfo>>();
        TypeInfo.getCrossProductRecursive(0, parameter_collection, TypeInfo.getTypeInfoMap(type_map, method), new HashMap<VariableElement, TypeInfo>(), cross_product);
        return cross_product;
    }

    private static void getCrossProductRecursive(int index, List<? extends VariableElement> parameters, Map<VariableElement, Collection<TypeInfo>> typeinfos_map, Map<VariableElement, TypeInfo> current_instance, Collection<Map<VariableElement, TypeInfo>> cross_product) {
        if (index == parameters.size()) {
            cross_product.add(current_instance);
            return;
        }
        VariableElement param = parameters.get(index);
        Collection<TypeInfo> typeinfos = typeinfos_map.get(param);
        if (typeinfos != null) {
            for (TypeInfo typeinfo : typeinfos) {
                HashMap<VariableElement, TypeInfo> instance = new HashMap<VariableElement, TypeInfo>(current_instance);
                instance.put(param, typeinfo);
                TypeInfo.getCrossProductRecursive(index + 1, parameters, typeinfos_map, instance, cross_product);
            }
        }
    }
}

