/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.generator;

import java.lang.annotation.Annotation;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.SimpleTypeVisitor6;
import org.lwjgl.util.generator.NativeType;
import org.lwjgl.util.generator.NativeTypeTranslator;
import org.lwjgl.util.generator.TypeMap;
import org.lwjgl.util.generator.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostfixTranslator
extends SimpleTypeVisitor6<Void, Void> {
    private final StringBuilder signature = new StringBuilder();
    private final Element declaration;
    private final TypeMap type_map;

    public PostfixTranslator(TypeMap type_map, Element declaration) {
        this.declaration = declaration;
        this.type_map = type_map;
    }

    public String getSignature() {
        return this.signature.toString();
    }

    private static TypeKind getPrimitiveKindFromBufferClass(Class c) {
        if (IntBuffer.class.equals((Object)c) || Integer.TYPE.equals(c)) {
            return TypeKind.INT;
        }
        if (DoubleBuffer.class.equals((Object)c) || Double.TYPE.equals(c)) {
            return TypeKind.DOUBLE;
        }
        if (ShortBuffer.class.equals((Object)c) || Short.TYPE.equals(c)) {
            return TypeKind.SHORT;
        }
        if (ByteBuffer.class.equals((Object)c) || Byte.TYPE.equals(c)) {
            return TypeKind.BYTE;
        }
        if (FloatBuffer.class.equals((Object)c) || Float.TYPE.equals(c)) {
            return TypeKind.FLOAT;
        }
        if (LongBuffer.class.equals((Object)c) || Long.TYPE.equals(c)) {
            return TypeKind.LONG;
        }
        throw new RuntimeException(c + " is not allowed");
    }

    private void visitClassType(DeclaredType t) {
        Class<? extends Annotation> c = NativeTypeTranslator.getClassFromType(t);
        TypeKind kind = PostfixTranslator.getPrimitiveKindFromBufferClass(c);
        this.visitPrimitiveTypeKind(kind);
    }

    @Override
    public Void visitDeclared(DeclaredType t, Void o) {
        if (t.asElement().getKind().isClass()) {
            this.visitClassType(t);
        }
        return (Void)this.DEFAULT_VALUE;
    }

    private boolean translateAnnotation(AnnotationMirror annotation) {
        NativeType native_type = NativeTypeTranslator.getAnnotation(annotation, NativeType.class);
        if (native_type != null) {
            Class<? extends Annotation> annotation_class = NativeTypeTranslator.getClassFromType(annotation.getAnnotationType());
            this.signature.append(this.type_map.translateAnnotation(annotation_class));
            return true;
        }
        return false;
    }

    private boolean translateAnnotations() {
        boolean result = false;
        for (AnnotationMirror annotation : Utils.getSortedAnnotations(this.declaration.getAnnotationMirrors())) {
            if (!this.translateAnnotation(annotation)) continue;
            if (result) {
                throw new RuntimeException("Multiple native types");
            }
            result = true;
        }
        return result;
    }

    @Override
    public Void visitPrimitive(PrimitiveType t, Void o) {
        this.visitPrimitiveTypeKind(t.getKind());
        return (Void)this.DEFAULT_VALUE;
    }

    private void visitPrimitiveTypeKind(TypeKind kind) {
        String type;
        boolean annotated_translation = this.translateAnnotations();
        if (annotated_translation) {
            return;
        }
        switch (kind) {
            case INT: {
                type = "i";
                break;
            }
            case DOUBLE: {
                type = "d";
                break;
            }
            case FLOAT: {
                type = "f";
                break;
            }
            case SHORT: {
                type = "s";
                break;
            }
            case BYTE: {
                type = "b";
                break;
            }
            case LONG: {
                type = "i64";
                break;
            }
            default: {
                throw new RuntimeException((Object)((Object)kind) + " is not allowed");
            }
        }
        this.signature.append(type);
    }
}

