/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.generator;

import java.nio.ByteBuffer;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleTypeVisitor6;
import org.lwjgl.PointerWrapper;
import org.lwjgl.util.generator.NativeTypeTranslator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaTypeTranslator
extends SimpleTypeVisitor6<Void, Void> {
    private Class type;

    public Class getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitArray(ArrayType t, Void o) {
        TypeMirror componentType = t.getComponentType();
        try {
            Class<?> c = Class.forName(t.getComponentType().toString());
            if (CharSequence.class.isAssignableFrom(c) || ByteBuffer.class.isAssignableFrom(c) || PointerWrapper.class.isAssignableFrom(c)) {
                this.type = Class.forName("[L" + t.getComponentType() + ";");
                return this.type;
            }
        }
        catch (ClassNotFoundException ex) {
            this.type = null;
            return this.type;
        }
        finally {
            if (this.type == null) {
                if (componentType instanceof PrimitiveType) {
                    this.type = JavaTypeTranslator.getPrimitiveArrayClassFromKind(componentType.getKind());
                } else {
                    throw new RuntimeException(t + " is not allowed");
                }
            }
            return (Void)this.DEFAULT_VALUE;
        }
    }

    public static Class getPrimitiveClassFromKind(TypeKind kind) {
        switch (kind) {
            case LONG: {
                return Long.TYPE;
            }
            case INT: {
                return Integer.TYPE;
            }
            case DOUBLE: {
                return Double.TYPE;
            }
            case FLOAT: {
                return Float.TYPE;
            }
            case SHORT: {
                return Short.TYPE;
            }
            case BYTE: {
                return Byte.TYPE;
            }
            case BOOLEAN: {
                return Boolean.TYPE;
            }
        }
        throw new RuntimeException((Object)((Object)kind) + " is not allowed");
    }

    private static Class getPrimitiveArrayClassFromKind(TypeKind kind) {
        switch (kind) {
            case LONG: {
                return long[].class;
            }
            case INT: {
                return int[].class;
            }
            case DOUBLE: {
                return double[].class;
            }
            case FLOAT: {
                return float[].class;
            }
            case SHORT: {
                return short[].class;
            }
            case BYTE: {
                return byte[].class;
            }
            case BOOLEAN: {
                return boolean[].class;
            }
        }
        throw new RuntimeException((Object)((Object)kind) + " is not allowed");
    }

    @Override
    public Void visitPrimitive(PrimitiveType t, Void p) {
        this.type = JavaTypeTranslator.getPrimitiveClassFromKind(t.getKind());
        return (Void)this.DEFAULT_VALUE;
    }

    @Override
    public Void visitDeclared(DeclaredType t, Void o) {
        if (t.asElement().getKind().isClass()) {
            this.visitClassType(t);
        } else if (t.asElement().getKind().isInterface()) {
            this.visitInterfaceType(t);
        } else {
            throw new RuntimeException((Object)((Object)t.asElement().getKind()) + " is not allowed");
        }
        return (Void)this.DEFAULT_VALUE;
    }

    private void visitClassType(DeclaredType t) {
        this.type = NativeTypeTranslator.getClassFromType(t);
    }

    private void visitInterfaceType(DeclaredType t) {
        this.type = NativeTypeTranslator.getClassFromType(t);
    }

    @Override
    public Void visitNoType(NoType t, Void p) {
        this.type = Void.TYPE;
        return (Void)this.DEFAULT_VALUE;
    }
}

