/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.generator;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementKindVisitor6;
import javax.tools.Diagnostic;
import javax.tools.StandardLocation;
import org.lwjgl.util.generator.Alternate;
import org.lwjgl.util.generator.AutoSize;
import org.lwjgl.util.generator.BufferObject;
import org.lwjgl.util.generator.CachedReference;
import org.lwjgl.util.generator.CachedResult;
import org.lwjgl.util.generator.Check;
import org.lwjgl.util.generator.Constant;
import org.lwjgl.util.generator.Extern;
import org.lwjgl.util.generator.FieldsGenerator;
import org.lwjgl.util.generator.Imports;
import org.lwjgl.util.generator.JavaMethodsGenerator;
import org.lwjgl.util.generator.NativeMethodStubsGenerator;
import org.lwjgl.util.generator.NativeType;
import org.lwjgl.util.generator.NativeTypeTranslator;
import org.lwjgl.util.generator.NullTerminated;
import org.lwjgl.util.generator.Private;
import org.lwjgl.util.generator.RegisterStubsGenerator;
import org.lwjgl.util.generator.Result;
import org.lwjgl.util.generator.Reuse;
import org.lwjgl.util.generator.StripPostfix;
import org.lwjgl.util.generator.TypeMap;
import org.lwjgl.util.generator.TypedefsGenerator;
import org.lwjgl.util.generator.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratorVisitor
extends ElementKindVisitor6<Void, Void> {
    private final ProcessingEnvironment env;
    private final TypeMap type_map;
    private final boolean generate_error_checks;
    private final boolean context_specific;
    private final long generatorLM;

    public GeneratorVisitor(ProcessingEnvironment env, TypeMap type_map, boolean generate_error_checks, boolean context_specific, long generatorLM) {
        this.env = env;
        this.type_map = type_map;
        this.generate_error_checks = generate_error_checks;
        this.context_specific = context_specific;
        this.generatorLM = generatorLM;
    }

    private void validateMethod(ExecutableElement method) {
        if (method.isVarArgs()) {
            throw new RuntimeException("Method " + method.getSimpleName() + " is variadic");
        }
        Set<Modifier> modifiers = method.getModifiers();
        if (!modifiers.contains((Object)Modifier.PUBLIC)) {
            throw new RuntimeException("Method " + method.getSimpleName() + " is not public");
        }
        if (method.getThrownTypes().size() > 0) {
            throw new RuntimeException("Method " + method.getSimpleName() + " throws checked exceptions");
        }
        this.validateParameters(method);
        StripPostfix strip_annotation = method.getAnnotation(StripPostfix.class);
        if (strip_annotation != null && method.getAnnotation(Alternate.class) == null) {
            String postfix_param_name = strip_annotation.value();
            VariableElement postfix_param = Utils.findParameter(method, postfix_param_name);
            if (Utils.isParameterMultiTyped(postfix_param)) {
                throw new RuntimeException("Postfix parameter can't be the same as a multityped parameter in method " + method);
            }
            if (Utils.getNIOBufferType(postfix_param.asType()) == null) {
                throw new RuntimeException("Postfix parameter type must be a nio Buffer");
            }
        }
        if (Utils.getResultParameter(method) != null && !method.getReturnType().equals(this.env.getTypeUtils().getNoType(TypeKind.VOID))) {
            throw new RuntimeException(method + " return type is not void but a parameter is annotated with Result");
        }
        if (method.getAnnotation(CachedResult.class) != null) {
            if (Utils.getNIOBufferType(Utils.getMethodReturnType(method)) == null) {
                throw new RuntimeException(method + " return type is not a Buffer, but is annotated with CachedResult");
            }
            if (method.getAnnotation(AutoSize.class) == null) {
                throw new RuntimeException(method + " is annotated with CachedResult but misses an AutoSize annotation");
            }
        }
        this.validateTypes(method, method.getAnnotationMirrors(), method.getReturnType());
    }

    private void validateType(ExecutableElement method, Class<? extends Annotation> annotation_type, Class type) {
        Class[] valid_types;
        for (Class valid_type : valid_types = this.type_map.getValidAnnotationTypes(type)) {
            if (!valid_type.equals(annotation_type)) continue;
            return;
        }
        throw new RuntimeException(type + " is annotated with invalid native type " + annotation_type + " in method " + method);
    }

    private void validateTypes(ExecutableElement method, List<? extends AnnotationMirror> annotations, TypeMirror type_mirror) {
        for (AnnotationMirror annotationMirror : annotations) {
            NativeType native_type_annotation = NativeTypeTranslator.getAnnotation(annotationMirror, NativeType.class);
            if (native_type_annotation == null) continue;
            Class<? extends Annotation> annotation_type = NativeTypeTranslator.getClassFromType(annotationMirror.getAnnotationType());
            Class type = Utils.getJavaType(type_mirror);
            if (Buffer.class.equals((Object)type)) continue;
            this.validateType(method, annotation_type, type);
        }
    }

    private void validateParameters(ExecutableElement method) {
        for (VariableElement variableElement : method.getParameters()) {
            this.validateTypes(method, variableElement.getAnnotationMirrors(), variableElement.asType());
            Class param_type = Utils.getJavaType(variableElement.asType());
            if (Utils.getNIOBufferType(variableElement.asType()) != null && param_type != CharSequence.class && param_type != CharSequence[].class) {
                Check parameter_check_annotation = variableElement.getAnnotation(Check.class);
                NullTerminated null_terminated_annotation = variableElement.getAnnotation(NullTerminated.class);
                if (parameter_check_annotation == null && null_terminated_annotation == null) {
                    boolean found_auto_size_param = false;
                    for (VariableElement variableElement2 : method.getParameters()) {
                        AutoSize auto_size_annotation = variableElement2.getAnnotation(AutoSize.class);
                        if (auto_size_annotation == null || !auto_size_annotation.value().equals(variableElement.getSimpleName().toString())) continue;
                        found_auto_size_param = true;
                        break;
                    }
                    if (!found_auto_size_param && variableElement.getAnnotation(Result.class) == null && variableElement.getAnnotation(Constant.class) == null && !Utils.isReturnParameter(method, variableElement)) {
                        throw new RuntimeException(variableElement + " has no Check, Result nor Constant annotation, is not the return parameter and no other parameter has an @AutoSize annotation on it in method " + method);
                    }
                }
                if (variableElement.getAnnotation(CachedReference.class) != null && variableElement.getAnnotation(Result.class) != null) {
                    throw new RuntimeException(variableElement + " can't be annotated with both CachedReference and Result");
                }
                if (variableElement.getAnnotation(BufferObject.class) == null || variableElement.getAnnotation(Result.class) == null) continue;
                throw new RuntimeException(variableElement + " can't be annotated with both BufferObject and Result");
            }
            if (variableElement.getAnnotation(BufferObject.class) != null) {
                throw new RuntimeException(variableElement + " type is not a buffer, but annotated as a BufferObject");
            }
            if (variableElement.getAnnotation(CachedReference.class) == null) continue;
            throw new RuntimeException(variableElement + " type is not a buffer, but annotated as a CachedReference");
        }
    }

    private static void generateMethodsNativePointers(PrintWriter writer, Collection<? extends ExecutableElement> methods) {
        for (ExecutableElement executableElement : methods) {
            if (executableElement.getAnnotation(Alternate.class) != null) continue;
            GeneratorVisitor.generateMethodNativePointers(writer, executableElement);
        }
    }

    private static void generateMethodNativePointers(PrintWriter writer, ExecutableElement method) {
        if (method.getAnnotation(Extern.class) == null) {
            writer.print("static ");
        }
        writer.println(Utils.getTypedefName(method) + " " + method.getSimpleName() + ";");
    }

    private void generateJavaSource(TypeElement d, PrintWriter java_writer) throws IOException {
        boolean is_final;
        java_writer.println("/* MACHINE GENERATED FILE, DO NOT EDIT */");
        java_writer.println();
        java_writer.println("package " + this.env.getElementUtils().getPackageOf(d).getQualifiedName().toString() + ";");
        java_writer.println();
        java_writer.println("import org.lwjgl.*;");
        java_writer.println("import java.nio.*;");
        Imports imports = d.getAnnotation(Imports.class);
        if (imports != null) {
            for (String i : imports.value()) {
                java_writer.println("import " + i + ";");
            }
        }
        java_writer.println();
        Utils.printDocComment(java_writer, d, this.env);
        if (d.getAnnotation(Private.class) == null) {
            java_writer.print("public ");
        }
        if (is_final = Utils.isFinal(d)) {
            java_writer.write("final ");
        }
        java_writer.print("class " + Utils.getSimpleClassName(d));
        List<? extends TypeMirror> super_interfaces = d.getInterfaces();
        if (super_interfaces.size() > 1) {
            throw new RuntimeException(d + " extends more than one interface");
        }
        if (super_interfaces.size() == 1) {
            TypeMirror super_interface = super_interfaces.iterator().next();
            java_writer.print(" extends " + Utils.getSimpleClassName(this.env.getElementUtils().getTypeElement(super_interface.toString())));
        }
        java_writer.println(" {");
        FieldsGenerator.generateFields(this.env, java_writer, Utils.getFields(d));
        java_writer.println();
        if (is_final) {
            java_writer.println("\tprivate " + Utils.getSimpleClassName(d) + "() {}");
        }
        if (Utils.getMethods(d).size() > 0 && !this.context_specific) {
            java_writer.println();
            java_writer.println("\tstatic native void initNativeStubs() throws LWJGLException;");
        }
        JavaMethodsGenerator.generateMethodsJava(this.env, this.type_map, java_writer, d, this.generate_error_checks, this.context_specific);
        java_writer.println("}");
        java_writer.close();
        String qualified_interface_name = Utils.getQualifiedClassName(d);
        this.env.getMessager().printMessage(Diagnostic.Kind.NOTE, "Generated class " + qualified_interface_name);
    }

    private void generateNativeSource(TypeElement d) throws IOException {
        if (d.getKind().equals((Object)ElementKind.ANNOTATION_TYPE)) {
            return;
        }
        String qualified_interface_name = Utils.getQualifiedClassName(d);
        String qualified_native_name = Utils.getNativeQualifiedName(qualified_interface_name) + ".c";
        PrintWriter native_writer = new PrintWriter(this.env.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", qualified_native_name, new Element[0]).openWriter());
        native_writer.println("/* MACHINE GENERATED FILE, DO NOT EDIT */");
        native_writer.println();
        native_writer.println("#include <jni.h>");
        this.type_map.printNativeIncludes(native_writer);
        native_writer.println();
        TypedefsGenerator.generateNativeTypedefs(this.type_map, native_writer, Utils.getMethods(d));
        native_writer.println();
        if (!this.context_specific) {
            GeneratorVisitor.generateMethodsNativePointers(native_writer, Utils.getMethods(d));
            native_writer.println();
        }
        NativeMethodStubsGenerator.generateNativeMethodStubs(this.env, this.type_map, native_writer, d, this.generate_error_checks, this.context_specific);
        if (!this.context_specific) {
            native_writer.print("JNIEXPORT void JNICALL " + Utils.getQualifiedNativeMethodName(qualified_interface_name, "initNativeStubs"));
            native_writer.println("(JNIEnv *env, jclass clazz) {");
            native_writer.println("\tJavaMethodAndExtFunction functions[] = {");
            RegisterStubsGenerator.generateMethodsNativeStubBind(native_writer, d, this.generate_error_checks, this.context_specific);
            native_writer.println("\t};");
            native_writer.println("\tint num_functions = NUMFUNCTIONS(functions);");
            native_writer.print("\t");
            native_writer.print(this.type_map.getRegisterNativesFunctionName());
            native_writer.println("(env, clazz, num_functions, functions);");
            native_writer.println("}");
        }
        native_writer.close();
        this.env.getMessager().printMessage(Diagnostic.Kind.NOTE, "Generated C source " + qualified_interface_name);
    }

    @Override
    public Void visitTypeAsInterface(TypeElement e, Void p) {
        File input = new File("src/templates/" + e.getQualifiedName().toString().replace('.', '/') + ".java");
        File outputJava = new File("src/generated/" + this.env.getElementUtils().getPackageOf(e).getQualifiedName().toString().replace('.', '/'), Utils.getSimpleClassName(e) + ".java");
        PrintWriter java_writer = null;
        try {
            Collection<ExecutableElement> methods = Utils.getMethods(e);
            if (methods.isEmpty() && Utils.getFields(e).isEmpty()) {
                return (Void)this.DEFAULT_VALUE;
            }
            if (outputJava.exists() && Math.max(input.lastModified(), this.generatorLM) < outputJava.lastModified()) {
                return (Void)this.DEFAULT_VALUE;
            }
            for (ExecutableElement executableElement : methods) {
                this.validateMethod(executableElement);
            }
            outputJava.getParentFile().mkdirs();
            outputJava.createNewFile();
            java_writer = new PrintWriter(outputJava);
            this.generateJavaSource(e, java_writer);
            if (methods.size() > 0) {
                boolean noNative = true;
                for (ExecutableElement method : methods) {
                    Alternate alt_annotation = method.getAnnotation(Alternate.class);
                    if (alt_annotation != null && !alt_annotation.nativeAlt() || method.getAnnotation(Reuse.class) != null) continue;
                    noNative = false;
                    break;
                }
                if (noNative) {
                    return (Void)this.DEFAULT_VALUE;
                }
                try {
                    this.generateNativeSource(e);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
            return (Void)this.DEFAULT_VALUE;
        }
        catch (Exception ex) {
            if (java_writer != null) {
                java_writer.close();
            }
            if (outputJava.exists()) {
                outputJava.delete();
            }
            throw new RuntimeException(ex);
        }
    }

    private static ByteBuffer readFile(File file) throws IOException {
        FileChannel channel = new FileInputStream(file).getChannel();
        long bytesTotal = channel.size();
        ByteBuffer buffer = ByteBuffer.allocateDirect((int)bytesTotal);
        long bytesRead = 0L;
        while ((bytesRead += (long)channel.read(buffer)) < bytesTotal) {
        }
        buffer.flip();
        channel.close();
        return buffer;
    }
}

