/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.generator;

import java.io.File;
import java.io.FileFilter;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.lwjgl.util.generator.GeneratorVisitor;
import org.lwjgl.util.generator.TypeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedAnnotationTypes(value={"*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_5)
@SupportedOptions(value={"binpath", "typemap", "generatechecks", "contextspecific"})
public class GeneratorProcessor
extends AbstractProcessor {
    private static boolean first_round = true;

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver() || !first_round) {
            System.exit(0);
            return true;
        }
        Map<String, String> options = this.processingEnv.getOptions();
        String typemap_classname = options.get("typemap");
        String bin_path = options.get("binpath");
        boolean generate_error_checks = options.containsKey("generatechecks");
        boolean context_specific = options.containsKey("contextspecific");
        if (bin_path == null) {
            throw new RuntimeException("No path specified for the bin directory with -Abinpath=<path>");
        }
        if (typemap_classname == null) {
            throw new RuntimeException("No TypeMap class name specified with -Atypemap=<class-name>");
        }
        Element element = null;
        try {
            long generatorLM = GeneratorProcessor.getGeneratorLastModified(bin_path);
            TypeMap type_map = (TypeMap)Class.forName(typemap_classname).newInstance();
            for (Element element2 : ElementFilter.typesIn(roundEnv.getRootElements())) {
                element2.accept(new GeneratorVisitor(this.processingEnv, type_map, generate_error_checks, context_specific, generatorLM), null);
            }
            first_round = false;
            return true;
        }
        catch (Exception e) {
            if (element == null) {
                throw new RuntimeException(e);
            }
            throw new RuntimeException("\n-- Failed to process template: " + element.asType().toString() + " --", e);
        }
    }

    private static long getGeneratorLastModified(String bin_path) {
        long lastModified = GeneratorProcessor.getDirectoryLastModified(bin_path, "/org/lwjgl/util/generator");
        lastModified = Math.max(lastModified, GeneratorProcessor.getDirectoryLastModified(bin_path, "/org/lwjgl/util/generator/openal"));
        lastModified = Math.max(lastModified, GeneratorProcessor.getDirectoryLastModified(bin_path, "/org/lwjgl/util/generator/opengl"));
        lastModified = Math.max(lastModified, GeneratorProcessor.getDirectoryLastModified(bin_path, "/org/lwjgl/util/generator/opencl"));
        return lastModified;
    }

    private static long getDirectoryLastModified(String bin_path, String path) {
        File pck = new File(bin_path + path);
        if (!pck.exists() || !pck.isDirectory()) {
            return Long.MAX_VALUE;
        }
        File[] classes = pck.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().endsWith(".class");
            }
        });
        if (classes == null || classes.length == 0) {
            return Long.MAX_VALUE;
        }
        long lastModified = 0L;
        for (File clazz : classes) {
            long lm = clazz.lastModified();
            if (lastModified >= lm) continue;
            lastModified = lm;
        }
        return lastModified;
    }
}

