/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.opengles.util;

import org.lwjgl.opengles.GLES20;

public class GLLight {
    public static final int GL_LIGHT0 = 16384;
    public static final int GL_LIGHT1 = 16385;
    public static final int GL_LIGHT2 = 16386;
    public static final int GL_LIGHT3 = 16387;
    public static final int GL_LIGHT4 = 16388;
    public static final int GL_LIGHT5 = 16389;
    public static final int GL_LIGHT6 = 16390;
    public static final int GL_LIGHT7 = 16391;
    public static final int GL_AMBIENT = 4608;
    public static final int GL_DIFFUSE = 4609;
    public static final int GL_SPECULAR = 4610;
    public static final int GL_POSITION = 4611;
    public static final int GL_SPOT_DIRECTION = 4612;
    public static final int GL_SPOT_EXPONENT = 4613;
    public static final int GL_SPOT_CUTOFF = 4614;
    public static final int GL_CONSTANT_ATTENUATION = 4615;
    public static final int GL_LINEAR_ATTENUATION = 4616;
    public static final int GL_QUADRATIC_ATTENUATION = 4617;
    private static final Light[] lights = new Light[8];

    private GLLight() {
    }

    public static void glLight(int light, int pname, float v) {
        if (light < 16384 || 16391 < light) {
            throw new IllegalArgumentException("Invalid light specified: " + light);
        }
        Light l = lights[light - 16384];
        switch (pname) {
            case 4613: {
                l.s = v;
                break;
            }
            case 4614: {
                l.c = v;
                break;
            }
            case 4615: {
                l.k0 = v;
                break;
            }
            case 4616: {
                l.k1 = v;
                break;
            }
            case 4617: {
                l.k2 = v;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid light parameter specified: " + pname);
            }
        }
    }

    public static void glLight(int light, int pname, float x, float y, float z) {
        if (light < 16384 || 16391 < light) {
            throw new IllegalArgumentException("Invalid light specified: " + light);
        }
        if (pname != 4612) {
            throw new IllegalArgumentException("Invalid light parameter specified: " + pname);
        }
        float[] param = GLLight.lights[light - 16384].direction;
        param[0] = x;
        param[1] = y;
        param[2] = z;
    }

    private static float[] getParam4f(int light, int pname) {
        if (light < 16384 || 16391 < light) {
            throw new IllegalArgumentException("Invalid light specified: " + light);
        }
        Light l = lights[light - 16384];
        switch (pname) {
            case 4608: {
                return l.ambient;
            }
            case 4609: {
                return l.diffuse;
            }
            case 4610: {
                return l.specular;
            }
            case 4611: {
                return l.position;
            }
        }
        throw new IllegalArgumentException("Invalid light parameter specified: " + pname);
    }

    public static void glLight(int light, int pname, float x, float y, float z, float w) {
        float[] param = GLLight.getParam4f(light, pname);
        param[0] = x;
        param[1] = y;
        param[2] = z;
        param[3] = w;
    }

    public static void setUniform1f(int location, int light, int pname) {
        if (light < 16384 || 16391 < light) {
            throw new IllegalArgumentException("Invalid light specified: " + light);
        }
        Light l = lights[light - 16384];
        switch (pname) {
            case 4613: {
                GLES20.glUniform1f(location, l.s);
                break;
            }
            case 4614: {
                GLES20.glUniform1f(location, l.c);
                break;
            }
            case 4615: {
                GLES20.glUniform1f(location, l.k0);
                break;
            }
            case 4616: {
                GLES20.glUniform1f(location, l.k1);
                break;
            }
            case 4617: {
                GLES20.glUniform1f(location, l.k2);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid light parameter specified: " + pname);
            }
        }
    }

    public static void setUniform3f(int location, int light, int pname) {
        if (pname != 4612) {
            throw new IllegalArgumentException("Invalid light parameter specified: " + pname);
        }
        float[] param = GLLight.lights[light - 16384].direction;
        GLES20.glUniform3f(location, param[0], param[1], param[2]);
    }

    public static void setUniform4f(int location, int light, int pname) {
        float[] param = GLLight.getParam4f(light, pname);
        GLES20.glUniform4f(location, param[0], param[1], param[2], param[3]);
    }

    static {
        for (int i = 0; i < lights.length; ++i) {
            GLLight.lights[i] = new Light();
        }
        System.arraycopy(new float[]{1.0f, 1.0f, 1.0f, 1.0f}, 0, GLLight.lights[0].diffuse, 0, 4);
        System.arraycopy(new float[]{1.0f, 1.0f, 1.0f, 1.0f}, 0, GLLight.lights[0].specular, 0, 4);
    }

    private static class Light {
        float[] ambient = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
        float[] diffuse = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
        float[] specular = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
        float[] position = new float[]{0.0f, 0.0f, 1.0f, 0.0f};
        float[] direction = new float[]{0.0f, 0.0f, -1.0f};
        float s;
        float c = 180.0f;
        float k0 = 1.0f;
        float k1;
        float k2;

        private Light() {
        }
    }
}

