/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.opengles;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.Sys;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengles.GLContext;
import org.lwjgl.opengles.GLES20;
import org.lwjgl.opengles.OESMapbuffer;
import org.lwjgl.opengles.PixelFormat;
import org.lwjgl.test.opengles.QuadRenderer;
import org.lwjgl.test.opengles.util.GLMatrix;

public final class MappedIndexedVBOTest {
    private static boolean finished;
    private static float angle;
    private static int buffer_id;
    private static int indices_buffer_id;
    private static FloatBuffer vertices;
    private static ByteBuffer mapped_buffer;
    private static FloatBuffer mapped_float_buffer;
    private static IntBuffer indices;
    private static ByteBuffer mapped_indices_buffer;
    private static IntBuffer mapped_indices_int_buffer;
    private static QuadRenderer renderer;

    public static void main(String[] arguments) {
        try {
            MappedIndexedVBOTest.init();
            while (!finished) {
                Display.update();
                Display.sync(30);
                if (!Display.isVisible()) {
                    Thread.sleep(200L);
                } else if (Display.isCloseRequested()) {
                    System.exit(0);
                }
                MappedIndexedVBOTest.mainLoop();
                MappedIndexedVBOTest.render();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            MappedIndexedVBOTest.cleanup();
        }
        System.exit(0);
    }

    private static void mainLoop() {
        int i;
        if ((angle += 1.0f) > 360.0f) {
            angle = 0.0f;
        }
        if (Mouse.getDX() != 0 || Mouse.getDY() != 0 || Mouse.getDWheel() != 0) {
            System.out.println("Mouse moved " + Mouse.getDX() + " " + Mouse.getDY() + " " + Mouse.getDWheel());
        }
        for (i = 0; i < Mouse.getButtonCount(); ++i) {
            if (!Mouse.isButtonDown(i)) continue;
            System.out.println("Button " + i + " down");
        }
        if (Keyboard.isKeyDown(1)) {
            finished = true;
        }
        for (i = 0; i < Keyboard.getNumKeyboardEvents(); ++i) {
            Keyboard.next();
            if (Keyboard.getEventKey() == 1 && Keyboard.getEventKeyState()) {
                finished = true;
            }
            if (Keyboard.getEventKey() != 20 || !Keyboard.getEventKeyState()) continue;
            System.out.println("Current time: " + Sys.getTime());
        }
    }

    private static void render() {
        GLES20.glClear(16384);
        GLMatrix.glPushMatrix();
        GLMatrix.glTranslatef(Display.getDisplayMode().getWidth() / 2, Display.getDisplayMode().getHeight() / 2, 0.0f);
        GLMatrix.glRotatef(angle, 0.0f, 0.0f, 1.0f);
        renderer.setMVPUniform();
        ByteBuffer new_mapped_buffer = OESMapbuffer.glMapBufferOES(34962, 35001, mapped_buffer);
        if (new_mapped_buffer != mapped_buffer) {
            mapped_buffer = new_mapped_buffer;
            mapped_float_buffer = new_mapped_buffer.asFloatBuffer();
        }
        if ((new_mapped_buffer = OESMapbuffer.glMapBufferOES(34963, 35001, mapped_indices_buffer)) != mapped_indices_buffer) {
            mapped_indices_buffer = new_mapped_buffer;
            mapped_indices_int_buffer = new_mapped_buffer.asIntBuffer();
        }
        mapped_float_buffer.rewind();
        vertices.rewind();
        mapped_float_buffer.put(vertices);
        mapped_indices_int_buffer.rewind();
        indices.rewind();
        mapped_indices_int_buffer.put(indices);
        if (OESMapbuffer.glUnmapBufferOES(34962) && OESMapbuffer.glUnmapBufferOES(34963)) {
            GLES20.glDrawElements(5, 4, 5125, 0L);
        }
        GLMatrix.glPopMatrix();
    }

    private static void init() throws Exception {
        System.out.println("Timer resolution: " + Sys.getTimerResolution());
        GLMatrix.glMatrixMode(5889);
        GLMatrix.glLoadIdentity();
        GLMatrix.glOrtho(0.0f, Display.getDisplayMode().getWidth(), 0.0f, Display.getDisplayMode().getHeight(), -1.0f, 1.0f);
        GLMatrix.glMatrixMode(5888);
        GLMatrix.glLoadIdentity();
        GLES20.glViewport(0, 0, Display.getDisplayMode().getWidth(), Display.getDisplayMode().getHeight());
        IntBuffer int_buffer = BufferUtils.createIntBuffer(2);
        GLES20.glGenBuffers(int_buffer);
        buffer_id = int_buffer.get(0);
        indices_buffer_id = int_buffer.get(1);
        GLES20.glBindBuffer(34962, buffer_id);
        GLES20.glBindBuffer(34963, indices_buffer_id);
        vertices = BufferUtils.createFloatBuffer(8);
        vertices.put(-50.0f).put(-50.0f).put(50.0f).put(-50.0f).put(-50.0f).put(50.0f).put(50.0f).put(50.0f);
        vertices.rewind();
        indices = BufferUtils.createIntBuffer(4);
        indices.put(0).put(1).put(2).put(3);
        indices.rewind();
        GLES20.glBufferData(34962, 32L, 35040);
        GLES20.glBufferData(34963, 16L, 35040);
        renderer = new QuadRenderer();
    }

    private static void cleanup() {
        renderer.cleanup();
        IntBuffer int_buffer = BufferUtils.createIntBuffer(2);
        int_buffer.put(0, buffer_id);
        int_buffer.put(1, indices_buffer_id);
        GLES20.glDeleteBuffers(int_buffer);
        Display.destroy();
    }

    static {
        try {
            int mode = -1;
            DisplayMode[] modes = Display.getAvailableDisplayModes();
            for (int i = 0; i < modes.length; ++i) {
                if (modes[i].getWidth() != 640 || modes[i].getHeight() != 480 || modes[i].getBitsPerPixel() < 16) continue;
                mode = i;
                break;
            }
            if (mode != -1) {
                System.out.println("Setting display mode to " + modes[mode]);
                Display.setDisplayMode(modes[mode]);
                System.out.println("Created display.");
            }
        }
        catch (Exception e) {
            System.err.println("Failed to create display due to " + e);
        }
        try {
            Display.create(new PixelFormat());
            System.out.println("Created OpenGL.");
            if (!GLContext.getCapabilities().GL_OES_mapbuffer) {
                System.out.println("GL_OES_mapbuffer is not supported, quitting!");
                System.exit(0);
            }
        }
        catch (Exception e) {
            System.err.println("Failed to create OpenGL due to " + e);
            System.exit(1);
        }
    }
}

