/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.opengles;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengles.GLES20;
import org.lwjgl.opengles.PixelFormat;
import org.lwjgl.opengles.PowerManagementEventException;
import org.lwjgl.test.opengles.QuadRenderer;
import org.lwjgl.test.opengles.util.GLMatrix;
import org.lwjgl.util.vector.Vector2f;

public class FullScreenWindowedTest {
    private DisplayMode mode;
    private Vector2f quadPosition;
    private Vector2f quadVelocity;
    private float angle;
    private float angleRotation = 1.0f;
    private static final float MAX_SPEED = 20.0f;
    private static int buffer_id;
    private static int indices_buffer_id;
    private QuadRenderer renderer;

    public void execute() {
        this.initialize();
        this.mainLoop();
        this.cleanup();
    }

    private void switchMode() throws LWJGLException {
        this.mode = FullScreenWindowedTest.findDisplayMode(1024, 600, Display.getDisplayMode().getBitsPerPixel());
        try {
            Display.setDisplayModeAndFullscreen(this.mode);
        }
        catch (PowerManagementEventException e) {
            e.printStackTrace();
        }
    }

    private void initialize() {
        try {
            this.switchMode();
            this.quadPosition = new Vector2f(100.0f, 100.0f);
            this.quadVelocity = new Vector2f(1.0f, 1.0f);
            this.reinit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void reinit() throws LWJGLException {
        Display.create(new PixelFormat());
        this.glInit();
        this.renderer = new QuadRenderer();
    }

    private void mainLoop() {
        while (!Keyboard.isKeyDown(1) && !Display.isCloseRequested()) {
            if (Display.isVisible()) {
                this.processKeyboard();
                this.logic();
                this.render();
            } else {
                if (Display.isDirty()) {
                    this.render();
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            try {
                Display.update();
                Display.sync(60);
            }
            catch (PowerManagementEventException e) {
                e.printStackTrace();
            }
        }
    }

    private void logic() {
        this.angle += this.angleRotation;
        if (this.angle > 90.0f) {
            this.angle = 0.0f;
        }
        this.quadPosition.x += this.quadVelocity.x;
        this.quadPosition.y += this.quadVelocity.y;
        if (this.quadPosition.x + 50.0f >= (float)this.mode.getWidth() || this.quadPosition.x - 50.0f <= 0.0f) {
            this.quadVelocity.x *= -1.0f;
        }
        if (this.quadPosition.y + 50.0f >= (float)this.mode.getHeight() || this.quadPosition.y - 50.0f <= 0.0f) {
            this.quadVelocity.y *= -1.0f;
        }
    }

    private void render() {
        GLES20.glClear(16384);
        GLMatrix.glPushMatrix();
        GLMatrix.glTranslatef(this.quadPosition.x, this.quadPosition.y, 0.0f);
        GLMatrix.glRotatef(this.angle, 0.0f, 0.0f, 1.0f);
        this.renderer.setMVPUniform();
        GLES20.glDrawElements(5, 4, 5125, 0L);
        GLMatrix.glPopMatrix();
    }

    private void processKeyboard() {
        if (Keyboard.isKeyDown(33)) {
            try {
                this.cleanup();
                this.switchMode();
                this.reinit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (Keyboard.isKeyDown(17)) {
            try {
                this.cleanup();
                this.mode = new DisplayMode(800, 480);
                Display.setDisplayModeAndFullscreen(this.mode);
                this.reinit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (Keyboard.isKeyDown(200)) {
            this.quadVelocity.y += 0.1f;
        }
        if (Keyboard.isKeyDown(208)) {
            this.quadVelocity.y -= 0.1f;
        }
        if (Keyboard.isKeyDown(205)) {
            this.quadVelocity.x += 0.1f;
        }
        if (Keyboard.isKeyDown(203)) {
            this.quadVelocity.x -= 0.1f;
        }
        if (Keyboard.isKeyDown(78)) {
            this.angleRotation += 0.1f;
        }
        if (Keyboard.isKeyDown(74)) {
            this.angleRotation -= 0.1f;
        }
        if (this.quadVelocity.x < -20.0f) {
            this.quadVelocity.x = -20.0f;
        }
        if (this.quadVelocity.x > 20.0f) {
            this.quadVelocity.x = 20.0f;
        }
        if (this.quadVelocity.y < -20.0f) {
            this.quadVelocity.y = -20.0f;
        }
        if (this.quadVelocity.y > 20.0f) {
            this.quadVelocity.y = 20.0f;
        }
        if (this.angleRotation < 0.0f) {
            this.angleRotation = 0.0f;
        }
        if (this.angleRotation > 20.0f) {
            this.angleRotation = 20.0f;
        }
    }

    private void cleanup() {
        this.renderer.cleanup();
        IntBuffer int_buffer = BufferUtils.createIntBuffer(2);
        int_buffer.put(0, buffer_id);
        int_buffer.put(1, indices_buffer_id);
        GLES20.glDeleteBuffers(int_buffer);
        Display.destroy();
    }

    private static DisplayMode findDisplayMode(int width, int height, int bpp) throws LWJGLException {
        DisplayMode[] modes = Display.getAvailableDisplayModes();
        for (int i = 0; i < modes.length; ++i) {
            if (modes[i].getWidth() != width || modes[i].getHeight() != height || modes[i].getBitsPerPixel() < bpp || modes[i].getFrequency() > 60) continue;
            return modes[i];
        }
        return Display.getDesktopDisplayMode();
    }

    private void glInit() {
        GLMatrix.glMatrixMode(5889);
        GLMatrix.glLoadIdentity();
        GLMatrix.glOrtho(0.0f, this.mode.getWidth(), 0.0f, this.mode.getHeight(), -1.0f, 1.0f);
        GLMatrix.glMatrixMode(5888);
        GLMatrix.glLoadIdentity();
        GLES20.glViewport(0, 0, this.mode.getWidth(), this.mode.getHeight());
        GLES20.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        Display.setVSyncEnabled(true);
        IntBuffer int_buffer = BufferUtils.createIntBuffer(2);
        GLES20.glGenBuffers(int_buffer);
        buffer_id = int_buffer.get(0);
        indices_buffer_id = int_buffer.get(1);
        GLES20.glBindBuffer(34962, buffer_id);
        GLES20.glBindBuffer(34963, indices_buffer_id);
        FloatBuffer vertices = BufferUtils.createFloatBuffer(8);
        vertices.put(-50.0f).put(-50.0f).put(50.0f).put(-50.0f).put(-50.0f).put(50.0f).put(50.0f).put(50.0f);
        vertices.rewind();
        IntBuffer indices = BufferUtils.createIntBuffer(4);
        indices.put(0).put(1).put(2).put(3);
        indices.rewind();
        GLES20.glBufferData(34962, vertices, 35044);
        GLES20.glBufferData(34963, indices, 35044);
    }

    public static void main(String[] args) {
        System.out.println("Change between fullscreen and windowed mode, by pressing F and W respectively");
        System.out.println("Move quad using arrowkeys, and change rotation using +/-");
        FullScreenWindowedTest fswTest = new FullScreenWindowedTest();
        fswTest.execute();
        System.exit(0);
    }
}

