/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.opengl.sprites;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Random;
import javax.imageio.ImageIO;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.Sys;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.EXTTransformFeedback;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.Util;
import org.lwjgl.test.opengl.sprites.StreamVBO;
import org.lwjgl.util.mapped.MappedObject;
import org.lwjgl.util.mapped.MappedObjectClassLoader;
import org.lwjgl.util.mapped.MappedObjectTransformer;
import org.lwjgl.util.mapped.MappedType;

public final class SpriteShootoutMapped {
    static final int SCREEN_WIDTH = 800;
    static final int SCREEN_HEIGHT = 600;
    private static final int ANIMATION_TICKS = 60;
    private boolean run = true;
    private boolean render = true;
    private boolean colorMask = true;
    private boolean animate = true;
    private boolean smooth;
    private boolean vsync;
    int ballSize = 42;
    int ballCount = 100000;
    private SpriteRenderer renderer;
    private int texID;
    private int texBigID;
    private int texSmallID;
    long animateTime;

    private SpriteShootoutMapped() {
    }

    public static void main(String[] args) {
        MappedObjectTransformer.register(Pixel4b.class);
        MappedObjectTransformer.register(Pixel3b.class);
        MappedObjectTransformer.register(Sprite.class);
        MappedObjectTransformer.register(SpriteRender.class);
        if (MappedObjectClassLoader.fork(SpriteShootoutMapped.class, args)) {
            return;
        }
        try {
            new SpriteShootoutMapped().start();
        }
        catch (LWJGLException e) {
            e.printStackTrace();
        }
    }

    private void start() throws LWJGLException {
        try {
            this.initGL();
            ContextCapabilities caps = GLContext.getCapabilities();
            this.renderer = caps.GL_ARB_map_buffer_range ? new SpriteRendererMapped() : new SpriteRendererPlain();
            this.updateBalls(this.ballCount);
            this.run();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            this.destroy();
        }
    }

    private void initGL() throws LWJGLException {
        Display.setLocation((Display.getDisplayMode().getWidth() - 800) / 2, (Display.getDisplayMode().getHeight() - 600) / 2);
        Display.setDisplayMode(new DisplayMode(800, 600));
        Display.setTitle("Sprite Shootout");
        Display.create();
        if (!GLContext.getCapabilities().OpenGL20) {
            throw new RuntimeException("OpenGL 2.0 is required for this demo.");
        }
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        GL11.glOrtho(0.0, 800.0, 0.0, 600.0, -1.0, 1.0);
        GL11.glMatrixMode(5888);
        GL11.glLoadIdentity();
        GL11.glViewport(0, 0, 800, 600);
        GL11.glClearColor(1.0f, 1.0f, 1.0f, 0.0f);
        try {
            this.texSmallID = SpriteShootoutMapped.createTexture("res/ball_sm.png");
            this.texBigID = SpriteShootoutMapped.createTexture("res/ball.png");
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        this.texID = this.texBigID;
        GL11.glEnable(3042);
        GL11.glBlendFunc(1, 771);
        GL11.glEnable(3008);
        GL11.glAlphaFunc(516, 0.0f);
        GL11.glColorMask(this.colorMask, this.colorMask, this.colorMask, false);
        GL11.glDepthMask(false);
        GL11.glDisable(2929);
        GL11.glEnableClientState(32884);
        Util.checkGLError();
    }

    private static int createTexture(String path) throws IOException {
        BufferedImage img = ImageIO.read(SpriteShootoutMapped.class.getClassLoader().getResource(path));
        int w = img.getWidth();
        int h = img.getHeight();
        ByteBuffer buffer = SpriteShootoutMapped.readImage(img);
        int texID = GL11.glGenTextures();
        GL11.glBindTexture(3553, texID);
        GL11.glTexParameteri(3553, 10242, 10496);
        GL11.glTexParameteri(3553, 10243, 10496);
        GL11.glTexParameteri(3553, 10241, 9728);
        GL11.glTexParameteri(3553, 10240, 9728);
        GL11.glTexImage2D(3553, 0, 6408, w, h, 0, 32993, 5121, buffer);
        return texID;
    }

    private static ByteBuffer readImage(BufferedImage img) throws IOException {
        WritableRaster raster = img.getRaster();
        int bands = raster.getNumBands();
        int w = img.getWidth();
        int h = img.getHeight();
        int count = w * h;
        byte[] pixels = new byte[count * bands];
        raster.getDataElements(0, 0, w, h, pixels);
        if (bands == 4) {
            Pixel4b p = (Pixel4b)Pixel4b.malloc(count);
            int b = 0;
            int i = 0;
            while (i < count) {
                float a = SpriteShootoutMapped.unpackUByte01(pixels[b + 3]);
                p.view = i++;
                p.r = SpriteShootoutMapped.packUByte01(SpriteShootoutMapped.unpackUByte01(pixels[b + 2]) * a);
                p.g = SpriteShootoutMapped.packUByte01(SpriteShootoutMapped.unpackUByte01(pixels[b + 1]) * a);
                p.b = SpriteShootoutMapped.packUByte01(SpriteShootoutMapped.unpackUByte01(pixels[b + 0]) * a);
                p.a = pixels[b + 3];
                b += 4;
            }
            return p.backingByteBuffer();
        }
        if (bands == 3) {
            Pixel3b p = (Pixel3b)Pixel3b.malloc(count);
            int b = 0;
            int i = 0;
            while (i < count) {
                p.view = i++;
                p.r = pixels[b + 2];
                p.g = pixels[b + 1];
                p.b = pixels[b + 0];
                b += 3;
            }
            return p.backingByteBuffer();
        }
        ByteBuffer p = BufferUtils.createByteBuffer(count * bands);
        p.put(pixels, 0, p.capacity());
        p.flip();
        return p;
    }

    private static float unpackUByte01(byte x) {
        return (float)(x & 0xFF) / 255.0f;
    }

    private static byte packUByte01(float x) {
        return (byte)(x * 255.0f);
    }

    private void updateBalls(int count) {
        System.out.println("NUMBER OF BALLS: " + count);
        this.renderer.updateBalls(this.ballCount);
    }

    private void run() {
        long startTime = System.currentTimeMillis() + 5000L;
        long fps = 0L;
        long time = Sys.getTime();
        int ticksPerUpdate = (int)(Sys.getTimerResolution() / 60L);
        this.renderer.render(false, true, 0);
        while (this.run) {
            Display.processMessages();
            this.handleInput();
            GL11.glClear(16384);
            long currTime = Sys.getTime();
            int delta = (int)(currTime - time);
            if (this.smooth || delta >= ticksPerUpdate) {
                this.renderer.render(this.render, this.animate, delta);
                time = currTime;
            } else {
                this.renderer.render(this.render, false, 0);
            }
            Display.update(false);
            if (startTime > System.currentTimeMillis()) {
                ++fps;
                continue;
            }
            long timeUsed = 5000L + (startTime - System.currentTimeMillis());
            startTime = System.currentTimeMillis() + 5000L;
            System.out.println("FPS: " + (double)Math.round((double)fps / ((double)timeUsed / 1000.0) * 10.0) / 10.0 + ", Balls: " + this.ballCount);
            System.out.println("Animation: " + this.animateTime / fps);
            this.animateTime = 0L;
            fps = 0L;
        }
    }

    private void handleInput() {
        if (Display.isCloseRequested()) {
            this.run = false;
        }
        while (Keyboard.next()) {
            if (Keyboard.getEventKeyState()) continue;
            switch (Keyboard.getEventKey()) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    this.ballCount = 1 << Keyboard.getEventKey() - 2;
                    this.updateBalls(this.ballCount);
                    break;
                }
                case 74: 
                case 78: {
                    int mult = Keyboard.isKeyDown(42) || Keyboard.isKeyDown(54) ? 1000 : (Keyboard.isKeyDown(56) || Keyboard.isKeyDown(184) ? 100 : (Keyboard.isKeyDown(29) || Keyboard.isKeyDown(157) ? 10 : 1));
                    if (Keyboard.getEventKey() == 74) {
                        mult = -mult;
                    }
                    this.ballCount += mult * 100;
                    if (this.ballCount <= 0) {
                        this.ballCount = 1;
                    }
                    this.updateBalls(this.ballCount);
                    break;
                }
                case 1: {
                    this.run = false;
                    break;
                }
                case 30: {
                    this.animate = !this.animate;
                    System.out.println("Animation is now " + (this.animate ? "on" : "off") + ".");
                    break;
                }
                case 46: {
                    this.colorMask = !this.colorMask;
                    GL11.glColorMask(this.colorMask, this.colorMask, this.colorMask, false);
                    System.out.println("Color mask is now " + (this.colorMask ? "on" : "off") + ".");
                    if (this.colorMask) {
                        GL11.glEnable(3042);
                        GL11.glEnable(3008);
                        break;
                    }
                    GL11.glDisable(3042);
                    GL11.glDisable(3008);
                    break;
                }
                case 19: {
                    this.render = !this.render;
                    System.out.println("Rendering is now " + (this.render ? "on" : "off") + ".");
                    break;
                }
                case 31: {
                    this.smooth = !this.smooth;
                    System.out.println("Smooth animation is now " + (this.smooth ? "on" : "off") + ".");
                    break;
                }
                case 20: {
                    if (this.texID == this.texBigID) {
                        this.texID = this.texSmallID;
                        this.ballSize = 16;
                    } else {
                        this.texID = this.texBigID;
                        this.ballSize = 42;
                    }
                    this.renderer.updateBallSize();
                    GL11.glBindTexture(3553, this.texID);
                    System.out.println("Now using the " + (this.texID == this.texBigID ? "big" : "small") + " texture.");
                    break;
                }
                case 47: {
                    this.vsync = !this.vsync;
                    Display.setVSyncEnabled(this.vsync);
                    System.out.println("VSYNC is now " + (this.vsync ? "enabled" : "disabled") + ".");
                }
            }
        }
        while (Mouse.next()) {
        }
    }

    private void destroy() {
        Display.destroy();
    }

    private class SpriteRendererTF
    extends SpriteRenderer {
        private int progIDTF;
        private int ballSizeLoc;
        private int deltaLoc;
        private int[] tfVBO;
        private int currVBO;

        SpriteRendererTF() {
            this.tfVBO = new int[2];
            System.out.println("Shootout Implementation: TF GPU animation");
            int vshID = GL20.glCreateShader(35633);
            GL20.glShaderSource(vshID, "#version 130\nconst float WIDTH = 800;\nconst float HEIGHT = 600;\nuniform float ballSize;\nuniform float delta;\nvoid main(void) {\n     vec4 anim = gl_Vertex;\n     anim.xy = anim.xy + anim.zw * delta;\n     vec2 animC = clamp(anim.xy, vec2(ballSize), vec2(WIDTH - ballSize, HEIGHT - ballSize));\n     if ( anim.x != animC.x ) anim.z = -anim.z;\n     if ( anim.y != animC.y ) anim.w = -anim.w;\n     gl_Position = vec4(animC, anim.zw);\n}");
            GL20.glCompileShader(vshID);
            if (GL20.glGetShaderi(vshID, 35713) == 0) {
                System.out.println(GL20.glGetShaderInfoLog(vshID, GL20.glGetShaderi(vshID, 35716)));
                throw new RuntimeException("Failed to compile vertex shader.");
            }
            this.progIDTF = GL20.glCreateProgram();
            GL20.glAttachShader(this.progIDTF, vshID);
            GL30.glTransformFeedbackVaryings(this.progIDTF, new CharSequence[]{"gl_Position"}, 35981);
            GL20.glLinkProgram(this.progIDTF);
            if (GL20.glGetProgrami(this.progIDTF, 35714) == 0) {
                System.out.println(GL20.glGetProgramInfoLog(this.progIDTF, GL20.glGetProgrami(this.progIDTF, 35716)));
                throw new RuntimeException("Failed to link shader program.");
            }
            GL20.glUseProgram(this.progIDTF);
            this.ballSizeLoc = GL20.glGetUniformLocation(this.progIDTF, "ballSize");
            this.deltaLoc = GL20.glGetUniformLocation(this.progIDTF, "delta");
            GL20.glUniform1f(this.ballSizeLoc, (float)SpriteShootoutMapped.this.ballSize * 0.5f);
            this.vshID = GL20.glCreateShader(35633);
            GL20.glShaderSource(this.vshID, "void main(void) {\n     gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;\n}");
            GL20.glCompileShader(this.vshID);
            if (GL20.glGetShaderi(this.vshID, 35713) == 0) {
                System.out.println(GL20.glGetShaderInfoLog(this.vshID, GL20.glGetShaderi(this.vshID, 35716)));
                throw new RuntimeException("Failed to compile vertex shader.");
            }
            this.createProgram();
        }

        public void updateBallSize() {
            GL20.glUseProgram(this.progIDTF);
            GL20.glUniform1f(this.ballSizeLoc, (float)SpriteShootoutMapped.this.ballSize * 0.5f);
            GL20.glUseProgram(this.progID);
            super.updateBallSize();
        }

        private void doUpdateBalls(int count) {
            Random random = new Random();
            Sprite newSprites = (Sprite)Sprite.malloc(count);
            if (this.sprites != null) {
                this.sprites.view = 0;
                this.sprites.copyRange(newSprites, Math.min(count, this.spriteCount));
            }
            if (count > this.spriteCount) {
                int i = this.spriteCount;
                while (i < count) {
                    newSprites.view = i++;
                    newSprites.x = (int)(random.nextFloat() * (float)(800 - SpriteShootoutMapped.this.ballSize) + (float)SpriteShootoutMapped.this.ballSize * 0.5f);
                    newSprites.y = (int)(random.nextFloat() * (float)(600 - SpriteShootoutMapped.this.ballSize) + (float)SpriteShootoutMapped.this.ballSize * 0.5f);
                    newSprites.dx = random.nextFloat() * 0.4f - 0.2f;
                    newSprites.dy = random.nextFloat() * 0.4f - 0.2f;
                }
            }
            this.sprites = newSprites;
            this.spriteCount = count;
        }

        public void updateBalls(int count) {
            int i;
            if (this.tfVBO[0] != 0) {
                GL15.glGetBufferSubData(35982, 0L, this.sprites.backingByteBuffer());
            }
            this.doUpdateBalls(count);
            if (this.tfVBO[0] != 0) {
                for (i = 0; i < this.tfVBO.length; ++i) {
                    GL15.glDeleteBuffers(this.tfVBO[i]);
                }
            }
            for (i = 0; i < this.tfVBO.length; ++i) {
                this.tfVBO[i] = GL15.glGenBuffers();
                GL15.glBindBuffer(35982, this.tfVBO[i]);
                GL15.glBufferData(35982, this.sprites.backingByteBuffer(), 35044);
            }
            GL15.glBindBuffer(34962, this.tfVBO[0]);
            GL11.glVertexPointer(2, 5126, 16, 0L);
        }

        public void render(boolean render, boolean animate, int delta) {
            if (animate) {
                GL20.glUseProgram(this.progIDTF);
                GL20.glUniform1f(this.deltaLoc, delta);
                int vbo = this.currVBO;
                this.currVBO = 1 - this.currVBO;
                GL15.glBindBuffer(34962, this.tfVBO[vbo]);
                GL11.glVertexPointer(4, 5126, 0, 0L);
                GL11.glEnable(35977);
                if (GLContext.getCapabilities().OpenGL30) {
                    GL30.glBindBufferBase(35982, 0, this.tfVBO[1 - vbo]);
                    GL30.glBeginTransformFeedback(0);
                    GL11.glDrawArrays(0, 0, SpriteShootoutMapped.this.ballCount);
                    GL30.glEndTransformFeedback();
                } else {
                    EXTTransformFeedback.glBindBufferBaseEXT(35982, 0, this.tfVBO[1 - vbo]);
                    EXTTransformFeedback.glBeginTransformFeedbackEXT(0);
                    GL11.glDrawArrays(0, 0, SpriteShootoutMapped.this.ballCount);
                    EXTTransformFeedback.glEndTransformFeedbackEXT();
                }
                GL11.glDisable(35977);
                GL20.glUseProgram(this.progID);
                GL11.glVertexPointer(2, 5126, 16, 0L);
            }
            if (render) {
                GL11.glDrawArrays(0, 0, SpriteShootoutMapped.this.ballCount);
            }
        }
    }

    private class SpriteRendererMapped
    extends SpriteRendererBatched {
        private StreamVBO animVBO;

        SpriteRendererMapped() {
            System.out.println("Shootout Implementation: CPU animation & MapBufferRange");
        }

        public void updateBalls(int count) {
            super.updateBalls(count);
            if (this.animVBO != null) {
                this.animVBO.destroy();
            }
            this.animVBO = new StreamVBO(34962, SpriteShootoutMapped.this.ballCount * 8);
        }

        public void render(boolean render, boolean animate, int delta) {
            int batchSize = Math.min(SpriteShootoutMapped.this.ballCount, 10000);
            int ballIndex = 0;
            while (ballIndex < SpriteShootoutMapped.this.ballCount) {
                if (animate) {
                    ByteBuffer buffer = this.animVBO.map(batchSize * 8);
                    long t0 = System.nanoTime();
                    this.animate(this.sprites, (SpriteRender)SpriteRender.map(buffer), SpriteShootoutMapped.this.ballSize, ballIndex, batchSize, delta);
                    long t1 = System.nanoTime();
                    SpriteShootoutMapped.this.animateTime += t1 - t0;
                    this.animVBO.unmap();
                }
                if (render) {
                    GL11.glVertexPointer(2, 5126, 0, ballIndex * 8);
                    GL11.glDrawArrays(0, 0, batchSize);
                }
                batchSize = Math.min(SpriteShootoutMapped.this.ballCount - (ballIndex += batchSize), 10000);
            }
        }
    }

    private class SpriteRendererPlain
    extends SpriteRendererBatched {
        private final int DATA_PER_BATCH = 80000;
        protected int[] animVBO;
        private SpriteRender spritesRender;

        SpriteRendererPlain() {
            this.DATA_PER_BATCH = 80000;
            System.out.println("Shootout Implementation: CPU animation & BufferData");
            this.spritesRender = (SpriteRender)SpriteRender.malloc(10000);
        }

        public void updateBalls(int count) {
            int i;
            super.updateBalls(count);
            int batchCount = count / 10000 + (count % 10000 == 0 ? 0 : 1);
            if (this.animVBO != null && batchCount == this.animVBO.length) {
                return;
            }
            int[] newAnimVBO = new int[batchCount];
            if (this.animVBO != null) {
                System.arraycopy(this.animVBO, 0, newAnimVBO, 0, Math.min(this.animVBO.length, newAnimVBO.length));
                for (i = newAnimVBO.length; i < this.animVBO.length; ++i) {
                    GL15.glDeleteBuffers(this.animVBO[i]);
                }
            }
            int n = i = this.animVBO == null ? 0 : this.animVBO.length;
            while (i < newAnimVBO.length) {
                newAnimVBO[i] = GL15.glGenBuffers();
                GL15.glBindBuffer(34962, newAnimVBO[i]);
                ++i;
            }
            this.animVBO = newAnimVBO;
        }

        public void render(boolean render, boolean animate, int delta) {
            int batchSize = Math.min(SpriteShootoutMapped.this.ballCount, 10000);
            int ballIndex = 0;
            int batchIndex = 0;
            while (ballIndex < SpriteShootoutMapped.this.ballCount) {
                GL15.glBindBuffer(34962, this.animVBO[batchIndex]);
                if (animate) {
                    this.animate(ballIndex, batchSize, delta);
                }
                if (render) {
                    GL11.glVertexPointer(2, 5126, 0, 0L);
                    GL11.glDrawArrays(0, 0, batchSize);
                }
                batchSize = Math.min(SpriteShootoutMapped.this.ballCount - (ballIndex += batchSize), 10000);
                ++batchIndex;
            }
        }

        private void animate(int ballIndex, int batchSize, int delta) {
            this.animate(this.sprites, this.spritesRender, SpriteShootoutMapped.this.ballSize, ballIndex, batchSize, delta);
            GL15.glBufferData(34962, 80000L, 35040);
            GL15.glBufferSubData(34962, 0L, this.spritesRender.backingByteBuffer());
        }
    }

    private abstract class SpriteRendererBatched
    extends SpriteRenderer {
        protected static final int BALLS_PER_BATCH = 10000;

        SpriteRendererBatched() {
            this.vshID = GL20.glCreateShader(35633);
            GL20.glShaderSource(this.vshID, "void main(void) {\n     gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;\n}");
            GL20.glCompileShader(this.vshID);
            if (GL20.glGetShaderi(this.vshID, 35713) == 0) {
                System.out.println(GL20.glGetShaderInfoLog(this.vshID, GL20.glGetShaderi(this.vshID, 35716)));
                throw new RuntimeException("Failed to compile vertex shader.");
            }
            this.createProgram();
        }

        public void updateBalls(int count) {
            Random random = new Random();
            Sprite newSprites = (Sprite)Sprite.malloc(count);
            if (this.sprites != null) {
                this.sprites.view = 0;
                this.sprites.copyRange(newSprites, Math.min(count, this.spriteCount));
            }
            if (count > this.spriteCount) {
                int i = this.spriteCount;
                while (i < count) {
                    newSprites.view = i++;
                    newSprites.x = (int)(random.nextFloat() * (float)(800 - SpriteShootoutMapped.this.ballSize) + (float)SpriteShootoutMapped.this.ballSize * 0.5f);
                    newSprites.y = (int)(random.nextFloat() * (float)(600 - SpriteShootoutMapped.this.ballSize) + (float)SpriteShootoutMapped.this.ballSize * 0.5f);
                    newSprites.dx = random.nextFloat() * 0.4f - 0.2f;
                    newSprites.dy = random.nextFloat() * 0.4f - 0.2f;
                }
            }
            this.sprites = newSprites;
            this.spriteCount = count;
        }

        protected void animate(Sprite sprite, SpriteRender spriteRender, int ballSize, int ballIndex, int batchSize, int delta) {
            float ballRadius = (float)ballSize * 0.5f;
            float boundW = 800.0f - ballRadius;
            float boundH = 600.0f - ballRadius;
            Sprite[] sprites = (Sprite[])sprite.asArray();
            SpriteRender[] spritesRender = (SpriteRender[])spriteRender.asArray();
            int b = ballIndex;
            int r = 0;
            int len = ballIndex + batchSize;
            while (b < len) {
                float dx = sprites[b].dx;
                float x = sprites[b].x;
                if ((x += dx * (float)delta) < ballRadius) {
                    x = ballRadius;
                    dx = -dx;
                } else if (x > boundW) {
                    x = boundW;
                    dx = -dx;
                }
                sprites[b].dx = dx;
                sprites[b].x = x;
                spritesRender[r].x = x;
                float dy = sprites[b].dy;
                float y = sprites[b].y;
                y += dy * (float)delta;
                if (y < ballRadius) {
                    y = ballRadius;
                    dy = -dy;
                } else if (y > boundH) {
                    y = boundH;
                    dy = -dy;
                }
                sprites[b].dy = dy;
                sprites[b].y = y;
                spritesRender[r].y = y;
                ++b;
                ++r;
            }
        }
    }

    private abstract class SpriteRenderer {
        protected Sprite sprites;
        protected int spriteCount;
        protected int vshID;
        protected int progID;

        private SpriteRenderer() {
        }

        protected void createProgram() {
            int fshID = GL20.glCreateShader(35632);
            GL20.glShaderSource(fshID, "uniform sampler2D COLOR_MAP;\nvoid main(void) {\n     gl_FragColor = texture2D(COLOR_MAP, gl_PointCoord);\n}");
            GL20.glCompileShader(fshID);
            if (GL20.glGetShaderi(fshID, 35713) == 0) {
                System.out.println(GL20.glGetShaderInfoLog(fshID, GL20.glGetShaderi(fshID, 35716)));
                throw new RuntimeException("Failed to compile fragment shader.");
            }
            this.progID = GL20.glCreateProgram();
            GL20.glAttachShader(this.progID, this.vshID);
            GL20.glAttachShader(this.progID, fshID);
            GL20.glLinkProgram(this.progID);
            if (GL20.glGetProgrami(this.progID, 35714) == 0) {
                System.out.println(GL20.glGetProgramInfoLog(this.progID, GL20.glGetProgrami(this.progID, 35716)));
                throw new RuntimeException("Failed to link shader program.");
            }
            GL20.glUseProgram(this.progID);
            GL20.glUniform1i(GL20.glGetUniformLocation(this.progID, "COLOR_MAP"), 0);
            this.updateBallSize();
            GL11.glEnableClientState(32884);
        }

        public void updateBallSize() {
            GL11.glPointSize(SpriteShootoutMapped.this.ballSize);
        }

        public abstract void updateBalls(int var1);

        protected abstract void render(boolean var1, boolean var2, int var3);
    }

    public static class SpriteRender
    extends MappedObject {
        public float x;
        public float y;
    }

    public static class Sprite
    extends MappedObject {
        public float dx;
        public float x;
        public float dy;
        public float y;
    }

    @MappedType(align=3)
    public static class Pixel3b
    extends MappedObject {
        public byte r;
        public byte g;
        public byte b;
    }

    public static class Pixel4b
    extends MappedObject {
        public byte r;
        public byte g;
        public byte b;
        public byte a;
    }
}

