/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.opengl.sprites;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.List;
import java.util.Random;
import javax.imageio.ImageIO;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.PointerBuffer;
import org.lwjgl.Sys;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opencl.CL;
import org.lwjgl.opencl.CL10;
import org.lwjgl.opencl.CL10GL;
import org.lwjgl.opencl.CLCapabilities;
import org.lwjgl.opencl.CLCommandQueue;
import org.lwjgl.opencl.CLContext;
import org.lwjgl.opencl.CLContextCallback;
import org.lwjgl.opencl.CLDevice;
import org.lwjgl.opencl.CLDeviceCapabilities;
import org.lwjgl.opencl.CLKernel;
import org.lwjgl.opencl.CLMem;
import org.lwjgl.opencl.CLPlatform;
import org.lwjgl.opencl.CLProgram;
import org.lwjgl.opencl.api.Filter;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.Util;

public final class SpriteShootoutCL {
    private static final int SCREEN_WIDTH = 800;
    private static final int SCREEN_HEIGHT = 600;
    private static final int ANIMATION_TICKS = 60;
    private boolean run = true;
    private boolean render = true;
    private boolean colorMask = true;
    private boolean animate = true;
    private boolean smooth;
    private boolean vsync;
    private int ballSize = 42;
    private int ballCount = 100000;
    private SpriteRenderer renderer;
    private int texID;
    private int texBigID;
    private int texSmallID;
    private IntBuffer errorCode = BufferUtils.createIntBuffer(1);
    private CLDevice clDevice;
    private CLContext clContext;
    private CLCommandQueue queue;
    private CLProgram program;
    private CLKernel kernel;
    private CLMem clTransform;
    private PointerBuffer kernelGlobalWorkSize;

    private SpriteShootoutCL() {
    }

    public static void main(String[] args) {
        try {
            new SpriteShootoutCL().start();
        }
        catch (LWJGLException e) {
            e.printStackTrace();
        }
    }

    private void start() throws LWJGLException {
        try {
            this.initGL();
            this.initCL();
            this.renderer = new SpriteRendererDefault();
            this.updateBalls(this.ballCount);
            this.run();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            this.destroy();
        }
    }

    private void initCL() throws LWJGLException {
        CL.create();
        List<CLPlatform> platforms = CLPlatform.getPlatforms();
        if (platforms == null) {
            throw new RuntimeException("No OpenCL platforms found.");
        }
        Filter<CLDevice> glSharingFilter = new Filter<CLDevice>(){

            @Override
            public boolean accept(CLDevice device) {
                CLDeviceCapabilities caps = CLCapabilities.getDeviceCapabilities(device);
                return caps.CL_KHR_gl_sharing;
            }
        };
        CLPlatform platform = null;
        List<CLDevice> devices = null;
        for (CLPlatform p : platforms) {
            devices = p.getDevices(4, glSharingFilter);
            if (devices == null) continue;
            platform = p;
            break;
        }
        if (devices == null) {
            throw new RuntimeException("No OpenCL GPU device found.");
        }
        this.clDevice = (CLDevice)devices.get(0);
        devices.clear();
        devices.add(this.clDevice);
        this.clContext = CLContext.create(platform, devices, new CLContextCallback(){

            protected void handleMessage(String errinfo, ByteBuffer private_info) {
                System.out.println("[CONTEXT MESSAGE] " + errinfo);
            }
        }, Display.getDrawable(), this.errorCode);
        SpriteShootoutCL.checkCLError(this.errorCode);
        this.queue = CL10.clCreateCommandQueue(this.clContext, this.clDevice, 0L, this.errorCode);
        SpriteShootoutCL.checkCLError(this.errorCode);
    }

    private void initGL() throws LWJGLException {
        Display.setLocation((Display.getDisplayMode().getWidth() - 800) / 2, (Display.getDisplayMode().getHeight() - 600) / 2);
        Display.setDisplayMode(new DisplayMode(800, 600));
        Display.setTitle("Sprite Shootout - CL");
        Display.create();
        ContextCapabilities caps = GLContext.getCapabilities();
        if (!caps.OpenGL20) {
            throw new RuntimeException("OpenGL 2.0 is required for this demo.");
        }
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        GL11.glOrtho(0.0, 800.0, 0.0, 600.0, -1.0, 1.0);
        GL11.glMatrixMode(5888);
        GL11.glLoadIdentity();
        GL11.glViewport(0, 0, 800, 600);
        GL11.glClearColor(1.0f, 1.0f, 1.0f, 0.0f);
        try {
            this.texSmallID = SpriteShootoutCL.createTexture("res/ball_sm.png");
            this.texBigID = SpriteShootoutCL.createTexture("res/ball.png");
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        this.texID = this.texBigID;
        GL11.glEnable(3042);
        GL11.glBlendFunc(1, 771);
        GL11.glEnable(3008);
        GL11.glAlphaFunc(516, 0.0f);
        GL11.glColorMask(this.colorMask, this.colorMask, this.colorMask, false);
        GL11.glDepthMask(false);
        GL11.glDisable(2929);
        if (caps.GL_ARB_compatibility || !caps.OpenGL31) {
            GL11.glEnable(34913);
        }
        Util.checkGLError();
    }

    private static int createTexture(String path) throws IOException {
        BufferedImage img = ImageIO.read(SpriteShootoutCL.class.getClassLoader().getResource(path));
        int w = img.getWidth();
        int h = img.getHeight();
        ByteBuffer buffer = SpriteShootoutCL.readImage(img);
        int texID = GL11.glGenTextures();
        GL11.glBindTexture(3553, texID);
        GL11.glTexParameteri(3553, 10242, 10496);
        GL11.glTexParameteri(3553, 10243, 10496);
        GL11.glTexParameteri(3553, 10241, 9728);
        GL11.glTexParameteri(3553, 10240, 9728);
        GL11.glTexImage2D(3553, 0, 6408, w, h, 0, 32993, 5121, buffer);
        return texID;
    }

    private static ByteBuffer readImage(BufferedImage img) throws IOException {
        WritableRaster raster = img.getRaster();
        int bands = raster.getNumBands();
        int w = img.getWidth();
        int h = img.getHeight();
        int size = w * h * bands;
        byte[] pixels = new byte[size];
        raster.getDataElements(0, 0, w, h, pixels);
        ByteBuffer pbuffer = BufferUtils.createByteBuffer(size);
        if (bands == 4) {
            for (int i = 0; i < w * h * 4; i += 4) {
                float a = SpriteShootoutCL.unpackUByte01(pixels[i + 3]);
                pbuffer.put(SpriteShootoutCL.packUByte01(SpriteShootoutCL.unpackUByte01(pixels[i + 2]) * a));
                pbuffer.put(SpriteShootoutCL.packUByte01(SpriteShootoutCL.unpackUByte01(pixels[i + 1]) * a));
                pbuffer.put(SpriteShootoutCL.packUByte01(SpriteShootoutCL.unpackUByte01(pixels[i + 0]) * a));
                pbuffer.put(pixels[i + 3]);
            }
        } else if (bands == 3) {
            for (int i = 0; i < w * h * 3; i += 3) {
                pbuffer.put(pixels[i + 2]);
                pbuffer.put(pixels[i + 1]);
                pbuffer.put(pixels[i + 0]);
            }
        } else {
            pbuffer.put(pixels, 0, size);
        }
        pbuffer.flip();
        return pbuffer;
    }

    private static float unpackUByte01(byte x) {
        return (float)(x & 0xFF) / 255.0f;
    }

    private static byte packUByte01(float x) {
        return (byte)(x * 255.0f);
    }

    private void updateBalls(int count) {
        System.out.println("NUMBER OF BALLS: " + count);
        this.renderer.updateBalls(this.ballCount);
    }

    private void run() {
        long startTime = System.currentTimeMillis() + 5000L;
        long fps = 0L;
        long time = Sys.getTime();
        int ticksPerUpdate = (int)(Sys.getTimerResolution() / 60L);
        this.renderer.render(false, true, 0);
        while (this.run) {
            Display.processMessages();
            this.handleInput();
            GL11.glClear(16384);
            long currTime = Sys.getTime();
            int delta = (int)(currTime - time);
            if (this.smooth || delta >= ticksPerUpdate) {
                this.renderer.render(this.render, this.animate, delta);
                time = currTime;
            } else {
                this.renderer.render(this.render, false, 0);
            }
            Display.update(false);
            if (startTime > System.currentTimeMillis()) {
                ++fps;
                continue;
            }
            long timeUsed = 5000L + (startTime - System.currentTimeMillis());
            startTime = System.currentTimeMillis() + 5000L;
            System.out.println("FPS: " + (double)Math.round((double)fps / ((double)timeUsed / 1000.0) * 10.0) / 10.0 + ", Balls: " + this.ballCount);
            fps = 0L;
        }
    }

    private void handleInput() {
        if (Display.isCloseRequested()) {
            this.run = false;
        }
        while (Keyboard.next()) {
            if (Keyboard.getEventKeyState()) continue;
            switch (Keyboard.getEventKey()) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    this.ballCount = 1 << Keyboard.getEventKey() - 2;
                    this.updateBalls(this.ballCount);
                    break;
                }
                case 74: 
                case 78: {
                    int mult = Keyboard.isKeyDown(42) || Keyboard.isKeyDown(54) ? 1000 : (Keyboard.isKeyDown(56) || Keyboard.isKeyDown(184) ? 100 : (Keyboard.isKeyDown(29) || Keyboard.isKeyDown(157) ? 10 : 1));
                    if (Keyboard.getEventKey() == 74) {
                        mult = -mult;
                    }
                    this.ballCount += mult * 100;
                    if (this.ballCount <= 0) {
                        this.ballCount = 1;
                    }
                    this.updateBalls(this.ballCount);
                    break;
                }
                case 1: {
                    this.run = false;
                    break;
                }
                case 30: {
                    this.animate = !this.animate;
                    System.out.println("Animation is now " + (this.animate ? "on" : "off") + ".");
                    break;
                }
                case 46: {
                    this.colorMask = !this.colorMask;
                    GL11.glColorMask(this.colorMask, this.colorMask, this.colorMask, false);
                    System.out.println("Color mask is now " + (this.colorMask ? "on" : "off") + ".");
                    if (this.colorMask) {
                        GL11.glEnable(3042);
                        GL11.glEnable(3008);
                        break;
                    }
                    GL11.glDisable(3042);
                    GL11.glDisable(3008);
                    break;
                }
                case 19: {
                    this.render = !this.render;
                    System.out.println("Rendering is now " + (this.render ? "on" : "off") + ".");
                    break;
                }
                case 31: {
                    this.smooth = !this.smooth;
                    System.out.println("Smooth animation is now " + (this.smooth ? "on" : "off") + ".");
                    break;
                }
                case 20: {
                    if (this.texID == this.texBigID) {
                        this.texID = this.texSmallID;
                        this.ballSize = 16;
                    } else {
                        this.texID = this.texBigID;
                        this.ballSize = 42;
                    }
                    this.renderer.updateBallSize();
                    GL11.glBindTexture(3553, this.texID);
                    System.out.println("Now using the " + (this.texID == this.texBigID ? "big" : "small") + " texture.");
                    break;
                }
                case 47: {
                    this.vsync = !this.vsync;
                    Display.setVSyncEnabled(this.vsync);
                    System.out.println("VSYNC is now " + (this.vsync ? "enabled" : "disabled") + ".");
                }
            }
        }
        while (Mouse.next()) {
        }
    }

    private static void checkCLError(IntBuffer buffer) {
        org.lwjgl.opencl.Util.checkCLError(buffer.get(0));
    }

    private void destroy() {
        if (this.clContext != null) {
            CL10.clReleaseContext(this.clContext);
        }
        Display.destroy();
        System.exit(0);
    }

    private class SpriteRendererDefault
    extends SpriteRenderer {
        SpriteRendererDefault() {
            System.out.println("Shootout Implementation: OpenCL GPU animation");
            int vshID = GL20.glCreateShader(35633);
            GL20.glShaderSource(vshID, "#version 150\nvoid main(void) {\n     gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;\n}");
            GL20.glCompileShader(vshID);
            if (GL20.glGetShaderi(vshID, 35713) == 0) {
                System.out.println(GL20.glGetShaderInfoLog(vshID, GL20.glGetShaderi(vshID, 35716)));
                throw new RuntimeException("Failed to compile vertex shader.");
            }
            this.createProgram(vshID);
            Util.checkGLError();
            this.createKernel("kernel void animate(\n        const int WIDTH,\n        const int HEIGHT,\n        const float radius,\n        const int delta,\n        global float4 *balls\n) {\n    unsigned int b = get_global_id(0);\n\n     float4 anim = balls[b];\n     anim.xy = anim.xy + anim.zw * delta;\n     float2 animC = clamp(anim.xy, (float2)radius, (float2)(WIDTH - radius, HEIGHT - radius));\n     if ( anim.x != animC.x ) anim.z = -anim.z;\n     if ( anim.y != animC.y ) anim.w = -anim.w;\n\n     balls[b] = (float4)(animC, anim.zw);\n}");
            this.updateBallSize();
        }

        public void updateBalls(int count) {
            super.updateBalls(count);
        }

        public void render(boolean render, boolean animate, int delta) {
            if (animate) {
                SpriteShootoutCL.this.kernel.setArg(3, delta);
                CL10GL.clEnqueueAcquireGLObjects(SpriteShootoutCL.this.queue, SpriteShootoutCL.this.clTransform, null, null);
                CL10.clEnqueueNDRangeKernel(SpriteShootoutCL.this.queue, SpriteShootoutCL.this.kernel, 1, null, SpriteShootoutCL.this.kernelGlobalWorkSize, null, null, null);
                CL10GL.clEnqueueReleaseGLObjects(SpriteShootoutCL.this.queue, SpriteShootoutCL.this.clTransform, null, null);
                CL10.clFinish(SpriteShootoutCL.this.queue);
            }
            if (render) {
                GL11.glDrawArrays(0, 0, SpriteShootoutCL.this.ballCount);
            }
        }
    }

    private abstract class SpriteRenderer {
        protected int progID;
        protected int animVBO;

        private SpriteRenderer() {
        }

        protected void createKernel(String source) {
            SpriteShootoutCL.this.program = CL10.clCreateProgramWithSource(SpriteShootoutCL.this.clContext, source, SpriteShootoutCL.this.errorCode);
            SpriteShootoutCL.checkCLError(SpriteShootoutCL.this.errorCode);
            int build = CL10.clBuildProgram(SpriteShootoutCL.this.program, SpriteShootoutCL.this.clDevice, (CharSequence)"", null);
            if (build != 0) {
                System.out.println("BUILD LOG: " + SpriteShootoutCL.this.program.getBuildInfoString(SpriteShootoutCL.this.clDevice, 4483));
                throw new RuntimeException("Failed to build CL program, status: " + build);
            }
            SpriteShootoutCL.this.kernel = CL10.clCreateKernel(SpriteShootoutCL.this.program, "animate", SpriteShootoutCL.this.errorCode);
            SpriteShootoutCL.checkCLError(SpriteShootoutCL.this.errorCode);
            SpriteShootoutCL.this.kernelGlobalWorkSize = BufferUtils.createPointerBuffer(1);
            SpriteShootoutCL.this.kernelGlobalWorkSize.put(0, SpriteShootoutCL.this.ballCount);
            SpriteShootoutCL.this.kernel.setArg(0, 800);
            SpriteShootoutCL.this.kernel.setArg(1, 600);
        }

        protected void createProgram(int vshID) {
            int fshID = GL20.glCreateShader(35632);
            GL20.glShaderSource(fshID, "#version 110\nuniform sampler2D COLOR_MAP;void main(void) {\n     gl_FragColor = texture2D(COLOR_MAP, gl_PointCoord);\n}");
            GL20.glCompileShader(fshID);
            if (GL20.glGetShaderi(fshID, 35713) == 0) {
                System.out.println(GL20.glGetShaderInfoLog(fshID, GL20.glGetShaderi(fshID, 35716)));
                throw new RuntimeException("Failed to compile fragment shader.");
            }
            this.progID = GL20.glCreateProgram();
            GL20.glAttachShader(this.progID, vshID);
            GL20.glAttachShader(this.progID, fshID);
            GL20.glLinkProgram(this.progID);
            if (GL20.glGetProgrami(this.progID, 35714) == 0) {
                System.out.println(GL20.glGetProgramInfoLog(this.progID, GL20.glGetProgrami(this.progID, 35716)));
                throw new RuntimeException("Failed to link shader program.");
            }
            GL20.glUseProgram(this.progID);
            GL20.glUniform1i(GL20.glGetUniformLocation(this.progID, "COLOR_MAP"), 0);
            GL11.glEnableClientState(32884);
        }

        public void updateBallSize() {
            GL11.glPointSize(SpriteShootoutCL.this.ballSize);
            SpriteShootoutCL.this.kernel.setArg(2, (float)SpriteShootoutCL.this.ballSize * 0.5f);
        }

        public void updateBalls(int count) {
            SpriteShootoutCL.this.kernelGlobalWorkSize.put(0, SpriteShootoutCL.this.ballCount);
            FloatBuffer transform = BufferUtils.createFloatBuffer(count * 4);
            Random random = new Random();
            for (int i = 0; i < count; ++i) {
                transform.put((float)((int)(random.nextFloat() * (float)(800 - SpriteShootoutCL.this.ballSize))) + (float)SpriteShootoutCL.this.ballSize * 0.5f);
                transform.put((float)((int)(random.nextFloat() * (float)(600 - SpriteShootoutCL.this.ballSize))) + (float)SpriteShootoutCL.this.ballSize * 0.5f);
                transform.put(random.nextFloat() * 0.4f - 0.2f);
                transform.put(random.nextFloat() * 0.4f - 0.2f);
            }
            transform.flip();
            if (this.animVBO != 0) {
                CL10.clReleaseMemObject(SpriteShootoutCL.this.clTransform);
                GL15.glDeleteBuffers(this.animVBO);
            }
            this.animVBO = GL15.glGenBuffers();
            GL15.glBindBuffer(34962, this.animVBO);
            GL15.glBufferData(34962, transform, 35044);
            GL11.glVertexPointer(2, 5126, 16, 0L);
            SpriteShootoutCL.this.clTransform = CL10GL.clCreateFromGLBuffer(SpriteShootoutCL.this.clContext, 1L, this.animVBO, SpriteShootoutCL.this.errorCode);
            SpriteShootoutCL.checkCLError(SpriteShootoutCL.this.errorCode);
            SpriteShootoutCL.this.kernel.setArg(4, SpriteShootoutCL.this.clTransform);
        }

        protected abstract void render(boolean var1, boolean var2, int var3);
    }
}

