/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.opengl.sprites;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.Random;
import javax.imageio.ImageIO;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.Sys;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.EXTTransformFeedback;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.Util;
import org.lwjgl.test.opengl.sprites.StreamVBO;

public final class SpriteShootout {
    static final int SCREEN_WIDTH = 800;
    static final int SCREEN_HEIGHT = 600;
    private static final int ANIMATION_TICKS = 60;
    private boolean run = true;
    private boolean render = true;
    private boolean colorMask = true;
    private boolean animate = true;
    private boolean smooth;
    private boolean vsync;
    int ballSize = 42;
    int ballCount = 100000;
    private SpriteRenderer renderer;
    private int texID;
    private int texBigID;
    private int texSmallID;
    long animateTime;

    private SpriteShootout() {
    }

    public static void main(String[] args) {
        try {
            new SpriteShootout().start();
        }
        catch (LWJGLException e) {
            e.printStackTrace();
        }
    }

    private void start() throws LWJGLException {
        try {
            this.initGL();
            ContextCapabilities caps = GLContext.getCapabilities();
            this.renderer = caps.OpenGL30 || caps.GL_EXT_transform_feedback ? new SpriteRendererTF() : (caps.GL_ARB_map_buffer_range ? new SpriteRendererMapped() : new SpriteRendererPlain());
            this.updateBalls(this.ballCount);
            this.run();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            this.destroy();
        }
    }

    private void initGL() throws LWJGLException {
        Display.setLocation((Display.getDisplayMode().getWidth() - 800) / 2, (Display.getDisplayMode().getHeight() - 600) / 2);
        Display.setDisplayMode(new DisplayMode(800, 600));
        Display.setTitle("Sprite Shootout");
        Display.create();
        ContextCapabilities caps = GLContext.getCapabilities();
        if (!GLContext.getCapabilities().OpenGL20) {
            throw new RuntimeException("OpenGL 2.0 is required for this demo.");
        }
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        GL11.glOrtho(0.0, 800.0, 0.0, 600.0, -1.0, 1.0);
        GL11.glMatrixMode(5888);
        GL11.glLoadIdentity();
        GL11.glViewport(0, 0, 800, 600);
        GL11.glClearColor(1.0f, 1.0f, 1.0f, 0.0f);
        try {
            this.texSmallID = SpriteShootout.createTexture("res/ball_sm.png");
            this.texBigID = SpriteShootout.createTexture("res/ball.png");
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        this.texID = this.texBigID;
        GL11.glEnable(3042);
        GL11.glBlendFunc(1, 771);
        GL11.glEnable(3008);
        GL11.glAlphaFunc(516, 0.0f);
        GL11.glColorMask(this.colorMask, this.colorMask, this.colorMask, false);
        GL11.glDepthMask(false);
        GL11.glDisable(2929);
        if (caps.GL_ARB_compatibility || !caps.OpenGL31) {
            GL11.glEnable(34913);
        }
        GL11.glEnableClientState(32884);
        Util.checkGLError();
    }

    private static int createTexture(String path) throws IOException {
        BufferedImage img = ImageIO.read(SpriteShootout.class.getClassLoader().getResource(path));
        int w = img.getWidth();
        int h = img.getHeight();
        ByteBuffer buffer = SpriteShootout.readImage(img);
        int texID = GL11.glGenTextures();
        GL11.glBindTexture(3553, texID);
        GL11.glTexParameteri(3553, 10242, 10496);
        GL11.glTexParameteri(3553, 10243, 10496);
        GL11.glTexParameteri(3553, 10241, 9728);
        GL11.glTexParameteri(3553, 10240, 9728);
        GL11.glTexImage2D(3553, 0, 6408, w, h, 0, 32993, 5121, buffer);
        return texID;
    }

    private static ByteBuffer readImage(BufferedImage img) throws IOException {
        WritableRaster raster = img.getRaster();
        int bands = raster.getNumBands();
        int w = img.getWidth();
        int h = img.getHeight();
        int size = w * h * bands;
        byte[] pixels = new byte[size];
        raster.getDataElements(0, 0, w, h, pixels);
        ByteBuffer pbuffer = BufferUtils.createByteBuffer(size);
        if (bands == 4) {
            for (int i = 0; i < w * h * 4; i += 4) {
                float a = SpriteShootout.unpackUByte01(pixels[i + 3]);
                pbuffer.put(SpriteShootout.packUByte01(SpriteShootout.unpackUByte01(pixels[i + 2]) * a));
                pbuffer.put(SpriteShootout.packUByte01(SpriteShootout.unpackUByte01(pixels[i + 1]) * a));
                pbuffer.put(SpriteShootout.packUByte01(SpriteShootout.unpackUByte01(pixels[i + 0]) * a));
                pbuffer.put(pixels[i + 3]);
            }
        } else if (bands == 3) {
            for (int i = 0; i < w * h * 3; i += 3) {
                pbuffer.put(pixels[i + 2]);
                pbuffer.put(pixels[i + 1]);
                pbuffer.put(pixels[i + 0]);
            }
        } else {
            pbuffer.put(pixels, 0, size);
        }
        pbuffer.flip();
        return pbuffer;
    }

    private static float unpackUByte01(byte x) {
        return (float)(x & 0xFF) / 255.0f;
    }

    private static byte packUByte01(float x) {
        return (byte)(x * 255.0f);
    }

    private void updateBalls(int count) {
        System.out.println("NUMBER OF BALLS: " + count);
        this.renderer.updateBalls(this.ballCount);
    }

    private void run() {
        long startTime = System.currentTimeMillis() + 5000L;
        long fps = 0L;
        long time = Sys.getTime();
        int ticksPerUpdate = (int)(Sys.getTimerResolution() / 60L);
        this.renderer.render(false, true, 0);
        while (this.run) {
            Display.processMessages();
            this.handleInput();
            GL11.glClear(16384);
            long currTime = Sys.getTime();
            int delta = (int)(currTime - time);
            if (this.smooth || delta >= ticksPerUpdate) {
                this.renderer.render(this.render, this.animate, delta);
                time = currTime;
            } else {
                this.renderer.render(this.render, false, 0);
            }
            Display.update(false);
            if (startTime > System.currentTimeMillis()) {
                ++fps;
                continue;
            }
            long timeUsed = 5000L + (startTime - System.currentTimeMillis());
            startTime = System.currentTimeMillis() + 5000L;
            System.out.println("FPS: " + (double)Math.round((double)fps / ((double)timeUsed / 1000.0) * 10.0) / 10.0 + ", Balls: " + this.ballCount);
            System.out.println("\tAnimation: " + this.animateTime / fps / 1000L + "us");
            this.animateTime = 0L;
            fps = 0L;
        }
    }

    private void handleInput() {
        if (Display.isCloseRequested()) {
            this.run = false;
        }
        while (Keyboard.next()) {
            if (Keyboard.getEventKeyState()) continue;
            switch (Keyboard.getEventKey()) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    this.ballCount = 1 << Keyboard.getEventKey() - 2;
                    this.updateBalls(this.ballCount);
                    break;
                }
                case 74: 
                case 78: {
                    int mult = Keyboard.isKeyDown(42) || Keyboard.isKeyDown(54) ? 1000 : (Keyboard.isKeyDown(56) || Keyboard.isKeyDown(184) ? 100 : (Keyboard.isKeyDown(29) || Keyboard.isKeyDown(157) ? 10 : 1));
                    if (Keyboard.getEventKey() == 74) {
                        mult = -mult;
                    }
                    this.ballCount += mult * 100;
                    if (this.ballCount <= 0) {
                        this.ballCount = 1;
                    }
                    this.updateBalls(this.ballCount);
                    break;
                }
                case 1: {
                    this.run = false;
                    break;
                }
                case 30: {
                    this.animate = !this.animate;
                    System.out.println("Animation is now " + (this.animate ? "on" : "off") + ".");
                    break;
                }
                case 46: {
                    this.colorMask = !this.colorMask;
                    GL11.glColorMask(this.colorMask, this.colorMask, this.colorMask, false);
                    System.out.println("Color mask is now " + (this.colorMask ? "on" : "off") + ".");
                    if (this.colorMask) {
                        GL11.glEnable(3042);
                        GL11.glEnable(3008);
                        break;
                    }
                    GL11.glDisable(3042);
                    GL11.glDisable(3008);
                    break;
                }
                case 19: {
                    this.render = !this.render;
                    System.out.println("Rendering is now " + (this.render ? "on" : "off") + ".");
                    break;
                }
                case 31: {
                    this.smooth = !this.smooth;
                    System.out.println("Smooth animation is now " + (this.smooth ? "on" : "off") + ".");
                    break;
                }
                case 20: {
                    if (this.texID == this.texBigID) {
                        this.texID = this.texSmallID;
                        this.ballSize = 16;
                    } else {
                        this.texID = this.texBigID;
                        this.ballSize = 42;
                    }
                    this.renderer.updateBallSize();
                    GL11.glBindTexture(3553, this.texID);
                    System.out.println("Now using the " + (this.texID == this.texBigID ? "big" : "small") + " texture.");
                    break;
                }
                case 47: {
                    this.vsync = !this.vsync;
                    Display.setVSyncEnabled(this.vsync);
                    System.out.println("VSYNC is now " + (this.vsync ? "enabled" : "disabled") + ".");
                }
            }
        }
        while (Mouse.next()) {
        }
    }

    private void destroy() {
        Display.destroy();
    }

    private class SpriteRendererTF
    extends SpriteRenderer {
        private int progIDTF;
        private int ballSizeLoc;
        private int deltaLoc;
        private int[] tfVBO;
        private int currVBO;

        SpriteRendererTF() {
            this.tfVBO = new int[2];
            System.out.println("Shootout Implementation: TF GPU animation");
            int vshID = GL20.glCreateShader(35633);
            GL20.glShaderSource(vshID, "#version 130\nconst float WIDTH = 800;\nconst float HEIGHT = 600;\nuniform float ballSize;\nuniform float delta;\nvoid main(void) {\n     vec4 anim = gl_Vertex;\n     anim.xy = anim.xy + anim.zw * delta;\n     vec2 animC = clamp(anim.xy, vec2(ballSize), vec2(WIDTH - ballSize, HEIGHT - ballSize));\n     if ( anim.x != animC.x ) anim.z = -anim.z;\n     if ( anim.y != animC.y ) anim.w = -anim.w;\n     gl_Position = vec4(animC, anim.zw);\n}");
            GL20.glCompileShader(vshID);
            if (GL20.glGetShaderi(vshID, 35713) == 0) {
                System.out.println(GL20.glGetShaderInfoLog(vshID, GL20.glGetShaderi(vshID, 35716)));
                throw new RuntimeException("Failed to compile vertex shader.");
            }
            this.progIDTF = GL20.glCreateProgram();
            GL20.glAttachShader(this.progIDTF, vshID);
            GL30.glTransformFeedbackVaryings(this.progIDTF, new CharSequence[]{"gl_Position"}, 35981);
            GL20.glLinkProgram(this.progIDTF);
            if (GL20.glGetProgrami(this.progIDTF, 35714) == 0) {
                System.out.println(GL20.glGetProgramInfoLog(this.progIDTF, GL20.glGetProgrami(this.progIDTF, 35716)));
                throw new RuntimeException("Failed to link shader program.");
            }
            GL20.glUseProgram(this.progIDTF);
            this.ballSizeLoc = GL20.glGetUniformLocation(this.progIDTF, "ballSize");
            this.deltaLoc = GL20.glGetUniformLocation(this.progIDTF, "delta");
            GL20.glUniform1f(this.ballSizeLoc, (float)SpriteShootout.this.ballSize * 0.5f);
            this.vshID = GL20.glCreateShader(35633);
            GL20.glShaderSource(this.vshID, "void main(void) {\n     gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;\n}");
            GL20.glCompileShader(this.vshID);
            if (GL20.glGetShaderi(this.vshID, 35713) == 0) {
                System.out.println(GL20.glGetShaderInfoLog(this.vshID, GL20.glGetShaderi(this.vshID, 35716)));
                throw new RuntimeException("Failed to compile vertex shader.");
            }
            this.createProgram();
        }

        public void updateBallSize() {
            GL20.glUseProgram(this.progIDTF);
            GL20.glUniform1f(this.ballSizeLoc, (float)SpriteShootout.this.ballSize * 0.5f);
            GL20.glUseProgram(this.progID);
            super.updateBallSize();
        }

        public void updateBalls(int count) {
            FloatBuffer state;
            if (this.tfVBO[0] != 0) {
                state = BufferUtils.createFloatBuffer(this.transform.length);
                GL15.glGetBufferSubData(35982, 0L, state);
                state.get(this.transform);
            }
            super.updateBalls(count);
            if (this.tfVBO[0] != 0) {
                for (int i = 0; i < this.tfVBO.length; ++i) {
                    GL15.glDeleteBuffers(this.tfVBO[i]);
                }
            }
            state = BufferUtils.createFloatBuffer(count * 4);
            state.put(this.transform);
            state.flip();
            for (int i = 0; i < this.tfVBO.length; ++i) {
                this.tfVBO[i] = GL15.glGenBuffers();
                GL15.glBindBuffer(35982, this.tfVBO[i]);
                GL15.glBufferData(35982, state, 35044);
            }
            GL15.glBindBuffer(34962, this.tfVBO[0]);
            GL11.glVertexPointer(2, 5126, 16, 0L);
        }

        public void render(boolean render, boolean animate, int delta) {
            if (animate) {
                GL20.glUseProgram(this.progIDTF);
                GL20.glUniform1f(this.deltaLoc, delta);
                int vbo = this.currVBO;
                this.currVBO = 1 - this.currVBO;
                GL15.glBindBuffer(34962, this.tfVBO[vbo]);
                GL11.glVertexPointer(4, 5126, 0, 0L);
                GL11.glEnable(35977);
                if (GLContext.getCapabilities().OpenGL30) {
                    GL30.glBindBufferBase(35982, 0, this.tfVBO[1 - vbo]);
                    GL30.glBeginTransformFeedback(0);
                    GL11.glDrawArrays(0, 0, SpriteShootout.this.ballCount);
                    GL30.glEndTransformFeedback();
                } else {
                    EXTTransformFeedback.glBindBufferBaseEXT(35982, 0, this.tfVBO[1 - vbo]);
                    EXTTransformFeedback.glBeginTransformFeedbackEXT(0);
                    GL11.glDrawArrays(0, 0, SpriteShootout.this.ballCount);
                    EXTTransformFeedback.glEndTransformFeedbackEXT();
                }
                GL11.glDisable(35977);
                GL20.glUseProgram(this.progID);
                GL11.glVertexPointer(2, 5126, 16, 0L);
            }
            if (render) {
                GL11.glDrawArrays(0, 0, SpriteShootout.this.ballCount);
            }
        }
    }

    private class SpriteRendererMapped
    extends SpriteRendererBatched {
        private StreamVBO animVBO;

        SpriteRendererMapped() {
            System.out.println("Shootout Implementation: CPU animation & MapBufferRange");
        }

        public void updateBalls(int count) {
            super.updateBalls(count);
            if (this.animVBO != null) {
                this.animVBO.destroy();
            }
            this.animVBO = new StreamVBO(34962, SpriteShootout.this.ballCount * 8);
        }

        public void render(boolean render, boolean animate, int delta) {
            int batchSize = Math.min(SpriteShootout.this.ballCount, 10000);
            int ballIndex = 0;
            while (ballIndex < SpriteShootout.this.ballCount) {
                if (animate) {
                    ByteBuffer buffer = this.animVBO.map(batchSize * 8);
                    long t0 = System.nanoTime();
                    this.animate(this.transform, buffer.asFloatBuffer(), SpriteShootout.this.ballSize, ballIndex, batchSize, delta);
                    long t1 = System.nanoTime();
                    SpriteShootout.this.animateTime += t1 - t0;
                    this.animVBO.unmap();
                }
                if (render) {
                    GL11.glVertexPointer(2, 5126, 0, ballIndex * 8);
                    GL11.glDrawArrays(0, 0, batchSize);
                }
                batchSize = Math.min(SpriteShootout.this.ballCount - (ballIndex += batchSize), 10000);
            }
        }
    }

    private class SpriteRendererPlain
    extends SpriteRendererBatched {
        private final FloatBuffer geom;
        protected int[] animVBO;

        SpriteRendererPlain() {
            System.out.println("Shootout Implementation: CPU animation & BufferData");
            this.geom = BufferUtils.createFloatBuffer(80000);
        }

        public void updateBalls(int count) {
            int i;
            super.updateBalls(count);
            int batchCount = count / 10000 + (count % 10000 == 0 ? 0 : 1);
            if (this.animVBO != null && batchCount == this.animVBO.length) {
                return;
            }
            int[] newAnimVBO = new int[batchCount];
            if (this.animVBO != null) {
                System.arraycopy(this.animVBO, 0, newAnimVBO, 0, Math.min(this.animVBO.length, newAnimVBO.length));
                for (i = newAnimVBO.length; i < this.animVBO.length; ++i) {
                    GL15.glDeleteBuffers(this.animVBO[i]);
                }
            }
            int n = i = this.animVBO == null ? 0 : this.animVBO.length;
            while (i < newAnimVBO.length) {
                newAnimVBO[i] = GL15.glGenBuffers();
                GL15.glBindBuffer(34962, newAnimVBO[i]);
                ++i;
            }
            this.animVBO = newAnimVBO;
        }

        public void render(boolean render, boolean animate, int delta) {
            int batchSize = Math.min(SpriteShootout.this.ballCount, 10000);
            int ballIndex = 0;
            int vboIndex = 0;
            while (ballIndex < SpriteShootout.this.ballCount) {
                GL15.glBindBuffer(34962, this.animVBO[vboIndex++]);
                if (animate) {
                    this.animate(ballIndex, batchSize, delta);
                }
                if (render) {
                    GL11.glVertexPointer(2, 5126, 0, 0L);
                    GL11.glDrawArrays(0, 0, batchSize);
                }
                batchSize = Math.min(SpriteShootout.this.ballCount - (ballIndex += batchSize), 10000);
            }
        }

        private void animate(int ballIndex, int batchSize, int delta) {
            this.animate(this.transform, this.geom, SpriteShootout.this.ballSize, ballIndex, batchSize, delta);
            GL15.glBufferData(34962, this.geom.capacity() * 4, 35040);
            GL15.glBufferSubData(34962, 0L, this.geom);
        }
    }

    private abstract class SpriteRendererBatched
    extends SpriteRenderer {
        protected static final int BALLS_PER_BATCH = 10000;

        SpriteRendererBatched() {
            this.vshID = GL20.glCreateShader(35633);
            GL20.glShaderSource(this.vshID, "void main(void) {\n     gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;\n}");
            GL20.glCompileShader(this.vshID);
            if (GL20.glGetShaderi(this.vshID, 35713) == 0) {
                System.out.println(GL20.glGetShaderInfoLog(this.vshID, GL20.glGetShaderi(this.vshID, 35716)));
                throw new RuntimeException("Failed to compile vertex shader.");
            }
            this.createProgram();
        }
    }

    private abstract class SpriteRenderer {
        protected float[] transform = new float[0];
        protected int vshID;
        protected int progID;

        private SpriteRenderer() {
        }

        protected void createProgram() {
            int fshID = GL20.glCreateShader(35632);
            GL20.glShaderSource(fshID, "uniform sampler2D COLOR_MAP;\nvoid main(void) {\n     gl_FragColor = texture2D(COLOR_MAP, gl_PointCoord);\n}");
            GL20.glCompileShader(fshID);
            if (GL20.glGetShaderi(fshID, 35713) == 0) {
                System.out.println(GL20.glGetShaderInfoLog(fshID, GL20.glGetShaderi(fshID, 35716)));
                throw new RuntimeException("Failed to compile fragment shader.");
            }
            this.progID = GL20.glCreateProgram();
            GL20.glAttachShader(this.progID, this.vshID);
            GL20.glAttachShader(this.progID, fshID);
            GL20.glLinkProgram(this.progID);
            if (GL20.glGetProgrami(this.progID, 35714) == 0) {
                System.out.println(GL20.glGetProgramInfoLog(this.progID, GL20.glGetProgrami(this.progID, 35716)));
                throw new RuntimeException("Failed to link shader program.");
            }
            GL20.glUseProgram(this.progID);
            GL20.glUniform1i(GL20.glGetUniformLocation(this.progID, "COLOR_MAP"), 0);
            this.updateBallSize();
        }

        public void updateBallSize() {
            GL11.glPointSize(SpriteShootout.this.ballSize);
        }

        public void updateBalls(int count) {
            Random random = new Random();
            float[] newTransform = new float[count * 4];
            System.arraycopy(this.transform, 0, newTransform, 0, Math.min(this.transform.length, newTransform.length));
            if (newTransform.length > this.transform.length) {
                int i = this.transform.length;
                while (i < newTransform.length) {
                    newTransform[i++] = (int)(random.nextFloat() * (float)(800 - SpriteShootout.this.ballSize) + (float)SpriteShootout.this.ballSize * 0.5f);
                    newTransform[i++] = (int)(random.nextFloat() * (float)(600 - SpriteShootout.this.ballSize) + (float)SpriteShootout.this.ballSize * 0.5f);
                    newTransform[i++] = random.nextFloat() * 0.4f - 0.2f;
                    newTransform[i++] = random.nextFloat() * 0.4f - 0.2f;
                }
            }
            this.transform = newTransform;
        }

        protected void animate(float[] sprites, FloatBuffer spritesRender, int ballSize, int ballIndex, int batchSize, int delta) {
            float ballRadius = (float)ballSize * 0.5f;
            float boundW = 800.0f - ballRadius;
            float boundH = 600.0f - ballRadius;
            int len = (ballIndex + batchSize) * 4;
            for (int b = ballIndex * 4; b < len; b += 4) {
                float x = sprites[b + 0];
                float dx = sprites[b + 2];
                if ((x += dx * (float)delta) < ballRadius) {
                    x = ballRadius;
                    sprites[b + 2] = -dx;
                } else if (x > boundW) {
                    x = boundW;
                    sprites[b + 2] = -dx;
                }
                sprites[b + 0] = x;
                float y = sprites[b + 1];
                float dy = sprites[b + 3];
                y += dy * (float)delta;
                if (y < ballRadius) {
                    y = ballRadius;
                    sprites[b + 3] = -dy;
                } else if (y > boundH) {
                    y = boundH;
                    sprites[b + 3] = -dy;
                }
                sprites[b + 1] = y;
                spritesRender.put(x).put(y);
            }
            spritesRender.clear();
        }

        protected abstract void render(boolean var1, boolean var2, int var3);
    }
}

