/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.opengl.awt;

import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.AWTGLCanvas;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

public class AWTTest
extends Frame {
    private AWTGLCanvas canvas0;
    private AWTGLCanvas canvas1;
    private volatile float angle;

    public AWTTest() throws LWJGLException {
        this.setTitle("LWJGL AWT Canvas Test");
        this.setSize(640, 320);
        this.setLayout(new GridLayout(1, 2));
        this.canvas0 = new AWTGLCanvas(){
            int current_height;
            int current_width;

            public void paintGL() {
                try {
                    if (this.getWidth() != this.current_width || this.getHeight() != this.current_height) {
                        this.current_width = this.getWidth();
                        this.current_height = this.getHeight();
                        GL11.glViewport(0, 0, this.current_width, this.current_height);
                    }
                    GL11.glViewport(0, 0, this.getWidth(), this.getHeight());
                    GL11.glClearColor(1.0f, 0.0f, 0.0f, 1.0f);
                    GL11.glClear(16384);
                    GL11.glMatrixMode(5889);
                    GL11.glLoadIdentity();
                    GLU.gluOrtho2D(0.0f, this.getWidth(), 0.0f, this.getHeight());
                    GL11.glMatrixMode(5888);
                    GL11.glPushMatrix();
                    GL11.glColor3f(1.0f, 1.0f, 0.0f);
                    GL11.glTranslatef((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f, 0.0f);
                    GL11.glRotatef(AWTTest.this.angle, 0.0f, 0.0f, 1.0f);
                    GL11.glRectf(-50.0f, -50.0f, 50.0f, 50.0f);
                    GL11.glPopMatrix();
                    this.swapBuffers();
                    this.repaint();
                }
                catch (LWJGLException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this.add(this.canvas0);
        this.canvas1 = new AWTGLCanvas(){
            int current_height;
            int current_width;

            public void paintGL() {
                try {
                    AWTTest.this.angle = AWTTest.this.angle + 1.0f;
                    if (this.getWidth() != this.current_width || this.getHeight() != this.current_height) {
                        this.current_width = this.getWidth();
                        this.current_height = this.getHeight();
                        GL11.glViewport(0, 0, this.current_width, this.current_height);
                    }
                    GL11.glViewport(0, 0, this.getWidth(), this.getHeight());
                    GL11.glClearColor(0.0f, 1.0f, 0.0f, 1.0f);
                    GL11.glClear(16384);
                    GL11.glMatrixMode(5889);
                    GL11.glLoadIdentity();
                    GLU.gluOrtho2D(0.0f, this.getWidth(), 0.0f, this.getHeight());
                    GL11.glMatrixMode(5888);
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f, 0.0f);
                    GL11.glRotatef(2.0f * AWTTest.this.angle, 0.0f, 0.0f, -1.0f);
                    GL11.glRectf(-50.0f, -50.0f, 50.0f, 50.0f);
                    GL11.glPopMatrix();
                    this.swapBuffers();
                    this.repaint();
                }
                catch (LWJGLException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this.add(this.canvas1);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                AWTTest.this.dispose();
                System.exit(0);
            }
        });
        this.setResizable(true);
        this.setVisible(true);
    }

    public static void main(String[] args) throws LWJGLException {
        new AWTTest();
    }
}

