/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.openal;

import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL10;
import org.lwjgl.test.openal.BasicTest;
import org.lwjgl.util.WaveData;

public class StressTest
extends BasicTest {
    private IntBuffer sources;
    private IntBuffer buffers;

    protected void execute(String[] args) {
        this.createSources();
        this.createBuffers();
        try {
            this.loadSamples();
            this.runTest();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.alExit();
    }

    private void createSources() {
        this.sources = BufferUtils.createIntBuffer(4);
        this.sources.position(0).limit(4);
        AL10.alGenSources(this.sources);
        if (AL10.alGetError() != 0) {
            System.out.println("Unable to create 4 sources");
            this.alExit();
        }
    }

    private void createBuffers() {
        this.buffers = BufferUtils.createIntBuffer(10);
        this.buffers.position(0).limit(10);
        AL10.alGenBuffers(this.buffers);
        if (AL10.alGetError() != 0) {
            System.out.println("Unable to create 10 buffers");
            this.sources.position(0).limit(4);
            AL10.alDeleteSources(this.sources);
            this.alExit();
        }
    }

    private void loadSamples() throws Exception {
        AL10.alGetError();
        WaveData data = WaveData.create("ding.wav");
        for (int i = 1; i <= 10; ++i) {
            AL10.alBufferData(this.buffers.get(i - 1), data.format, data.data, data.samplerate);
            if (AL10.alGetError() == 0) continue;
            System.out.println("Failed to load " + i + ".wav into buffer");
            this.sources.position(0).limit(4);
            AL10.alDeleteSources(this.sources);
            this.buffers.position(0).limit(10);
            AL10.alDeleteBuffers(this.buffers);
            this.alExit();
        }
        data.dispose();
    }

    public void runTest() {
        int startSlot;
        int iterations = 0;
        int nextSlot = startSlot = 1;
        long startTime = System.currentTimeMillis();
        AL10.alSourcei(this.sources.get(0), 4103, 1);
        AL10.alSourcei(this.sources.get(0), 4105, this.buffers.get(0));
        AL10.alSourcePlay(this.sources.get(0));
        while (System.currentTimeMillis() - startTime < 2000L) {
            int randomBuffer = this.getRandomBuffer();
            System.out.println("random:" + randomBuffer);
            AL10.alSourceStop(this.sources.get(nextSlot));
            if (AL10.alGetError() != 0) {
                System.out.println("Error stopping source.");
            }
            System.out.println("Stopped source: " + nextSlot);
            AL10.alSourcei(this.sources.get(nextSlot), 4105, this.buffers.get(randomBuffer));
            if (AL10.alGetError() != 0) {
                System.out.println("Error linking buffer and source.");
            }
            System.out.println("linked source " + nextSlot + " with buffer " + randomBuffer);
            System.out.println("playing source " + nextSlot);
            AL10.alSourcePlay(this.sources.get(nextSlot++));
            if (nextSlot == 4) {
                nextSlot = startSlot;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (++iterations % 10 != 0) continue;
            System.out.println("========================");
            System.out.println("MaxMemory: " + Runtime.getRuntime().maxMemory() / 1024L);
            System.out.println("FreeMemory: " + Runtime.getRuntime().freeMemory() / 1024L);
            System.out.println("TotalMemory: " + Runtime.getRuntime().totalMemory() / 1024L);
            System.out.println("========================");
        }
        for (int i = 0; i < 4; ++i) {
            AL10.alSourceStop(this.sources.get(i));
            System.out.println("Stopping source " + (i + 1));
        }
        try {
            System.out.println("Test completed");
            System.out.println("========================");
            System.out.println("MaxMemory: " + Runtime.getRuntime().maxMemory() / 1024L);
            System.out.println("FreeMemory: " + Runtime.getRuntime().freeMemory() / 1024L);
            System.out.println("TotalMemory: " + Runtime.getRuntime().totalMemory() / 1024L);
            System.out.println("========================");
            System.out.println("Push any key to exit...");
            System.in.read();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sources.position(0).limit(4);
        AL10.alDeleteSources(this.sources);
        this.buffers.position(0).limit(10);
        AL10.alDeleteBuffers(this.buffers);
    }

    private int getRandomBuffer() {
        return (int)(Math.random() * 10.0);
    }

    public static void main(String[] args) {
        StressTest stressTest = new StressTest();
        stressTest.execute(args);
        System.exit(0);
    }
}

