/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.openal;

import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.openal.AL10;
import org.lwjgl.opengl.Display;
import org.lwjgl.test.openal.BasicTest;
import org.lwjgl.util.WaveData;
import org.lwjgl.util.vector.Vector3f;

public class MovingSoundTest
extends BasicTest {
    public static float MOVEMENT = 50.0f;

    protected void execute(String[] args) {
        if (args.length < 1) {
            System.out.println("no argument supplied, assuming Footsteps.wav");
            args = new String[]{"Footsteps.wav"};
        }
        try {
            this.setDisplayMode();
            Display.create();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Vector3f sourcePosition = new Vector3f();
        Vector3f listenerPosition = new Vector3f();
        try {
            Keyboard.create();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.exit(-1);
        }
        IntBuffer buffers = BufferUtils.createIntBuffer(1);
        IntBuffer sources = BufferUtils.createIntBuffer(1);
        buffers.position(0).limit(1);
        AL10.alGenBuffers(buffers);
        int lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
        sources.position(0).limit(1);
        AL10.alGenSources(sources);
        lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
        WaveData wavefile = WaveData.create(args[0]);
        AL10.alBufferData(buffers.get(0), wavefile.format, wavefile.data, wavefile.samplerate);
        lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
        wavefile.dispose();
        AL10.alSourcei(sources.get(0), 4105, buffers.get(0));
        lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
        AL10.alSourcef(sources.get(0), 4128, 1024.0f);
        AL10.alSourcef(sources.get(0), 4129, 0.5f);
        AL10.alSourcei(sources.get(0), 4103, 1);
        lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
        AL10.alSourcePlay(sources.get(0));
        lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
        System.out.println("Move source with arrow keys\nMove listener with right shift and arrowkeys\nExit with ESC");
        while (!Keyboard.isKeyDown(1)) {
            Display.update();
            Keyboard.poll();
            if (Keyboard.isKeyDown(203)) {
                if (Keyboard.isKeyDown(54)) {
                    listenerPosition.x -= MOVEMENT;
                    AL10.alListener3f(4100, listenerPosition.x, listenerPosition.y, listenerPosition.z);
                    System.out.println("listenerx: " + listenerPosition.x);
                } else {
                    sourcePosition.x -= MOVEMENT;
                    AL10.alSource3f(sources.get(0), 4100, sourcePosition.x, sourcePosition.y, sourcePosition.z);
                    System.out.println("sourcex: " + sourcePosition.x);
                }
            }
            if (Keyboard.isKeyDown(205)) {
                if (Keyboard.isKeyDown(54)) {
                    listenerPosition.x += MOVEMENT;
                    AL10.alListener3f(4100, listenerPosition.x, listenerPosition.y, listenerPosition.z);
                    System.out.println("listenerx: " + listenerPosition.x);
                } else {
                    sourcePosition.x += MOVEMENT;
                    AL10.alSource3f(sources.get(0), 4100, sourcePosition.x, sourcePosition.y, sourcePosition.z);
                    System.out.println("sourcex: " + sourcePosition.x);
                }
            }
            if (Display.isCloseRequested()) break;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        AL10.alSourceStop(sources.get(0));
        lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
        sources.position(0).limit(1);
        AL10.alDeleteSources(sources);
        lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
        buffers.position(0).limit(1);
        AL10.alDeleteBuffers(buffers);
        lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
        this.alExit();
    }

    public static void main(String[] args) {
        MovingSoundTest movingSoundTest = new MovingSoundTest();
        movingSoundTest.execute(args);
        System.exit(0);
    }
}

