/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.mapped;

import java.io.File;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import org.lwjgl.MemoryUtil;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.Display;
import org.lwjgl.test.mapped.MappedFloat;
import org.lwjgl.test.mapped.MappedSomething;
import org.lwjgl.util.mapped.CacheLinePad;
import org.lwjgl.util.mapped.CacheUtil;
import org.lwjgl.util.mapped.MappedField;
import org.lwjgl.util.mapped.MappedObject;
import org.lwjgl.util.mapped.MappedType;
import org.lwjgl.util.mapped.Pointer;

public class MappedObjectTests4 {
    public static void testLWJGL() throws Exception {
        System.out.println(new File(System.getProperty("java.library.path")).getCanonicalPath());
        Display.create();
    }

    public static void testLocalView() {
        MappedFloat mapped1 = (MappedFloat)MappedFloat.malloc(5);
        MappedFloat mapped2 = (MappedFloat)MappedFloat.malloc(5);
        MappedObjectTests4.testLocalView(mapped1);
        MappedObjectTests4.testLocalView(mapped1, mapped2);
        MappedSomething some = (MappedSomething)MappedSomething.malloc(5);
        MappedObjectTests4.testLocalView(some);
    }

    private static void testLocalView(MappedFloat mapped1) {
        MappedFloat[] array = (MappedFloat[])mapped1.asArray();
        assert (array.length == 5);
        int l = 10 * array.length;
        for (int localView1 = 0; localView1 < 5; ++localView1) {
            array[localView1].value = localView1 * 5;
            array[localView1].value *= 2.0f;
        }
        System.out.println();
        float x = 0.0f;
        for (int localView1 = 0; localView1 < 5; ++localView1) {
            System.out.println("[" + localView1 + "] =>" + array[localView1].value);
            x += array[localView1].value;
        }
        System.out.println("x = " + x);
    }

    private static void testLocalView(MappedFloat mo1, MappedFloat mo2) {
        int v2;
        MappedFloat[] array1 = (MappedFloat[])mo1.asArray();
        for (int v1 = 0; v1 < 5; ++v1) {
            array1[v1].value = (float)Math.random();
            array1[v1].value *= 2.0f;
        }
        MappedFloat[] array2 = (MappedFloat[])mo2.asArray();
        for (v2 = 0; v2 < 5; ++v2) {
            array2[v2].value = (float)Math.random();
            array2[v2].value *= 2.0f;
        }
        System.out.println();
        for (int v1 = 0; v1 < 5; ++v1) {
            System.out.println("[" + v1 + "] =>" + array1[v1].value);
        }
        for (v2 = 0; v2 < 5; ++v2) {
            System.out.println("[" + v2 + "] =>" + array2[v2].value);
        }
    }

    private static void testLocalView(MappedSomething some) {
        MappedSomething[] array = (MappedSomething[])some.asArray();
        assert (array.length == 5);
        long baseAddress = MemoryUtil.getAddress(some.backingByteBuffer());
        for (int i = 0; i < array.length; ++i) {
            ByteBuffer data = array[i].data;
            assert (data.capacity() == 60);
            assert (MemoryUtil.getAddress(data) == baseAddress + (long)(i * MappedSomething.SIZEOF) + 4L);
        }
    }

    public static void testPointer() {
        int i;
        MappedPointer data = (MappedPointer)MappedPointer.malloc(100);
        assert (data.backingByteBuffer().capacity() == 100 * (8 + PointerBuffer.getPointerSize()));
        for (i = 0; i < 100; ++i) {
            data.view = i;
            data.foo = i;
            data.pointer = i * 1000;
            data.bar = i * 2;
        }
        for (i = 0; i < 100; ++i) {
            data.view = i;
            assert (data.foo == i);
            assert (data.pointer == (long)(i * 1000));
            assert (data.bar == i * 2);
        }
    }

    public static void testCacheLineAlignment() {
        int i;
        MappedCacheLinePadded data = (MappedCacheLinePadded)MappedCacheLinePadded.malloc(10);
        assert (data.backingByteBuffer().capacity() == 10 * CacheUtil.getCacheLineSize());
        assert (MemoryUtil.getAddress(data.backingByteBuffer()) % (long)CacheUtil.getCacheLineSize() == 0L);
        for (i = 0; i < 10; ++i) {
            data.view = i;
            data.foo = i;
            data.bar = i * 2;
        }
        for (i = 0; i < 10; ++i) {
            data.view = i;
            assert (data.foo == i);
            assert (data.bar == i * 2);
        }
    }

    public static void testCacheLinePadding() {
        MappedFieldCacheLinePadded data = (MappedFieldCacheLinePadded)MappedFieldCacheLinePadded.map(CacheUtil.createByteBuffer(10 * MappedFieldCacheLinePadded.SIZEOF));
        int sizeof = CacheUtil.getCacheLineSize() + 8 + (CacheUtil.getCacheLineSize() - 8) + CacheUtil.getCacheLineSize() + 4 + (CacheUtil.getCacheLineSize() - 4) + 12 + 4;
        assert (MappedFieldCacheLinePadded.SIZEOF == sizeof);
        assert (data.backingByteBuffer().capacity() == sizeof * 10);
        int i = 0;
        while (i < 10) {
            data.view = i;
            data.longFoo = (long)i * 1000000000L;
            data.longBar = (long)i * 2000000000L;
            data.intFoo = i * 1000;
            data.intBar = i * 2000;
            data.foo = i++;
        }
        for (i = 0; i < 10; ++i) {
            data.view = i;
            assert (data.longFoo == (long)i * 1000000000L);
            assert (data.longBar == (long)i * 2000000000L);
            assert (data.intFoo == i * 1000);
            assert (data.intBar == i * 2000);
            assert (data.foo == i);
        }
    }

    public static void testCacheLinePaddingPOJO() {
        Field[] fields = new POJOFieldCacheLinePadded().getClass().getDeclaredFields();
        assert (fields.length == 107);
    }

    public static class POJOFieldCacheLinePadded {
        @CacheLinePad
        long longBar;
        long longFoo;
        int intFoo;
        @CacheLinePad(before=true)
        int intBar;
        int foo;
        @CacheLinePad
        boolean bool;
        int bar;
    }

    public static class MappedFieldCacheLinePadded
    extends MappedObject {
        @CacheLinePad
        long longBar;
        long longFoo;
        int intFoo;
        @CacheLinePad(before=true)
        int intBar;
        int foo;
        @CacheLinePad(before=true, after=false)
        @MappedField(byteLength=12L)
        ByteBuffer buffer;
        int bar;
    }

    @MappedType(cacheLinePadding=true)
    public static class MappedCacheLinePadded
    extends MappedObject {
        int foo;
        int bar;
    }

    public static class MappedPointer
    extends MappedObject {
        int foo;
        @Pointer
        long pointer;
        int bar;
    }
}

