/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.mapped;

import java.nio.ByteBuffer;
import org.lwjgl.MemoryUtil;
import org.lwjgl.test.mapped.MappedFloat;
import org.lwjgl.util.mapped.MappedHelper;

public class MappedObjectTests1 {
    static void testViewField() {
        Test test = new Test();
        test.value = 13;
        ++test.value;
        ++test.value;
        System.out.println(test);
        ByteBuffer bb = ByteBuffer.allocateDirect(200);
        MappedFloat vecs = (MappedFloat)MappedFloat.map(bb);
        MappedFloat vecs32 = (MappedFloat)MappedFloat.malloc(1234);
        assert (vecs32.getSizeof() == MappedFloat.SIZEOF);
        assert (vecs32.getSizeof() * 1234 == vecs32.backingByteBuffer().capacity());
        assert (MappedFloat.SIZEOF * 1234 == vecs32.backingByteBuffer().capacity());
        assert (vecs32.capacity() == vecs32.backingByteBuffer().capacity() / MappedFloat.SIZEOF);
        ByteBuffer buf = ByteBuffer.allocateDirect(200);
        buf.position(10 * MappedFloat.SIZEOF);
        MappedFloat vecs2 = (MappedFloat)MappedFloat.map(buf);
        assert (vecs2.capacity() == vecs2.backingByteBuffer().capacity() / MappedFloat.SIZEOF - 10);
        assert (vecs.value == 0.0f);
        vecs.value = 1.1f;
        assert (vecs.value == 1.1f);
        assert (vecs.view == 0);
        vecs.view = 1;
        assert (vecs.view == 1);
        assert (vecs.value != 1.1f);
        vecs.view = 0;
        assert (vecs.view == 0);
        ++vecs.view;
        assert (vecs.view == 1);
        assert (vecs.value != 1.1f);
        vecs.view = 0;
        assert (vecs.view == 0);
        vecs.next();
        assert (vecs.view == 1);
        assert (vecs.value != 1.1f);
        vecs.view = 0;
        assert (vecs.view == 0);
        try {
            vecs.view = 49;
            assert (vecs.view == 49);
            vecs.view = 0;
            vecs.view = 50;
            System.out.println("org.lwjgl.util.mapped.Checks is false or there is a bug in bounds checking.");
            vecs.view = 0;
        }
        catch (IndexOutOfBoundsException vecs32) {
            // empty catch block
        }
        assert (vecs.view == 0);
        try {
            vecs.view = 10;
            MappedFloat vecs22 = (MappedFloat)vecs.slice();
            vecs.view = 0;
            vecs22.view = 39;
            assert (vecs22.view == 39);
            vecs22.view = 40;
            System.out.println("org.lwjgl.util.mapped.Checks is false or there is a bug in bounds checking.");
        }
        catch (IndexOutOfBoundsException vecs22) {
            // empty catch block
        }
        try {
            ByteBuffer posTest = ByteBuffer.allocateDirect(200);
            posTest.position(10 * MappedFloat.SIZEOF);
            MappedFloat vecs23 = (MappedFloat)MappedFloat.map(posTest);
            vecs23.view = 39;
            assert (vecs23.view == 39);
            vecs23.view = 40;
            System.out.println("org.lwjgl.util.mapped.Checks is false or there is a bug in bounds checking.");
        }
        catch (IndexOutOfBoundsException posTest) {
            // empty catch block
        }
        long addr1 = MemoryUtil.getAddress(bb);
        ByteBuffer bb2 = MappedHelper.newBuffer(addr1, bb.capacity());
        long addr2 = MemoryUtil.getAddress(bb);
        System.out.println(bb);
        System.out.println(bb2);
        System.out.println(addr1);
        System.out.println(addr2);
        vecs.value = 13.37f;
        MappedFloat dec2 = (MappedFloat)vecs.dup();
        dec2.view = 1;
        System.out.println(vecs);
        System.out.println(dec2);
        vecs.copyTo(dec2);
        System.out.println(vecs);
        System.out.println(dec2);
        assert (dec2.value == 13.37f);
        vecs.value = 73.31f;
        vecs.copyRange(dec2, 1);
        assert (dec2.value == 73.31f);
    }

    static class Test {
        int value;

        Test() {
        }
    }
}

