/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.LWJGLException;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengles.APIUtil;

public final class QCOMDriverControl {
    private QCOMDriverControl() {
    }

    static native void initNativeStubs() throws LWJGLException;

    public static void glGetDriverControlsQCOM(IntBuffer num, IntBuffer driverControls) {
        if (num != null) {
            BufferChecks.checkBuffer(num, 1);
        }
        if (driverControls != null) {
            BufferChecks.checkDirect(driverControls);
        }
        QCOMDriverControl.nglGetDriverControlsQCOM(MemoryUtil.getAddressSafe(num), driverControls == null ? 0 : driverControls.remaining(), MemoryUtil.getAddressSafe(driverControls));
    }

    static native void nglGetDriverControlsQCOM(long var0, int var2, long var3);

    public static void glGetDriverControlStringQCOM(int driverControl, IntBuffer length, ByteBuffer driverControlString) {
        if (length != null) {
            BufferChecks.checkBuffer(length, 1);
        }
        if (driverControlString != null) {
            BufferChecks.checkDirect(driverControlString);
        }
        QCOMDriverControl.nglGetDriverControlStringQCOM(driverControl, driverControlString == null ? 0 : driverControlString.remaining(), MemoryUtil.getAddressSafe(length), MemoryUtil.getAddressSafe(driverControlString));
    }

    static native void nglGetDriverControlStringQCOM(int var0, int var1, long var2, long var4);

    public static String glGetDriverControlStringQCOM(int driverControl, int bufSize) {
        IntBuffer driverControlString_length = APIUtil.getLengths();
        ByteBuffer driverControlString = APIUtil.getBufferByte(bufSize);
        QCOMDriverControl.nglGetDriverControlStringQCOM(driverControl, bufSize, MemoryUtil.getAddress0(driverControlString_length), MemoryUtil.getAddress(driverControlString));
        driverControlString.limit(driverControlString_length.get(0));
        return APIUtil.getString(driverControlString);
    }

    public static void glEnableDriverControlQCOM(int driverControl) {
        QCOMDriverControl.nglEnableDriverControlQCOM(driverControl);
    }

    static native void nglEnableDriverControlQCOM(int var0);

    public static void glDisableDriverControlQCOM(int driverControl) {
        QCOMDriverControl.nglDisableDriverControlQCOM(driverControl);
    }

    static native void nglDisableDriverControlQCOM(int var0);
}

