/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.PixelFormatLWJGL;
import org.lwjgl.opengles.EGLConfig;
import org.lwjgl.opengles.EGLDisplay;
import org.lwjgl.opengles.EGLSurface;

public final class PixelFormat
implements PixelFormatLWJGL {
    private final Map<Attrib, Integer> config = new HashMap<Attrib, Integer>(16);

    public PixelFormat() {
        this(8, 16, 0);
    }

    public PixelFormat(int alphaSize, int depthSize, int stencilSize) {
        this(alphaSize, depthSize, stencilSize, 0);
    }

    public PixelFormat(int alphaSize, int depthSize, int stencilSize, int samples) {
        this(8, alphaSize, 0, depthSize, stencilSize, samples);
    }

    public PixelFormat(int rgbSize, int alphaSize, int luminanceSize, int depthSize, int stencilSize, int samples) {
        if (rgbSize < 0) {
            throw new IllegalArgumentException("Invalid RGB size specified: " + rgbSize);
        }
        if (alphaSize < 0) {
            throw new IllegalArgumentException("Invalid EGL_ALPHA_SIZE specified: " + alphaSize);
        }
        if (luminanceSize < 0 || 0 < luminanceSize && 0 < rgbSize) {
            throw new IllegalArgumentException("Invalid EGL_LUMINANCE_SIZE specified: " + luminanceSize);
        }
        if (depthSize < 0) {
            throw new IllegalArgumentException("Invalid EGL_DEPTH_SIZE specified: " + depthSize);
        }
        if (stencilSize < 0) {
            throw new IllegalArgumentException("Invalid EGL_STENCIL_SIZE specified: " + stencilSize);
        }
        if (samples < 0) {
            throw new IllegalArgumentException("Invalid EGL_SAMPLES specified: " + samples);
        }
        if (0 < rgbSize) {
            this.setAttrib(Attrib.RED_SIZE, rgbSize);
            this.setAttrib(Attrib.GREEN_SIZE, rgbSize);
            this.setAttrib(Attrib.BLUE_SIZE, rgbSize);
        }
        this.setAttrib(Attrib.ALPHA_SIZE, alphaSize);
        this.setAttrib(Attrib.LUMINANCE_SIZE, luminanceSize);
        this.setAttrib(Attrib.DEPTH_SIZE, depthSize);
        this.setAttrib(Attrib.STENCIL_SIZE, stencilSize);
        this.setAttrib(Attrib.SAMPLES, samples);
        this.setAttrib(Attrib.SAMPLE_BUFFERS, samples == 0 ? 0 : 1);
    }

    private PixelFormat(PixelFormat pf) {
        this.config.clear();
        this.config.putAll(pf.config);
    }

    private void setAttrib(Attrib attrib, int value) {
        if (attrib.defaultValue == value) {
            this.config.remove((Object)attrib);
        } else {
            this.config.put(attrib, value);
        }
    }

    public IntBuffer getAttribBuffer(EGLDisplay display, int surfaceType, int[] lwjglAttribs) {
        HashSet<Attrib> keys = new HashSet<Attrib>(this.config.keySet());
        if (keys.contains((Object)Attrib.MULTISAMPLE_RESOLVE)) {
            if (display.getMajorVersion() == 1 && display.getMinorVersion() < 4) {
                keys.remove((Object)Attrib.MULTISAMPLE_RESOLVE);
            } else if (this.getAttrib(Attrib.MULTISAMPLE_RESOLVE) == 12443) {
                surfaceType |= 0x200;
            }
        }
        if (keys.contains((Object)Attrib.SWAP_BEHAVIOR)) {
            if (display.getMajorVersion() == 1 && display.getMinorVersion() < 4) {
                keys.remove((Object)Attrib.SWAP_BEHAVIOR);
            } else if (this.getAttrib(Attrib.SWAP_BEHAVIOR) == 12436) {
                surfaceType |= 0x400;
            }
        }
        if (keys.contains((Object)Attrib.COVERAGE_BUFFERS_NV) && !display.isExtensionSupported("EGL_NV_coverage_sample")) {
            keys.remove((Object)Attrib.COVERAGE_BUFFERS_NV);
            keys.remove((Object)Attrib.COVERAGE_SAMPLES_NV);
        }
        if (keys.contains((Object)Attrib.DEPTH_ENCODING_NONLINEAR_NV) && !display.isExtensionSupported("EGL_NV_depth_nonlinear")) {
            keys.remove((Object)Attrib.DEPTH_ENCODING_NONLINEAR_NV);
        }
        IntBuffer attribs = BufferUtils.createIntBuffer(2 + lwjglAttribs.length + keys.size() * 2 + 1);
        attribs.put(12339).put(surfaceType);
        attribs.put(lwjglAttribs);
        for (Attrib key : keys) {
            if (key.isSurfaceAttrib()) continue;
            attribs.put(key.eglAttrib).put(this.config.get((Object)key));
        }
        attribs.put(12344);
        attribs.flip();
        return attribs;
    }

    private boolean matches(Attrib attrib, EGLConfig config) throws LWJGLException {
        return this.getAttrib(attrib) == config.getAttribute(attrib.getEGLAttrib());
    }

    private boolean matchesNonZero(Attrib attrib, EGLConfig config) throws LWJGLException {
        int cfgValue;
        int reqValue = this.getAttrib(attrib);
        return reqValue == (cfgValue = config.getAttribute(attrib.getEGLAttrib())) || reqValue == 1 && cfgValue > 0;
    }

    public EGLConfig getBestMatch(EGLConfig[] configs) throws LWJGLException {
        if (configs == null || configs.length == 0) {
            throw new IllegalArgumentException("No EGLConfigs specified.");
        }
        if (configs.length == 1) {
            return configs[0];
        }
        for (EGLConfig config : configs) {
            int luminance;
            if (config == null || !this.matches(Attrib.ALPHA_SIZE, config) || !this.matchesNonZero(Attrib.DEPTH_SIZE, config) || !this.matchesNonZero(Attrib.STENCIL_SIZE, config) || 0 < (luminance = this.getAttrib(Attrib.LUMINANCE_SIZE)) && !this.matches(Attrib.LUMINANCE_SIZE, config) || luminance == 0 && (!this.matches(Attrib.RED_SIZE, config) || !this.matches(Attrib.GREEN_SIZE, config) || !this.matches(Attrib.BLUE_SIZE, config)) || !this.matches(Attrib.SAMPLE_BUFFERS, config) || !this.matches(Attrib.SAMPLES, config)) continue;
            return config;
        }
        LWJGLUtil.log("Could not find an exact EGLConfig match for the PixelFormat requested, using first returned.");
        return configs[0];
    }

    public void setSurfaceAttribs(EGLSurface surface) throws LWJGLException {
        this.setSurfaceAttrib(surface, Attrib.SWAP_BEHAVIOR);
        this.setSurfaceAttrib(surface, Attrib.MULTISAMPLE_RESOLVE);
    }

    private void setSurfaceAttrib(EGLSurface surface, Attrib attrib) throws LWJGLException {
        int value = this.getAttrib(attrib);
        if (value != attrib.getDefaultValue()) {
            surface.setAttribute(attrib.getEGLAttrib(), value);
        }
    }

    public int getAttrib(Attrib attrib) {
        Integer value = this.config.get((Object)attrib);
        if (value == null) {
            return attrib.defaultValue;
        }
        return value;
    }

    public PixelFormat withRGBSize(int rgb) {
        return this.withRGBSize(rgb, rgb, rgb);
    }

    public PixelFormat withRGBSize(int r, int g, int b) {
        if (r < 0 || g < 0 || b < 0) {
            throw new IllegalArgumentException("Invalid RGB sizes specified: " + r + ", " + g + ", " + b);
        }
        PixelFormat pf = new PixelFormat(this);
        pf.setAttrib(Attrib.RED_SIZE, r);
        pf.setAttrib(Attrib.GREEN_SIZE, g);
        pf.setAttrib(Attrib.BLUE_SIZE, b);
        if (0 < r || 0 < g || 0 < b) {
            pf.setAttrib(Attrib.LUMINANCE_SIZE, 0);
        }
        return pf;
    }

    public PixelFormat withAlphaSize(int alphaSize) {
        if (alphaSize < 0) {
            throw new IllegalArgumentException("Invalid EGL_ALPHA_SIZE specified: " + alphaSize);
        }
        PixelFormat pf = new PixelFormat(this);
        pf.setAttrib(Attrib.ALPHA_SIZE, alphaSize);
        return pf;
    }

    public PixelFormat withLuminanceSize(int luminanceSize) {
        if (luminanceSize < 0) {
            throw new IllegalArgumentException("Invalid EGL_LUMINANCE_SIZE specified: " + luminanceSize);
        }
        PixelFormat pf = new PixelFormat(this);
        pf.setAttrib(Attrib.LUMINANCE_SIZE, luminanceSize);
        if (0 < luminanceSize) {
            pf.setAttrib(Attrib.RED_SIZE, 0);
            pf.setAttrib(Attrib.GREEN_SIZE, 0);
            pf.setAttrib(Attrib.BLUE_SIZE, 0);
        }
        return pf;
    }

    public PixelFormat withDepthSize(int depthSize) {
        if (depthSize < 0) {
            throw new IllegalArgumentException("Invalid EGL_DEPTH_SIZE specified: " + depthSize);
        }
        PixelFormat pf = new PixelFormat(this);
        pf.setAttrib(Attrib.DEPTH_SIZE, depthSize);
        return pf;
    }

    public PixelFormat withStencilSize(int stencilSize) {
        if (stencilSize < 0) {
            throw new IllegalArgumentException("Invalid EGL_STENCIL_SIZE specified: " + stencilSize);
        }
        PixelFormat pf = new PixelFormat(this);
        pf.setAttrib(Attrib.STENCIL_SIZE, stencilSize);
        return pf;
    }

    public PixelFormat withMinSwapInterval(int minSwapInterval) {
        int maxSwapInterval = this.getAttrib(Attrib.MAX_SWAP_INTERVAL);
        if (minSwapInterval != -1 && (minSwapInterval < 0 || maxSwapInterval != -1 && maxSwapInterval < minSwapInterval)) {
            throw new IllegalArgumentException("Invalid EGL_MIN_SWAP_INTERVAL specified: " + minSwapInterval);
        }
        PixelFormat pf = new PixelFormat(this);
        pf.setAttrib(Attrib.MIN_SWAP_INTERVAL, minSwapInterval);
        return pf;
    }

    public PixelFormat withMaxSwapInterval(int maxSwapInterval) {
        if (maxSwapInterval < this.getAttrib(Attrib.MIN_SWAP_INTERVAL)) {
            throw new IllegalArgumentException("Invalid EGL_MAX_SWAP_INTERVAL specified: " + maxSwapInterval);
        }
        PixelFormat pf = new PixelFormat(this);
        pf.setAttrib(Attrib.MAX_SWAP_INTERVAL, maxSwapInterval);
        return pf;
    }

    public PixelFormat withSamples(int samples) {
        if (samples != 0 && samples < 2) {
            throw new IllegalArgumentException("Invalid number of EGL_SAMPLES specified: " + samples);
        }
        PixelFormat pf = new PixelFormat(this);
        pf.setAttrib(Attrib.SAMPLES, samples);
        pf.setAttrib(Attrib.SAMPLE_BUFFERS, samples == 0 ? 0 : 1);
        return pf;
    }

    private static int maxValue(int bits) {
        return (2 << bits) - 1;
    }

    public PixelFormat withTransparentType(int transparentType, int r, int g, int b) {
        if (transparentType == 12370) {
            int redSize = this.getAttrib(Attrib.RED_SIZE);
            int greenSize = this.getAttrib(Attrib.GREEN_SIZE);
            int blueSize = this.getAttrib(Attrib.BLUE_SIZE);
            if (r < 0 || 0 < redSize && PixelFormat.maxValue(redSize) < r) {
                throw new IllegalArgumentException("Invalid EGL_TRANSPARENT_RED_VALUE specified: " + r);
            }
            if (r < 0 || 0 < greenSize && PixelFormat.maxValue(greenSize) < g) {
                throw new IllegalArgumentException("Invalid EGL_TRANSPARENT_GREEN_VALUE specified: " + g);
            }
            if (r < 0 || 0 < blueSize && PixelFormat.maxValue(blueSize) < b) {
                throw new IllegalArgumentException("Invalid EGL_TRANSPARENT_BLUE_VALUE specified: " + b);
            }
        } else {
            if (transparentType != 12344) {
                throw new IllegalArgumentException("Invalid EGL_TRANSPARENT_TYPE specified: " + transparentType);
            }
            b = -1;
            g = -1;
            r = -1;
        }
        PixelFormat pf = new PixelFormat(this);
        pf.setAttrib(Attrib.TRANSPARENT_TYPE, transparentType);
        pf.setAttrib(Attrib.TRANSPARENT_RED_VALUE, r);
        pf.setAttrib(Attrib.TRANSPARENT_GREEN_VALUE, g);
        pf.setAttrib(Attrib.TRANSPARENT_BLUE_VALUE, b);
        return pf;
    }

    public PixelFormat withMultisampleResolve(int multisampleResolve) {
        if (multisampleResolve != 12442 && multisampleResolve != 12443) {
            throw new IllegalArgumentException("Invalid EGL_MULTISAMPLE_RESOLVE value specified: " + multisampleResolve);
        }
        if (this.getAttrib(Attrib.SAMPLE_BUFFERS) == 0) {
            throw new IllegalStateException("An EGL_MULTISAMPLE_RESOLVE value cannot be specified unless EGL_SAMPLE_BUFFERS is 1.");
        }
        PixelFormat pf = new PixelFormat(this);
        pf.setAttrib(Attrib.MULTISAMPLE_RESOLVE, multisampleResolve);
        return pf;
    }

    public PixelFormat withSwapBehavior(int swapBehavior) {
        switch (swapBehavior) {
            case -1: 
            case 12436: 
            case 12437: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid EGL_SWAP_BEHAVIOR value specified: " + swapBehavior);
            }
        }
        PixelFormat pf = new PixelFormat(this);
        pf.setAttrib(Attrib.SWAP_BEHAVIOR, swapBehavior);
        return pf;
    }

    public PixelFormat withCoverageSamplesNV(int samples) {
        if (samples < 0) {
            throw new IllegalArgumentException("Invalid number of EGL_COVERAGE_SAMPLES_NV specified: " + samples);
        }
        PixelFormat pf = new PixelFormat(this);
        pf.setAttrib(Attrib.COVERAGE_SAMPLES_NV, samples);
        pf.setAttrib(Attrib.COVERAGE_BUFFERS_NV, samples == 0 ? 0 : 1);
        return pf;
    }

    public PixelFormat withDepthEncodingNonlinearNV(int depthEncoding) {
        switch (depthEncoding) {
            case -1: 
            case 0: 
            case 12515: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid EGL_DEPTH_ENCODING_NONLINEAR_NV value specified: " + depthEncoding);
            }
        }
        PixelFormat pf = new PixelFormat(this);
        pf.setAttrib(Attrib.DEPTH_ENCODING_NONLINEAR_NV, depthEncoding);
        return pf;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Attrib {
        RED_SIZE(12324, 0),
        GREEN_SIZE(12323, 0),
        BLUE_SIZE(12322, 0),
        ALPHA_SIZE(12321, 0),
        LUMINANCE_SIZE(12349, 0),
        DEPTH_SIZE(12325, 0),
        STENCIL_SIZE(12326, 0),
        MIN_SWAP_INTERVAL(12347, -1),
        MAX_SWAP_INTERVAL(12348, -1),
        SAMPLES(12337, 0),
        SAMPLE_BUFFERS(12338, 0),
        TRANSPARENT_TYPE(12340, 12344),
        TRANSPARENT_RED_VALUE(12343, -1),
        TRANSPARENT_GREEN_VALUE(12342, -1),
        TRANSPARENT_BLUE_VALUE(12341, -1),
        MULTISAMPLE_RESOLVE(12441, 12442, true),
        SWAP_BEHAVIOR(12435, -1, true),
        COVERAGE_SAMPLES_NV(12513, 0),
        COVERAGE_BUFFERS_NV(12512, 0),
        DEPTH_ENCODING_NONLINEAR_NV(12515, -1);

        private final int eglAttrib;
        private final int defaultValue;
        private final boolean surfaceAttrib;

        private Attrib(int eglAttrib, int defaultValue) {
            this(eglAttrib, defaultValue, false);
        }

        private Attrib(int eglAttrib, int defaultValue, boolean surfaceAttrib) {
            this.eglAttrib = eglAttrib;
            this.defaultValue = defaultValue;
            this.surfaceAttrib = surfaceAttrib;
        }

        public int getEGLAttrib() {
            return this.eglAttrib;
        }

        public int getDefaultValue() {
            return this.defaultValue;
        }

        public boolean isSurfaceAttrib() {
            return this.surfaceAttrib;
        }
    }
}

