/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.IntBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.LWJGLException;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengles.APIUtil;

public final class NVFence {
    public static final int GL_ALL_COMPLETED_NV = 34034;
    public static final int GL_FENCE_STATUS_NV = 34035;
    public static final int GL_FENCE_CONDITION_NV = 34036;

    private NVFence() {
    }

    static native void initNativeStubs() throws LWJGLException;

    public static void glGenFencesNV(IntBuffer fences) {
        BufferChecks.checkDirect(fences);
        NVFence.nglGenFencesNV(fences.remaining(), MemoryUtil.getAddress(fences));
    }

    static native void nglGenFencesNV(int var0, long var1);

    public static int glGenFencesNV() {
        IntBuffer fences = APIUtil.getBufferInt();
        NVFence.nglGenFencesNV(1, MemoryUtil.getAddress(fences));
        return fences.get(0);
    }

    public static void glDeleteFencesNV(IntBuffer fences) {
        BufferChecks.checkDirect(fences);
        NVFence.nglDeleteFencesNV(fences.remaining(), MemoryUtil.getAddress(fences));
    }

    static native void nglDeleteFencesNV(int var0, long var1);

    public static void glDeleteFencesNV(int fence) {
        NVFence.nglDeleteFencesNV(1, APIUtil.getInt(fence));
    }

    public static void glSetFenceNV(int fence, int condition) {
        NVFence.nglSetFenceNV(fence, condition);
    }

    static native void nglSetFenceNV(int var0, int var1);

    public static boolean glTestFenceNV(int fence) {
        boolean __result = NVFence.nglTestFenceNV(fence);
        return __result;
    }

    static native boolean nglTestFenceNV(int var0);

    public static void glFinishFenceNV(int fence) {
        NVFence.nglFinishFenceNV(fence);
    }

    static native void nglFinishFenceNV(int var0);

    public static boolean glIsFenceNV(int fence) {
        boolean __result = NVFence.nglIsFenceNV(fence);
        return __result;
    }

    static native boolean nglIsFenceNV(int var0);

    public static void glGetFenceivNV(int fence, int pname, IntBuffer params) {
        BufferChecks.checkBuffer(params, 1);
        NVFence.nglGetFenceivNV(fence, pname, MemoryUtil.getAddress(params));
    }

    static native void nglGetFenceivNV(int var0, int var1, long var2);
}

