/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.LWJGLException;
import org.lwjgl.MemoryUtil;
import org.lwjgl.PointerWrapper;
import org.lwjgl.opengles.APIUtil;
import org.lwjgl.opengles.CallbackUtil;
import org.lwjgl.opengles.KHRDebugCallback;

public final class KHRDebug {
    public static final int GL_DEBUG_OUTPUT = 37600;
    public static final int GL_DEBUG_OUTPUT_SYNCHRONOUS = 33346;
    public static final int GL_CONTEXT_FLAG_DEBUG_BIT = 2;
    public static final int GL_MAX_DEBUG_MESSAGE_LENGTH = 37187;
    public static final int GL_MAX_DEBUG_LOGGED_MESSAGES = 37188;
    public static final int GL_DEBUG_LOGGED_MESSAGES = 37189;
    public static final int GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH = 33347;
    public static final int GL_MAX_DEBUG_GROUP_STACK_DEPTH = 33388;
    public static final int GL_DEBUG_GROUP_STACK_DEPTH = 33389;
    public static final int GL_MAX_LABEL_LENGTH = 33512;
    public static final int GL_DEBUG_CALLBACK_FUNCTION = 33348;
    public static final int GL_DEBUG_CALLBACK_USER_PARAM = 33349;
    public static final int GL_DEBUG_SOURCE_API = 33350;
    public static final int GL_DEBUG_SOURCE_WINDOW_SYSTEM = 33351;
    public static final int GL_DEBUG_SOURCE_SHADER_COMPILER = 33352;
    public static final int GL_DEBUG_SOURCE_THIRD_PARTY = 33353;
    public static final int GL_DEBUG_SOURCE_APPLICATION = 33354;
    public static final int GL_DEBUG_SOURCE_OTHER = 33355;
    public static final int GL_DEBUG_TYPE_ERROR = 33356;
    public static final int GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR = 33357;
    public static final int GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR = 33358;
    public static final int GL_DEBUG_TYPE_PORTABILITY = 33359;
    public static final int GL_DEBUG_TYPE_PERFORMANCE = 33360;
    public static final int GL_DEBUG_TYPE_OTHER = 33361;
    public static final int GL_DEBUG_TYPE_MARKER = 33384;
    public static final int GL_DEBUG_TYPE_PUSH_GROUP = 33385;
    public static final int GL_DEBUG_TYPE_POP_GROUP = 33386;
    public static final int GL_DEBUG_SEVERITY_HIGH = 37190;
    public static final int GL_DEBUG_SEVERITY_MEDIUM = 37191;
    public static final int GL_DEBUG_SEVERITY_LOW = 37192;
    public static final int GL_DEBUG_SEVERITY_NOTIFICATION = 33387;
    public static final int GL_STACK_UNDERFLOW = 1284;
    public static final int GL_STACK_OVERFLOW = 1283;
    public static final int GL_BUFFER = 33504;
    public static final int GL_SHADER = 33505;
    public static final int GL_PROGRAM = 33506;
    public static final int GL_QUERY = 33507;
    public static final int GL_PROGRAM_PIPELINE = 33508;
    public static final int GL_SAMPLER = 33510;
    public static final int GL_DISPLAY_LIST = 33511;

    private KHRDebug() {
    }

    static native void initNativeStubs() throws LWJGLException;

    public static void glDebugMessageControl(int source, int type, int severity, IntBuffer ids, boolean enabled) {
        if (ids != null) {
            BufferChecks.checkDirect(ids);
        }
        KHRDebug.nglDebugMessageControl(source, type, severity, ids == null ? 0 : ids.remaining(), MemoryUtil.getAddressSafe(ids), enabled);
    }

    static native void nglDebugMessageControl(int var0, int var1, int var2, int var3, long var4, boolean var6);

    public static void glDebugMessageInsert(int source, int type, int id, int severity, ByteBuffer buf) {
        BufferChecks.checkDirect(buf);
        KHRDebug.nglDebugMessageInsert(source, type, id, severity, buf.remaining(), MemoryUtil.getAddress(buf));
    }

    static native void nglDebugMessageInsert(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glDebugMessageInsert(int source, int type, int id, int severity, CharSequence buf) {
        KHRDebug.nglDebugMessageInsert(source, type, id, severity, buf.length(), APIUtil.getBuffer(buf));
    }

    public static void glDebugMessageCallback(KHRDebugCallback callback) {
        long userParam = callback == null ? 0L : CallbackUtil.createGlobalRef(callback.getHandler());
        CallbackUtil.registerContextCallbackKHR(userParam);
        KHRDebug.nglDebugMessageCallback(callback == null ? 0L : callback.getPointer(), userParam);
    }

    static native void nglDebugMessageCallback(long var0, long var2);

    public static int glGetDebugMessageLog(int count, IntBuffer sources, IntBuffer types, IntBuffer ids, IntBuffer severities, IntBuffer lengths, ByteBuffer messageLog) {
        if (sources != null) {
            BufferChecks.checkBuffer(sources, count);
        }
        if (types != null) {
            BufferChecks.checkBuffer(types, count);
        }
        if (ids != null) {
            BufferChecks.checkBuffer(ids, count);
        }
        if (severities != null) {
            BufferChecks.checkBuffer(severities, count);
        }
        if (lengths != null) {
            BufferChecks.checkBuffer(lengths, count);
        }
        if (messageLog != null) {
            BufferChecks.checkDirect(messageLog);
        }
        int __result = KHRDebug.nglGetDebugMessageLog(count, messageLog == null ? 0 : messageLog.remaining(), MemoryUtil.getAddressSafe(sources), MemoryUtil.getAddressSafe(types), MemoryUtil.getAddressSafe(ids), MemoryUtil.getAddressSafe(severities), MemoryUtil.getAddressSafe(lengths), MemoryUtil.getAddressSafe(messageLog));
        return __result;
    }

    static native int nglGetDebugMessageLog(int var0, int var1, long var2, long var4, long var6, long var8, long var10, long var12);

    public static void glPushDebugGroup(int source, int id, ByteBuffer message) {
        BufferChecks.checkDirect(message);
        KHRDebug.nglPushDebugGroup(source, id, message.remaining(), MemoryUtil.getAddress(message));
    }

    static native void nglPushDebugGroup(int var0, int var1, int var2, long var3);

    public static void glPushDebugGroup(int source, int id, CharSequence message) {
        KHRDebug.nglPushDebugGroup(source, id, message.length(), APIUtil.getBuffer(message));
    }

    public static void glPopDebugGroup() {
        KHRDebug.nglPopDebugGroup();
    }

    static native void nglPopDebugGroup();

    public static void glObjectLabel(int identifier, int name, ByteBuffer label) {
        if (label != null) {
            BufferChecks.checkDirect(label);
        }
        KHRDebug.nglObjectLabel(identifier, name, label == null ? 0 : label.remaining(), MemoryUtil.getAddressSafe(label));
    }

    static native void nglObjectLabel(int var0, int var1, int var2, long var3);

    public static void glObjectLabel(int identifier, int name, CharSequence label) {
        KHRDebug.nglObjectLabel(identifier, name, label.length(), APIUtil.getBuffer(label));
    }

    public static void glGetObjectLabel(int identifier, int name, IntBuffer length, ByteBuffer label) {
        if (length != null) {
            BufferChecks.checkBuffer(length, 1);
        }
        BufferChecks.checkDirect(label);
        KHRDebug.nglGetObjectLabel(identifier, name, label.remaining(), MemoryUtil.getAddressSafe(length), MemoryUtil.getAddress(label));
    }

    static native void nglGetObjectLabel(int var0, int var1, int var2, long var3, long var5);

    public static String glGetObjectLabel(int identifier, int name, int bufSize) {
        IntBuffer label_length = APIUtil.getLengths();
        ByteBuffer label = APIUtil.getBufferByte(bufSize);
        KHRDebug.nglGetObjectLabel(identifier, name, bufSize, MemoryUtil.getAddress0(label_length), MemoryUtil.getAddress(label));
        label.limit(label_length.get(0));
        return APIUtil.getString(label);
    }

    public static void glObjectPtrLabel(PointerWrapper ptr, ByteBuffer label) {
        if (label != null) {
            BufferChecks.checkDirect(label);
        }
        KHRDebug.nglObjectPtrLabel(ptr.getPointer(), label == null ? 0 : label.remaining(), MemoryUtil.getAddressSafe(label));
    }

    static native void nglObjectPtrLabel(long var0, int var2, long var3);

    public static void glObjectPtrLabel(PointerWrapper ptr, CharSequence label) {
        KHRDebug.nglObjectPtrLabel(ptr.getPointer(), label.length(), APIUtil.getBuffer(label));
    }

    public static void glGetObjectPtrLabel(PointerWrapper ptr, IntBuffer length, ByteBuffer label) {
        if (length != null) {
            BufferChecks.checkBuffer(length, 1);
        }
        BufferChecks.checkDirect(label);
        KHRDebug.nglGetObjectPtrLabel(ptr.getPointer(), label.remaining(), MemoryUtil.getAddressSafe(length), MemoryUtil.getAddress(label));
    }

    static native void nglGetObjectPtrLabel(long var0, int var2, long var3, long var5);

    public static String glGetObjectPtrLabel(PointerWrapper ptr, int bufSize) {
        IntBuffer label_length = APIUtil.getLengths();
        ByteBuffer label = APIUtil.getBufferByte(bufSize);
        KHRDebug.nglGetObjectPtrLabel(ptr.getPointer(), bufSize, MemoryUtil.getAddress0(label_length), MemoryUtil.getAddress(label));
        label.limit(label_length.get(0));
        return APIUtil.getString(label);
    }
}

