/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.OpenGLException;
import org.lwjgl.opengles.StateTracker;

class GLChecks {
    private GLChecks() {
    }

    static void ensureArrayVBOdisabled() {
        if (LWJGLUtil.CHECKS && StateTracker.getTracker().arrayBuffer != 0) {
            throw new OpenGLException("Cannot use Buffers when Array Buffer Object is enabled");
        }
    }

    static void ensureArrayVBOenabled() {
        if (LWJGLUtil.CHECKS && StateTracker.getTracker().arrayBuffer == 0) {
            throw new OpenGLException("Cannot use offsets when Array Buffer Object is disabled");
        }
    }

    static void ensureElementVBOdisabled() {
        if (LWJGLUtil.CHECKS && StateTracker.getTracker().elementArrayBuffer != 0) {
            throw new OpenGLException("Cannot use Buffers when Element Array Buffer Object is enabled");
        }
    }

    static void ensureElementVBOenabled() {
        if (LWJGLUtil.CHECKS && StateTracker.getTracker().elementArrayBuffer == 0) {
            throw new OpenGLException("Cannot use offsets when Element Array Buffer Object is disabled");
        }
    }

    static void ensurePackPBOdisabled() {
        if (LWJGLUtil.CHECKS && StateTracker.getTracker().pixelPackBuffer != 0) {
            throw new OpenGLException("Cannot use Buffers when Pixel Pack Buffer Object is enabled");
        }
    }

    static void ensurePackPBOenabled() {
        if (LWJGLUtil.CHECKS && StateTracker.getTracker().pixelPackBuffer == 0) {
            throw new OpenGLException("Cannot use offsets when Pixel Pack Buffer Object is disabled");
        }
    }

    static void ensureUnpackPBOdisabled() {
        if (LWJGLUtil.CHECKS && StateTracker.getTracker().pixelUnpackBuffer != 0) {
            throw new OpenGLException("Cannot use Buffers when Pixel Unpack Buffer Object is enabled");
        }
    }

    static void ensureUnpackPBOenabled() {
        if (LWJGLUtil.CHECKS && StateTracker.getTracker().pixelUnpackBuffer == 0) {
            throw new OpenGLException("Cannot use offsets when Pixel Unpack Buffer Object is disabled");
        }
    }

    static int calculateImageStorage(Buffer buffer, int format, int type, int width, int height, int depth) {
        return LWJGLUtil.CHECKS ? GLChecks.calculateImageStorage(format, type, width, height, depth) >> BufferUtils.getElementSizeExponent(buffer) : 0;
    }

    static int calculateTexImage1DStorage(Buffer buffer, int format, int type, int width) {
        return LWJGLUtil.CHECKS ? GLChecks.calculateTexImage1DStorage(format, type, width) >> BufferUtils.getElementSizeExponent(buffer) : 0;
    }

    static int calculateTexImage2DStorage(Buffer buffer, int format, int type, int width, int height) {
        return LWJGLUtil.CHECKS ? GLChecks.calculateTexImage2DStorage(format, type, width, height) >> BufferUtils.getElementSizeExponent(buffer) : 0;
    }

    static int calculateTexImage3DStorage(Buffer buffer, int format, int type, int width, int height, int depth) {
        return LWJGLUtil.CHECKS ? GLChecks.calculateTexImage3DStorage(format, type, width, height, depth) >> BufferUtils.getElementSizeExponent(buffer) : 0;
    }

    private static int calculateImageStorage(int format, int type, int width, int height, int depth) {
        return GLChecks.calculateBytesPerPixel(format, type) * width * height * depth;
    }

    private static int calculateTexImage1DStorage(int format, int type, int width) {
        return GLChecks.calculateBytesPerPixel(format, type) * width;
    }

    private static int calculateTexImage2DStorage(int format, int type, int width, int height) {
        return GLChecks.calculateTexImage1DStorage(format, type, width) * height;
    }

    private static int calculateTexImage3DStorage(int format, int type, int width, int height, int depth) {
        return GLChecks.calculateTexImage2DStorage(format, type, width, height) * depth;
    }

    private static int calculateBytesPerPixel(int format, int type) {
        int epp;
        int bpe;
        switch (type) {
            case 5120: 
            case 5121: {
                bpe = 1;
                break;
            }
            case 5122: 
            case 5123: {
                bpe = 2;
                break;
            }
            case 5124: 
            case 5125: 
            case 5126: {
                bpe = 4;
                break;
            }
            default: {
                return 0;
            }
        }
        switch (format) {
            case 6406: 
            case 6409: {
                epp = 1;
                break;
            }
            case 6410: {
                epp = 2;
                break;
            }
            case 6407: {
                epp = 3;
                break;
            }
            case 6408: {
                epp = 4;
                break;
            }
            default: {
                return 0;
            }
        }
        return bpe * epp;
    }
}

