/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.IntBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.LWJGLException;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengles.APIUtil;

public final class EXTMultiviewDrawBuffers {
    public static final int GL_COLOR_ATTACHMENT_EXT = 37104;
    public static final int GL_MULTIVIEW_EXT = 37105;
    public static final int GL_DRAW_BUFFER_EXT = 3073;
    public static final int GL_READ_BUFFER_EXT = 3074;
    public static final int GL_MAX_MULTIVIEW_BUFFERS_EXT = 37106;

    private EXTMultiviewDrawBuffers() {
    }

    static native void initNativeStubs() throws LWJGLException;

    public static void glReadBufferIndexedEXT(int src, int index) {
        EXTMultiviewDrawBuffers.nglReadBufferIndexedEXT(src, index);
    }

    static native void nglReadBufferIndexedEXT(int var0, int var1);

    public static void glDrawBuffersIndexedEXT(IntBuffer location, IntBuffer indices) {
        BufferChecks.checkBuffer(location, indices.remaining());
        BufferChecks.checkDirect(indices);
        EXTMultiviewDrawBuffers.nglDrawBuffersIndexedEXT(indices.remaining(), MemoryUtil.getAddress(location), MemoryUtil.getAddress(indices));
    }

    static native void nglDrawBuffersIndexedEXT(int var0, long var1, long var3);

    public static void glGetIntegerEXT(int target, int index, IntBuffer data) {
        BufferChecks.checkBuffer(data, 4);
        EXTMultiviewDrawBuffers.nglGetIntegeri_vEXT(target, index, MemoryUtil.getAddress(data));
    }

    static native void nglGetIntegeri_vEXT(int var0, int var1, long var2);

    public static int glGetIntegerEXT(int value, int index) {
        IntBuffer data = APIUtil.getBufferInt();
        EXTMultiviewDrawBuffers.nglGetIntegeri_vEXT(value, index, MemoryUtil.getAddress(data));
        return data.get(0);
    }
}

