/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.IntBuffer;
import org.lwjgl.LWJGLException;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengles.APIUtil;
import org.lwjgl.opengles.EGL;
import org.lwjgl.opengles.EGLDisplay;
import org.lwjgl.opengles.EGLSyncNV;

public final class EGLNVSync {
    public static final int EGL_SYNC_PRIOR_COMMANDS_COMPLETE_NV = 12518;
    public static final int EGL_SYNC_STATUS_NV = 12519;
    public static final int EGL_SIGNALED_NV = 12520;
    public static final int EGL_UNSIGNALED_NV = 12521;
    public static final int EGL_SYNC_FLUSH_COMMANDS_BIT_NV = 1;
    public static final long EGL_FOREVER_NV = -1L;
    public static final int EGL_ALREADY_SIGNALED_NV = 12522;
    public static final int EGL_TIMEOUT_EXPIRED_NV = 12523;
    public static final int EGL_CONDITION_SATISFIED_NV = 12524;
    public static final int EGL_SYNC_TYPE_NV = 12525;
    public static final int EGL_SYNC_CONDITION_NV = 12526;
    public static final int EGL_SYNC_FENCE_NV = 12527;
    public static final long EGL_NO_SYNC_NV = 0L;

    private EGLNVSync() {
    }

    private static native void initNativeStubs();

    public static EGLSyncNV eglCreateFenceSyncNV(EGLDisplay dpy, int condition, IntBuffer attrib_list) throws LWJGLException {
        EGL.checkAttribList(attrib_list);
        long pointer = EGLNVSync.neglCreateFenceSyncNV(dpy.getPointer(), condition, MemoryUtil.getAddressSafe(attrib_list));
        if (pointer == 0L) {
            EGL.throwEGLError("Failed to create NV fence sync object.");
        }
        return new EGLSyncNV(pointer);
    }

    private static native long neglCreateFenceSyncNV(long var0, int var2, long var3);

    public static void eglDestroySyncNV(EGLSyncNV sync) throws LWJGLException {
        if (!EGLNVSync.neglDestroySyncNV(sync.getPointer())) {
            EGL.throwEGLError("Failed to destroy NV fence sync object.");
        }
    }

    private static native boolean neglDestroySyncNV(long var0);

    public static void eglFenceNV(EGLSyncNV sync) throws LWJGLException {
        if (!EGLNVSync.neglFenceNV(sync.getPointer())) {
            EGL.throwEGLError("Failed to insert NV fence command.");
        }
    }

    private static native boolean neglFenceNV(long var0);

    public static int eglClientWaitSyncNV(EGLSyncNV sync, int flags, long timeout) throws LWJGLException {
        int status = EGLNVSync.neglClientWaitSyncNV(sync.getPointer(), flags, timeout);
        if (status == 0) {
            EGL.throwEGLError("Failed to block on NV fence sync object.");
        }
        return status;
    }

    private static native int neglClientWaitSyncNV(long var0, int var2, long var3);

    public static void eglSignalSyncNV(EGLSyncNV sync, int mode) throws LWJGLException {
        if (!EGLNVSync.neglSignalSyncNV(sync.getPointer(), mode)) {
            EGL.throwEGLError("Failed to signal the NV fence sync object.");
        }
    }

    private static native boolean neglSignalSyncNV(long var0, int var2);

    public static int eglGetSyncAttribNV(EGLSyncNV sync, int attribute) throws LWJGLException {
        IntBuffer value = APIUtil.getBufferInt();
        if (!EGLNVSync.neglGetSyncAttribNV(sync.getPointer(), attribute, MemoryUtil.getAddress0(value))) {
            EGL.throwEGLError("Failed to get NV fence sync object attribute.");
        }
        return value.get(0);
    }

    private static native boolean neglGetSyncAttribNV(long var0, int var2, long var3);

    static {
        EGLNVSync.initNativeStubs();
    }
}

