/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.IntBuffer;
import org.lwjgl.LWJGLException;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengles.APIUtil;
import org.lwjgl.opengles.EGL;
import org.lwjgl.opengles.EGLDisplay;
import org.lwjgl.opengles.EGLSyncKHR;

public final class EGLKHRFenceSync {
    public static final int EGL_SYNC_FENCE_KHR = 12537;
    public static final int EGL_SYNC_TYPE_KHR = 12535;
    public static final int EGL_SYNC_STATUS_KHR = 12529;
    public static final int EGL_SYNC_CONDITION_KHR = 12536;
    public static final int EGL_SIGNALED_KHR = 12530;
    public static final int EGL_UNSIGNALED_KHR = 12531;
    public static final int EGL_SYNC_PRIOR_COMMANDS_COMPLETE_KHR = 12528;
    public static final int EGL_SYNC_FLUSH_COMMANDS_BIT_KHR = 1;
    public static final long EGL_FOREVER_KHR = -1L;
    public static final int EGL_TIMEOUT_EXPIRED_KHR = 12533;
    public static final int EGL_CONDITION_SATISFIED_KHR = 12534;
    public static final long EGL_NO_SYNC_KHR = 0L;

    private EGLKHRFenceSync() {
    }

    private static native void initNativeStubs();

    public static EGLSyncKHR eglCreateSyncKHR(EGLDisplay dpy, int type, IntBuffer attrib_list) throws LWJGLException {
        EGL.checkAttribList(attrib_list);
        long pointer = EGLKHRFenceSync.neglCreateSyncKHR(dpy.getPointer(), type, MemoryUtil.getAddressSafe(attrib_list));
        if (pointer == 0L) {
            EGL.throwEGLError("Failed to create KHR fence sync object.");
        }
        return new EGLSyncKHR(pointer);
    }

    private static native long neglCreateSyncKHR(long var0, int var2, long var3);

    public static void eglDestroySyncKHR(EGLDisplay dpy, EGLSyncKHR sync) throws LWJGLException {
        if (!EGLKHRFenceSync.neglDestroySyncKHR(dpy.getPointer(), sync.getPointer())) {
            EGL.throwEGLError("Failed to destroy KHR fence sync object.");
        }
    }

    private static native boolean neglDestroySyncKHR(long var0, long var2);

    public static int eglClientWaitSyncKHR(EGLDisplay dpy, EGLSyncKHR sync, int flags, long timeout) throws LWJGLException {
        int status = EGLKHRFenceSync.neglClientWaitSyncKHR(dpy.getPointer(), sync.getPointer(), flags, timeout);
        if (status == 0) {
            EGL.throwEGLError("Failed to block on KHR fence sync object.");
        }
        return status;
    }

    private static native int neglClientWaitSyncKHR(long var0, long var2, int var4, long var5);

    public static int eglGetSyncAttribKHR(EGLDisplay dpy, EGLSyncKHR sync, int attribute) throws LWJGLException {
        IntBuffer value = APIUtil.getBufferInt();
        if (!EGLKHRFenceSync.neglGetSyncAttribKHR(dpy.getPointer(), sync.getPointer(), attribute, MemoryUtil.getAddress(value))) {
            EGL.throwEGLError("Failed to get KHR fence sync object attribute.");
        }
        return value.get(0);
    }

    private static native boolean neglGetSyncAttribKHR(long var0, long var2, int var4, long var5);

    static {
        EGLKHRFenceSync.initNativeStubs();
    }
}

