/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.IntBuffer;
import org.lwjgl.LWJGLException;
import org.lwjgl.PointerWrapperAbstract;
import org.lwjgl.opengles.APIUtil;
import org.lwjgl.opengles.EGL;
import org.lwjgl.opengles.EGLConfig;
import org.lwjgl.opengles.EGLDisplay;
import org.lwjgl.opengles.EGLSurface;
import org.lwjgl.opengles.PowerManagementEventException;

public final class EGLContext
extends PointerWrapperAbstract {
    private EGLDisplay display;
    private final EGLConfig config;
    private boolean destroyed;

    EGLContext(EGLDisplay display, EGLConfig config, long pointer) {
        super(pointer);
        if (!display.isInitialized()) {
            throw new IllegalStateException("Invalid EGL display specified.");
        }
        if (config.getDisplay() != display) {
            throw new IllegalStateException("Invalid EGL config specified.");
        }
        this.display = display;
        this.config = config;
    }

    public void setDisplay(EGLDisplay display) {
        this.display = display;
    }

    EGLDisplay getDisplay() {
        return this.display;
    }

    EGLConfig getConfig() {
        return this.config;
    }

    private void checkDestroyed() {
        if (this.destroyed) {
            throw new IllegalStateException("The EGL surface has been destroyed.");
        }
    }

    public void destroy() throws LWJGLException {
        EGL.eglDestroyContext(this.display, this);
        this.destroyed = true;
    }

    int getAttribute(int attribute) throws LWJGLException {
        this.checkDestroyed();
        IntBuffer value = APIUtil.getBufferInt();
        EGL.eglQueryContext(this.display, this, attribute, value);
        return value.get(0);
    }

    public void makeCurrent(EGLSurface surface) throws LWJGLException, PowerManagementEventException {
        this.makeCurrent(surface, surface);
    }

    public void makeCurrent(EGLSurface draw, EGLSurface read) throws LWJGLException, PowerManagementEventException {
        EGL.eglMakeCurrent(this.display, draw, read, this);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof EGLContext)) {
            return false;
        }
        return this.getPointer() == ((EGLContext)obj).getPointer();
    }
}

