/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.MemoryUtil;
import org.lwjgl.PointerBuffer;

final class APIUtil {
    private static final int INITIAL_BUFFER_SIZE = 256;
    private static final int INITIAL_LENGTHS_SIZE = 4;
    private static final int BUFFERS_SIZE = 32;
    private static final ThreadLocal<char[]> arrayTL = new ThreadLocal<char[]>(){

        @Override
        protected char[] initialValue() {
            return new char[256];
        }
    };
    private static final ThreadLocal<ByteBuffer> bufferTL = new ThreadLocal<ByteBuffer>(){

        @Override
        protected ByteBuffer initialValue() {
            return BufferUtils.createByteBuffer(256);
        }
    };
    private static final ThreadLocal<PointerBuffer> bufferPointerTL = new ThreadLocal<PointerBuffer>(){

        @Override
        protected PointerBuffer initialValue() {
            return BufferUtils.createPointerBuffer(256);
        }
    };
    private static final ThreadLocal<IntBuffer> lengthsTL = new ThreadLocal<IntBuffer>(){

        @Override
        protected IntBuffer initialValue() {
            return BufferUtils.createIntBuffer(4);
        }
    };
    private static final ThreadLocal<Buffers> buffersTL = new ThreadLocal<Buffers>(){

        @Override
        protected Buffers initialValue() {
            return new Buffers();
        }
    };

    private APIUtil() {
    }

    private static char[] getArray(int size) {
        char[] array = arrayTL.get();
        if (array.length < size) {
            for (int sizeNew = array.length << 1; sizeNew < size; sizeNew <<= 1) {
            }
            array = new char[size];
            arrayTL.set(array);
        }
        return array;
    }

    static ByteBuffer getBufferByte(int size) {
        ByteBuffer buffer = bufferTL.get();
        if (buffer.capacity() < size) {
            for (int sizeNew = buffer.capacity() << 1; sizeNew < size; sizeNew <<= 1) {
            }
            buffer = BufferUtils.createByteBuffer(size);
            bufferTL.set(buffer);
        } else {
            buffer.clear();
        }
        return buffer;
    }

    private static ByteBuffer getBufferByteOffset(int size) {
        ByteBuffer buffer = bufferTL.get();
        if (buffer.capacity() < size) {
            for (int sizeNew = buffer.capacity() << 1; sizeNew < size; sizeNew <<= 1) {
            }
            ByteBuffer bufferNew = BufferUtils.createByteBuffer(size);
            bufferNew.put(buffer);
            buffer = bufferNew;
            bufferTL.set(buffer);
        } else {
            buffer.position(buffer.limit());
            buffer.limit(buffer.capacity());
        }
        return buffer;
    }

    static PointerBuffer getBufferPointer(int size) {
        PointerBuffer buffer = bufferPointerTL.get();
        if (buffer.capacity() < size) {
            for (int sizeNew = buffer.capacity() << 1; sizeNew < size; sizeNew <<= 1) {
            }
            buffer = BufferUtils.createPointerBuffer(size);
            bufferPointerTL.set(buffer);
        } else {
            buffer.clear();
        }
        return buffer;
    }

    static IntBuffer getBufferInt() {
        return APIUtil.buffersTL.get().ints;
    }

    static LongBuffer getBufferLong() {
        return APIUtil.buffersTL.get().longs;
    }

    static FloatBuffer getBufferFloat() {
        return APIUtil.buffersTL.get().floats;
    }

    static IntBuffer getLengths() {
        return APIUtil.getLengths(1);
    }

    static IntBuffer getLengths(int size) {
        IntBuffer lengths = lengthsTL.get();
        if (lengths.capacity() < size) {
            for (int sizeNew = lengths.capacity(); sizeNew < size; sizeNew <<= 1) {
            }
            lengths = BufferUtils.createIntBuffer(size);
            lengthsTL.set(lengths);
        } else {
            lengths.clear();
        }
        return lengths;
    }

    private static ByteBuffer encode(ByteBuffer buffer, CharSequence string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (LWJGLUtil.DEBUG && '\u0080' <= c) {
                buffer.put((byte)26);
                continue;
            }
            buffer.put((byte)c);
        }
        return buffer;
    }

    static String getString(ByteBuffer buffer) {
        int length = buffer.remaining();
        char[] charArray = APIUtil.getArray(length);
        for (int i = buffer.position(); i < buffer.limit(); ++i) {
            charArray[i - buffer.position()] = (char)buffer.get(i);
        }
        return new String(charArray, 0, length);
    }

    static long getBuffer(CharSequence string) {
        ByteBuffer buffer = APIUtil.encode(APIUtil.getBufferByte(string.length()), string);
        buffer.flip();
        return MemoryUtil.getAddress0(buffer);
    }

    static long getBuffer(CharSequence string, int offset) {
        ByteBuffer buffer = APIUtil.encode(APIUtil.getBufferByteOffset(offset + string.length()), string);
        buffer.flip();
        return MemoryUtil.getAddress(buffer);
    }

    static long getBufferNT(CharSequence string) {
        ByteBuffer buffer = APIUtil.encode(APIUtil.getBufferByte(string.length() + 1), string);
        buffer.put((byte)0);
        buffer.flip();
        return MemoryUtil.getAddress0(buffer);
    }

    static int getTotalLength(CharSequence[] strings) {
        int length = 0;
        for (CharSequence string : strings) {
            length += string.length();
        }
        return length;
    }

    static long getBuffer(CharSequence[] strings) {
        ByteBuffer buffer = APIUtil.getBufferByte(APIUtil.getTotalLength(strings));
        for (CharSequence string : strings) {
            APIUtil.encode(buffer, string);
        }
        buffer.flip();
        return MemoryUtil.getAddress0(buffer);
    }

    static long getBufferNT(CharSequence[] strings) {
        ByteBuffer buffer = APIUtil.getBufferByte(APIUtil.getTotalLength(strings) + strings.length);
        for (CharSequence string : strings) {
            APIUtil.encode(buffer, string);
            buffer.put((byte)0);
        }
        buffer.flip();
        return MemoryUtil.getAddress0(buffer);
    }

    static long getLengths(CharSequence[] strings) {
        IntBuffer buffer = APIUtil.getLengths(strings.length);
        for (CharSequence string : strings) {
            buffer.put(string.length());
        }
        buffer.flip();
        return MemoryUtil.getAddress0(buffer);
    }

    static long getInt(int value) {
        return MemoryUtil.getAddress(APIUtil.getBufferInt().put(0, value), 0);
    }

    static long getBufferByte0() {
        return MemoryUtil.getAddress0(APIUtil.getBufferByte(0));
    }

    private static class Buffers {
        final IntBuffer ints = BufferUtils.createIntBuffer(32);
        final LongBuffer longs = BufferUtils.createLongBuffer(32);
        final FloatBuffer floats = BufferUtils.createFloatBuffer(32);

        Buffers() {
        }
    }
}

