/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.LWJGLException;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengles.APIUtil;

public final class AMDPerformanceMonitor {
    public static final int GL_COUNTER_TYPE_AMD = 35776;
    public static final int GL_COUNTER_RANGE_AMD = 35777;
    public static final int GL_UNSIGNED_INT64_AMD = 35778;
    public static final int GL_PERCENTAGE_AMD = 35779;
    public static final int GL_PERFMON_RESULT_AVAILABLE_AMD = 35780;
    public static final int GL_PERFMON_RESULT_SIZE_AMD = 35781;
    public static final int GL_PERFMON_RESULT_AMD = 35782;

    private AMDPerformanceMonitor() {
    }

    static native void initNativeStubs() throws LWJGLException;

    public static void glGetPerfMonitorGroupsAMD(IntBuffer numGroups, IntBuffer groups) {
        if (numGroups != null) {
            BufferChecks.checkBuffer(numGroups, 1);
        }
        BufferChecks.checkDirect(groups);
        AMDPerformanceMonitor.nglGetPerfMonitorGroupsAMD(MemoryUtil.getAddressSafe(numGroups), groups.remaining(), MemoryUtil.getAddress(groups));
    }

    static native void nglGetPerfMonitorGroupsAMD(long var0, int var2, long var3);

    public static void glGetPerfMonitorCountersAMD(int group, IntBuffer numCounters, IntBuffer maxActiveCounters, IntBuffer counters) {
        BufferChecks.checkBuffer(numCounters, 1);
        BufferChecks.checkBuffer(maxActiveCounters, 1);
        BufferChecks.checkDirect(counters);
        AMDPerformanceMonitor.nglGetPerfMonitorCountersAMD(group, MemoryUtil.getAddress(numCounters), MemoryUtil.getAddress(maxActiveCounters), counters.remaining(), MemoryUtil.getAddress(counters));
    }

    static native void nglGetPerfMonitorCountersAMD(int var0, long var1, long var3, int var5, long var6);

    public static void glGetPerfMonitorGroupStringAMD(int group, IntBuffer length, ByteBuffer groupString) {
        if (length != null) {
            BufferChecks.checkBuffer(length, 1);
        }
        BufferChecks.checkDirect(groupString);
        AMDPerformanceMonitor.nglGetPerfMonitorGroupStringAMD(group, groupString.remaining(), MemoryUtil.getAddressSafe(length), MemoryUtil.getAddress(groupString));
    }

    static native void nglGetPerfMonitorGroupStringAMD(int var0, int var1, long var2, long var4);

    public static String glGetPerfMonitorGroupStringAMD(int group, int bufSize) {
        IntBuffer groupString_length = APIUtil.getLengths();
        ByteBuffer groupString = APIUtil.getBufferByte(bufSize);
        AMDPerformanceMonitor.nglGetPerfMonitorGroupStringAMD(group, bufSize, MemoryUtil.getAddress0(groupString_length), MemoryUtil.getAddress(groupString));
        groupString.limit(groupString_length.get(0));
        return APIUtil.getString(groupString);
    }

    public static void glGetPerfMonitorCounterStringAMD(int group, int counter, IntBuffer length, ByteBuffer counterString) {
        if (length != null) {
            BufferChecks.checkBuffer(length, 1);
        }
        BufferChecks.checkDirect(counterString);
        AMDPerformanceMonitor.nglGetPerfMonitorCounterStringAMD(group, counter, counterString.remaining(), MemoryUtil.getAddressSafe(length), MemoryUtil.getAddress(counterString));
    }

    static native void nglGetPerfMonitorCounterStringAMD(int var0, int var1, int var2, long var3, long var5);

    public static String glGetPerfMonitorCounterStringAMD(int group, int counter, int bufSize) {
        IntBuffer counterString_length = APIUtil.getLengths();
        ByteBuffer counterString = APIUtil.getBufferByte(bufSize);
        AMDPerformanceMonitor.nglGetPerfMonitorCounterStringAMD(group, counter, bufSize, MemoryUtil.getAddress0(counterString_length), MemoryUtil.getAddress(counterString));
        counterString.limit(counterString_length.get(0));
        return APIUtil.getString(counterString);
    }

    public static void glGetPerfMonitorCounterInfoAMD(int group, int counter, int pname, ByteBuffer data) {
        BufferChecks.checkBuffer(data, 16);
        AMDPerformanceMonitor.nglGetPerfMonitorCounterInfoAMD(group, counter, pname, MemoryUtil.getAddress(data));
    }

    static native void nglGetPerfMonitorCounterInfoAMD(int var0, int var1, int var2, long var3);

    public static void glGenPerfMonitorsAMD(IntBuffer monitors) {
        BufferChecks.checkDirect(monitors);
        AMDPerformanceMonitor.nglGenPerfMonitorsAMD(monitors.remaining(), MemoryUtil.getAddress(monitors));
    }

    static native void nglGenPerfMonitorsAMD(int var0, long var1);

    public static int glGenPerfMonitorsAMD() {
        IntBuffer monitors = APIUtil.getBufferInt();
        AMDPerformanceMonitor.nglGenPerfMonitorsAMD(1, MemoryUtil.getAddress(monitors));
        return monitors.get(0);
    }

    public static void glDeletePerfMonitorsAMD(IntBuffer monitors) {
        BufferChecks.checkDirect(monitors);
        AMDPerformanceMonitor.nglDeletePerfMonitorsAMD(monitors.remaining(), MemoryUtil.getAddress(monitors));
    }

    static native void nglDeletePerfMonitorsAMD(int var0, long var1);

    public static void glDeletePerfMonitorsAMD(int monitor) {
        AMDPerformanceMonitor.nglDeletePerfMonitorsAMD(1, APIUtil.getInt(monitor));
    }

    public static void glSelectPerfMonitorCountersAMD(int monitor, boolean enable, int group, IntBuffer counterList) {
        BufferChecks.checkDirect(counterList);
        AMDPerformanceMonitor.nglSelectPerfMonitorCountersAMD(monitor, enable, group, counterList.remaining(), MemoryUtil.getAddress(counterList));
    }

    static native void nglSelectPerfMonitorCountersAMD(int var0, boolean var1, int var2, int var3, long var4);

    public static void glSelectPerfMonitorCountersAMD(int monitor, boolean enable, int group, int counter) {
        AMDPerformanceMonitor.nglSelectPerfMonitorCountersAMD(monitor, enable, group, 1, APIUtil.getInt(counter));
    }

    public static void glBeginPerfMonitorAMD(int monitor) {
        AMDPerformanceMonitor.nglBeginPerfMonitorAMD(monitor);
    }

    static native void nglBeginPerfMonitorAMD(int var0);

    public static void glEndPerfMonitorAMD(int monitor) {
        AMDPerformanceMonitor.nglEndPerfMonitorAMD(monitor);
    }

    static native void nglEndPerfMonitorAMD(int var0);

    public static void glGetPerfMonitorCounterDataAMD(int monitor, int pname, IntBuffer data, IntBuffer bytesWritten) {
        BufferChecks.checkDirect(data);
        if (bytesWritten != null) {
            BufferChecks.checkBuffer(bytesWritten, 1);
        }
        AMDPerformanceMonitor.nglGetPerfMonitorCounterDataAMD(monitor, pname, data.remaining(), MemoryUtil.getAddress(data), MemoryUtil.getAddressSafe(bytesWritten));
    }

    static native void nglGetPerfMonitorCounterDataAMD(int var0, int var1, int var2, long var3, long var5);

    public static int glGetPerfMonitorCounterDataAMD(int monitor, int pname) {
        IntBuffer data = APIUtil.getBufferInt();
        AMDPerformanceMonitor.nglGetPerfMonitorCounterDataAMD(monitor, pname, 4, MemoryUtil.getAddress(data), 0L);
        return data.get(0);
    }
}

