/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.examples;

import org.lwjgl.Sys;
import org.lwjgl.input.Keyboard;
import org.lwjgl.openal.AL;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;

public class Game {
    public static final String GAME_TITLE = "My Game";
    private static final int FRAMERATE = 60;
    private static boolean finished;
    private static float angle;

    private Game() {
    }

    public static void main(String[] args) {
        try {
            Game.init();
            Game.run();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            Sys.alert(GAME_TITLE, "An error occured and the game will exit.");
        }
        finally {
            Game.cleanup();
        }
        System.exit(0);
    }

    private static void init() throws Exception {
        Display.setTitle(GAME_TITLE);
        Display.setFullscreen(true);
        Display.setVSyncEnabled(true);
        Display.create();
        AL.create();
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        GL11.glOrtho(0.0, Display.getDisplayMode().getWidth(), 0.0, Display.getDisplayMode().getHeight(), -1.0, 1.0);
        GL11.glMatrixMode(5888);
        GL11.glLoadIdentity();
        GL11.glViewport(0, 0, Display.getDisplayMode().getWidth(), Display.getDisplayMode().getHeight());
    }

    private static void run() {
        while (!finished) {
            Display.update();
            if (Display.isCloseRequested()) {
                finished = true;
                continue;
            }
            if (Display.isActive()) {
                Game.logic();
                Game.render();
                Display.sync(60);
                continue;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Game.logic();
            if (!Display.isVisible() && !Display.isDirty()) continue;
            Game.render();
        }
    }

    private static void cleanup() {
        AL.destroy();
        Display.destroy();
    }

    private static void logic() {
        if (Keyboard.isKeyDown(1)) {
            finished = true;
        }
        angle += 2.0f;
    }

    private static void render() {
        GL11.glClear(17408);
        GL11.glClear(16384);
        GL11.glPushMatrix();
        GL11.glTranslatef(Display.getDisplayMode().getWidth() / 2, Display.getDisplayMode().getHeight() / 2, 0.0f);
        GL11.glRotatef(angle, 0.0f, 0.0f, 1.0f);
        GL11.glBegin(7);
        GL11.glVertex2i(-50, -50);
        GL11.glVertex2i(50, -50);
        GL11.glVertex2i(50, 50);
        GL11.glVertex2i(-50, 50);
        GL11.glEnd();
        GL11.glPopMatrix();
    }
}

