/*
 * Decompiled with CFR 0.152.
 */
package legacyfix.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetIndexUtils {
    public static final String assetDir = System.getProperty("lf.assetDir");
    public static final String assetIndex = System.getProperty("lf.assetIndex");
    public static String workingDir = System.getProperty("user.home");
    public static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public static JsonObject assetindex;
    public static ArrayList<URI> uris;

    public static File getAssetIndex() {
        if (assetIndex == null) {
            return null;
        }
        File file = new File(assetIndex);
        if (!file.exists() || !file.isFile()) {
            return null;
        }
        return file;
    }

    public static boolean loadAssetObjectData() {
        try {
            FileInputStream fis = new FileInputStream(AssetIndexUtils.getAssetIndex());
            assetindex = (JsonObject)gson.fromJson((Reader)new InputStreamReader((InputStream)fis, "UTF-8"), JsonObject.class);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
        return true;
    }

    public static ArrayList<File> asFileArray() {
        ArrayList<File> list = new ArrayList<File>();
        try {
            for (URI uri : AssetIndexUtils.asURIs()) {
                list.add(new File(uri));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return list;
    }

    public static void unpackMissingAssets(File assetFile, String entry) {
        try {
            int read;
            InputStream is = AssetIndexUtils.class.getResourceAsStream("/patchasset/" + entry);
            FileOutputStream fout = new FileOutputStream(assetFile);
            byte[] buff = new byte[4096];
            while ((read = is.read(buff)) > 0) {
                fout.write(buff, 0, read);
            }
            is.close();
            fout.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static ArrayList<URI> asURIs() {
        ArrayList<URI> uris = new ArrayList<URI>();
        if (assetindex == null && !AssetIndexUtils.loadAssetObjectData()) {
            System.out.println("[legacyfix] Asset index unable to load");
            return uris;
        }
        if (AssetIndexUtils.uris != null) {
            return AssetIndexUtils.uris;
        }
        if (workingDir.endsWith("/") || workingDir.endsWith("\\")) {
            workingDir = workingDir.substring(0, workingDir.length() - 1);
        }
        JsonObject obj = assetindex.get("objects").getAsJsonObject();
        for (Map.Entry entry : obj.entrySet()) {
            JsonObject value = ((JsonElement)entry.getValue()).getAsJsonObject();
            String hash = value.get("hash").getAsString();
            File assetFile = new File(assetDir, "objects/" + hash.substring(0, 2) + "/" + hash);
            File assetKeyFile = new File(assetDir, (String)entry.getKey());
            if (!assetFile.exists() || assetFile.length() == 0L || !hash.equalsIgnoreCase(AssetIndexUtils.getSHA1(assetFile))) {
                assetFile.getParentFile().mkdirs();
                AssetIndexUtils.unpackMissingAssets(assetFile, (String)entry.getKey());
            }
            if (!((String)entry.getKey()).contains("/")) {
                if ("index.xml".equals(entry.getKey())) {
                    System.setProperty("xmlLocation", assetFile.getAbsolutePath());
                    System.out.println("[legacyfix] Set XML resource index");
                    continue;
                }
                if (!"index.txt".equals(entry.getKey())) continue;
                System.setProperty("txtLocation", assetFile.getAbsolutePath());
                System.out.println("[legacyfix] Set TXT resource index");
                continue;
            }
            File localfile = new File(workingDir, "/" + AssetIndexUtils.getOS().getGameDirPath() + "resources/" + (String)entry.getKey());
            if (localfile.exists() && !localfile.isDirectory()) {
                uris.add(localfile.toURI());
                continue;
            }
            uris.add(assetKeyFile.toURI());
            String prefix = workingDir + "/" + AssetIndexUtils.getOS().getGameDirPath() + "resources/" + (String)entry.getKey();
            if (AssetIndexUtils.getOS() == OSEnum.windows) {
                prefix = prefix.replace("/", "\\");
            }
            System.setProperty("mcpath-" + prefix, assetFile.getAbsolutePath());
        }
        AssetIndexUtils.uris = uris;
        return uris;
    }

    public static boolean isInURIs(URI uri) {
        if (uris == null) {
            return false;
        }
        for (URI uri1 : uris) {
            if (!uri1.getPath().equals(uri.getPath())) continue;
            return true;
        }
        return false;
    }

    public static String getSHA1(File file) {
        try {
            int numRead;
            FileInputStream fis = new FileInputStream(file);
            byte[] buffer = new byte[1024];
            MessageDigest msgdig = MessageDigest.getInstance("SHA-1");
            do {
                if ((numRead = ((InputStream)fis).read(buffer)) <= 0) continue;
                msgdig.update(buffer, 0, numRead);
            } while (numRead != -1);
            ((InputStream)fis).close();
            byte[] digest = msgdig.digest();
            String str_result = "";
            for (int i = 0; i < digest.length; ++i) {
                str_result = str_result + Integer.toString((digest[i] & 0xFF) + 256, 16).substring(1);
            }
            return str_result;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static OSEnum getOS() {
        String prop = System.getProperty("os.name").toLowerCase();
        if (prop.contains("win")) {
            return OSEnum.windows;
        }
        if (prop.contains("mac")) {
            return OSEnum.macos;
        }
        if (prop.contains("solaris") || prop.contains("sunos")) {
            return OSEnum.solaris;
        }
        if (prop.contains("linux") || prop.contains("unix")) {
            return OSEnum.linux;
        }
        return OSEnum.unknown;
    }

    public static byte[] fileToBytes(File file) {
        try {
            FileInputStream fis = new FileInputStream(file);
            byte[] buff = new byte[(int)file.length()];
            fis.read(buff);
            fis.close();
            return buff;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return new byte[0];
        }
    }

    static {
        uris = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OSEnum {
        windows(".minecraft/"),
        macos("Library/Application Support/minecraft/"),
        solaris(".minecraft/"),
        linux(".minecraft/"),
        unknown("minecraft/");

        private String loc;

        private OSEnum(String loc) {
            this.loc = loc;
        }

        public String getGameDirPath() {
            return this.loc;
        }
    }
}

