/*
 * Decompiled with CFR 0.152.
 */
package legacyfix.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetIndexUtils {
    public static final String assetDir = System.getProperty("lf.assetDir");
    public static final String assetIndex = System.getProperty("lf.assetIndex");
    public static String gameDir = System.getProperty("lf.gameDir");
    public static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public static JsonObject assetindex;
    public static ArrayList<URI> uris;
    public static HashMap<String, String> namePathToHashPath;

    public static File getAssetIndex() {
        if (assetIndex == null) {
            return null;
        }
        File file = new File(assetIndex);
        if (!file.exists() || !file.isFile()) {
            return null;
        }
        return file;
    }

    public static boolean loadAssetObjectData() {
        try {
            FileInputStream fis = new FileInputStream(AssetIndexUtils.getAssetIndex());
            assetindex = (JsonObject)gson.fromJson((Reader)new InputStreamReader((InputStream)fis, "UTF-8"), JsonObject.class);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
        return true;
    }

    public static ArrayList<File> asFileArray() {
        ArrayList<File> list = new ArrayList<File>();
        try {
            for (URI uri : AssetIndexUtils.asURIs()) {
                list.add(new File(uri));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return list;
    }

    public static void unpackMissingAssets(File assetFile, String entry) {
        try {
            int read;
            InputStream is = AssetIndexUtils.class.getResourceAsStream("/patchasset/" + entry);
            FileOutputStream fout = new FileOutputStream(assetFile);
            byte[] buff = new byte[4096];
            while ((read = is.read(buff)) > 0) {
                fout.write(buff, 0, read);
            }
            is.close();
            fout.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static ArrayList<URI> asURIs() {
        ArrayList<URI> uris = new ArrayList<URI>();
        if (assetindex == null && !AssetIndexUtils.loadAssetObjectData()) {
            return uris;
        }
        if (AssetIndexUtils.uris != null) {
            return AssetIndexUtils.uris;
        }
        if (gameDir.endsWith("/") || gameDir.endsWith("\\")) {
            gameDir = gameDir.substring(0, gameDir.length() - 1);
        }
        JsonObject obj = assetindex.get("objects").getAsJsonObject();
        for (Map.Entry entry : obj.entrySet()) {
            if (!((String)entry.getKey()).contains("/")) continue;
            JsonObject value = ((JsonElement)entry.getValue()).getAsJsonObject();
            String hash = value.get("hash").getAsString();
            File assetFile = new File(assetDir, "objects/" + hash.substring(0, 2) + "/" + hash);
            File assetKeyFile = new File(assetDir, (String)entry.getKey());
            if (!assetFile.exists() || assetFile.length() == 0L || !hash.equalsIgnoreCase(AssetIndexUtils.getSHA1(assetFile))) {
                assetFile.getParentFile().mkdirs();
                AssetIndexUtils.unpackMissingAssets(assetFile, (String)entry.getKey());
            }
            System.out.println((String)entry.getKey() + ", " + hash);
            File localfile = new File(gameDir, "/resources/" + (String)entry.getKey());
            if (localfile.exists() && !localfile.isDirectory()) {
                uris.add(localfile.toURI());
                continue;
            }
            uris.add(assetKeyFile.toURI());
            namePathToHashPath.put((String)entry.getKey(), assetFile.getAbsolutePath());
        }
        AssetIndexUtils.uris = uris;
        return uris;
    }

    public static boolean isInURIs(URI uri) {
        if (uris == null) {
            return false;
        }
        for (URI uri1 : uris) {
            if (!uri1.getPath().equals(uri.getPath())) continue;
            return true;
        }
        return false;
    }

    public static String getSHA1(File file) {
        try {
            int numRead;
            FileInputStream fis = new FileInputStream(file);
            byte[] buffer = new byte[1024];
            MessageDigest msgdig = MessageDigest.getInstance("SHA-1");
            do {
                if ((numRead = ((InputStream)fis).read(buffer)) <= 0) continue;
                msgdig.update(buffer, 0, numRead);
            } while (numRead != -1);
            ((InputStream)fis).close();
            byte[] digest = msgdig.digest();
            String str_result = "";
            for (int i = 0; i < digest.length; ++i) {
                str_result = str_result + Integer.toString((digest[i] & 0xFF) + 256, 16).substring(1);
            }
            return str_result;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static byte[] fileToBytes(File file) {
        try {
            FileInputStream fis = new FileInputStream(file);
            byte[] buff = new byte[(int)file.length()];
            fis.read(buff);
            fis.close();
            return buff;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return new byte[0];
        }
    }

    static {
        uris = null;
        namePathToHashPath = new HashMap();
    }
}

