/*
 * Decompiled with CFR 0.152.
 */
package legacyfix.agent;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.nio.ByteBuffer;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.ClassFile;
import javassist.expr.ExprEditor;
import javassist.expr.MethodCall;
import javassist.expr.NewExpr;
import javax.imageio.ImageIO;

public class LegacyFixAgent {
    public static boolean patchMouse = false;
    public static boolean disableControllers = false;
    public static boolean disableGamma = false;
    public static boolean fix15aMP = false;
    public static boolean fixJ6Refs = false;
    public static boolean preclassicJ5 = false;
    public static boolean fixAMD = false;
    public static boolean deAWT = false;
    public static String frameName = "Minecraft";
    public static String iconPath = null;
    public static String levelFile = null;
    static ByteBuffer pixels16 = null;
    static ByteBuffer pixels32 = null;
    static boolean mousedxymatched = false;
    static String canvasClassName = null;
    static String mcappletname = null;
    static CtClass mcclas = null;
    static CtClass mouseHelper = null;

    private static ByteBuffer getIconForLWJGL(InputStream stream, int resolution) {
        try {
            Image read = ImageIO.read(stream).getScaledInstance(resolution, resolution, 4);
            BufferedImage bufImg = new BufferedImage(resolution, resolution, 2);
            Graphics g = bufImg.getGraphics();
            g.drawImage(read, 0, 0, null);
            g.dispose();
            int[] rgb = bufImg.getRGB(0, 0, resolution, resolution, null, 0, resolution);
            ByteBuffer allocate = ByteBuffer.allocate(4 * rgb.length);
            for (int n : rgb) {
                allocate.putInt(n << 8 | n >> 24 & 0xFF);
            }
            allocate.flip();
            return allocate;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static void premain(String args, final Instrumentation inst) {
        try {
            CtMethod meth;
            CtClass clas;
            String name;
            patchMouse = System.getProperty("lf.patchMouse") != null;
            disableControllers = System.getProperty("lf.disableControllers") != null;
            disableGamma = System.getProperty("lf.disableGamma") != null;
            fix15aMP = System.getProperty("lf.fix15aMP") != null;
            fixJ6Refs = System.getProperty("lf.fixJava6References") != null;
            preclassicJ5 = System.getProperty("lf.preclassicJava5") != null;
            fixAMD = "true".equalsIgnoreCase(System.getProperty("lf.fixAMD"));
            deAWT = System.getProperty("lf.deAWT") != null;
            iconPath = System.getProperty("lf.icon");
            frameName = System.getProperty("lf.frameName");
            levelFile = System.getProperty("lf.classicLevelPath");
            System.out.println("patchmacmouse - " + patchMouse + "\nfix15a - " + fix15aMP + "\ndeAWT - " + deAWT);
            if (iconPath != null) {
                File iconFile = new File(iconPath);
                if (iconFile.exists() && iconFile.isFile()) {
                    pixels32 = LegacyFixAgent.getIconForLWJGL(new FileInputStream(iconFile), 32);
                    pixels16 = LegacyFixAgent.getIconForLWJGL(new FileInputStream(iconFile), 16);
                } else {
                    pixels16 = LegacyFixAgent.getIconForLWJGL(LegacyFixAgent.class.getResourceAsStream("/favicon.png"), 16);
                    pixels32 = LegacyFixAgent.getIconForLWJGL(LegacyFixAgent.class.getResourceAsStream("/favicon.png"), 32);
                }
            } else {
                pixels16 = LegacyFixAgent.getIconForLWJGL(LegacyFixAgent.class.getResourceAsStream("/favicon.png"), 16);
                pixels32 = LegacyFixAgent.getIconForLWJGL(LegacyFixAgent.class.getResourceAsStream("/favicon.png"), 32);
            }
            final ClassPool pool = ClassPool.getDefault();
            CtClass string = pool.get("java.lang.String");
            CtClass intclas = pool.get("int");
            CtClass floatclas = pool.get("float");
            if (deAWT) {
                byte[] appletbytes = LegacyFixAgent.deAWTApplet(pool);
                inst.redefineClasses(new ClassDefinition(Class.forName(mcappletname), appletbytes));
                if (mcclas == null) {
                    System.out.println("Failed to get minecraft class!!!");
                } else {
                    LegacyFixAgent.deAWTPatch(pool, pool.getClassLoader().getClass().getProtectionDomain());
                    inst.redefineClasses(new ClassDefinition(Class.forName(mcclas.getName()), LegacyFixAgent.deAWTMain(pool)));
                    inst.redefineClasses(new ClassDefinition(Class.forName(canvasClassName), LegacyFixAgent.deAWTCanvas(pool)));
                    name = "org.lwjgl.opengl.Display";
                    clas = pool.get(name);
                    meth = clas.getDeclaredMethod("setTitle", new CtClass[]{string});
                    meth.insertBefore("$1 = \"" + frameName + "\";org.lwjgl.opengl.Display.setResizable(true);java.lang.reflect.Field f16 = java.lang.ClassLoader.getSystemClassLoader()\t\t.loadClass(\"legacyfix.agent.LegacyFixAgent\").getDeclaredField(\"pixels16\");f16.setAccessible(true);java.nio.ByteBuffer pix16 = f16.get(null);java.lang.reflect.Field f32 = java.lang.ClassLoader.getSystemClassLoader()\t\t.loadClass(\"legacyfix.agent.LegacyFixAgent\").getDeclaredField(\"pixels32\");f32.setAccessible(true);java.nio.ByteBuffer pix32 = f32.get(null);org.lwjgl.opengl.Display.setIcon(new java.nio.ByteBuffer[] {pix16, pix32});");
                    meth = clas.getDeclaredMethod("isCloseRequested");
                    meth.insertBefore("if (org.lwjgl.opengl.GL11.glGetString(org.lwjgl.opengl.GL11.GL_RENDERER).contains(\"Apple M\")) {\torg.lwjgl.opengl.GL11.glEnable(org.lwjgl.opengl.GL30.GL_FRAMEBUFFER_SRGB);}");
                    inst.redefineClasses(new ClassDefinition(Class.forName(name), clas.toBytecode()));
                }
            }
            if (preclassicJ5) {
                String[] preclassicClasses = new String[]{"RubyDung", "Textures", "Timer", "HitResult", "Entity", "Player", "character.Cube", "character.Polygon", "character.Vec3", "character.Vertex", "character.Zombie", "character.ZombieModel", "level.Chunk", "level.DirtyChunkSorter", "level.Frustum", "level.Level", "level.LevelListener", "level.LevelRenderer", "level.PerlinNoiseFilter", "level.Tesselator", "particle.Particle", "particle.ParticleEngine", "phys.AABB", "level.Tile", "level.tile.Tile", "level.tile.Bush", "level.tile.DirtTile", "level.tile.GrassTile"};
                Object[] packages = new String[]{"com.mojang.minecraft", "com.mojang.rubydung"};
                ArrayList<ClassDefinition> defList = new ArrayList<ClassDefinition>();
                for (int i = 0; i < packages.length; ++i) {
                    for (String classname : preclassicClasses) {
                        CtClass pc = pool.getOrNull((String)packages[i] + "." + classname);
                        if (pc == null) continue;
                        ClassFile cf = pc.getClassFile();
                        cf.setMajorVersion(49);
                        cf.setVersionToJava5();
                        defList.add(new ClassDefinition(pc.toClass(), pc.toBytecode()));
                    }
                }
                inst.redefineClasses(defList.toArray(new ClassDefinition[defList.size()]));
            }
            name = "java.lang.Class";
            clas = pool.get(name);
            meth = clas.getDeclaredMethod("getDeclaredField", new CtClass[]{string});
            meth.setBody("{\tjava.lang.reflect.Field[] fieldz = getDeclaredFields0(false);\tfor (int i = 0; i < fieldz.length; i++) {\t\tjava.lang.reflect.Field one = fieldz[i];\t\tif ($1.equals(one.getName())) {\t\t\treturn one;\t\t}\t}\treturn null;}");
            meth = clas.getDeclaredMethod("getDeclaredFields");
            meth.setBody("{\treturn copyFields($0.getDeclaredFields0(false));}");
            inst.redefineClasses(new ClassDefinition(Class.forName(name), clas.toBytecode()));
            name = "java.lang.ClassLoader";
            clas = pool.get(name);
            meth = clas.getDeclaredMethod("loadClass", new CtClass[]{string});
            meth.insertBefore("if ($1.startsWith(\"\\.mod_\")) {\t$1 = $1.substring(1);}");
            inst.redefineClasses(new ClassDefinition(Class.forName(name), clas.toBytecode()));
            name = "forge.ForgeHooksClient";
            clas = pool.getOrNull(name);
            if (clas != null) {
                clas.instrument(new ExprEditor(){

                    public void edit(MethodCall m) throws CannotCompileException {
                        if (m.getMethodName().equals("toArray") && m.getSignature().equals("()[Ljava/lang/Object;")) {
                            m.replace("$_ = $0.toArray(new Integer[0]);");
                        }
                    }
                });
                inst.redefineClasses(new ClassDefinition(Class.forName(name), clas.toBytecode()));
            }
            name = "java.awt.Canvas";
            clas = pool.get(name);
            meth = clas.getDeclaredMethod("addNotify");
            meth.insertAfter("try {\tjava.lang.Class cl = java.lang.ClassLoader.getSystemClassLoader().loadClass(\"uk.betacraft.mcwrapper.WrapperFrame\");\tjava.lang.reflect.Field superfield = cl.getDeclaredField(\"wrapper\");\tsuperfield.setAccessible(true);\tjava.lang.Object wrapClass = superfield.get(null);\tjava.lang.reflect.Method supermethod = wrapClass.getClass().getDeclaredMethod(\"applyFixes\", null);\tsupermethod.invoke(wrapClass, null);} catch (java.lang.Throwable t) {}");
            inst.redefineClasses(new ClassDefinition(Class.forName(name), clas.toBytecode()));
            name = "org.lwjgl.openal.AL10";
            clas = pool.getOrNull(name);
            if (clas != null) {
                CtClass bytebuffer = pool.get("java.nio.ByteBuffer");
                meth = clas.getDeclaredMethod("alBufferData", new CtClass[]{intclas, intclas, bytebuffer, intclas});
                meth.insertBefore("java.lang.reflect.Field f = java.lang.ClassLoader.getSystemClassLoader().loadClass(\"java.nio.ByteBuffer\").getDeclaredField(\"hb\");f.setAccessible(true);byte[] buffer = (byte[]) f.get($3);if (buffer != null) {\tjava.nio.ByteBuffer buf = org.lwjgl.BufferUtils.createByteBuffer(buffer.length);\tbuf.clear();\tbuf.put(buffer);\tbuf.flip();\t$3 = buf;}");
                inst.redefineClasses(new ClassDefinition(Class.forName(name), clas.toBytecode()));
            }
            if (disableControllers) {
                name = "org.lwjgl.input.Controllers";
                clas = pool.get(name);
                meth = clas.getDeclaredMethod("create");
                meth.setBody("{ return; }");
                inst.redefineClasses(new ClassDefinition(Class.forName(name), clas.toBytecode()));
            }
            if (disableGamma) {
                name = "org.lwjgl.opengl.Display";
                clas = pool.get(name);
                if (clas.isFrozen()) {
                    clas.defrost();
                }
                meth = clas.getDeclaredMethod("setDisplayConfiguration", new CtClass[]{floatclas, floatclas, floatclas});
                meth.setBody("{ return; }");
                inst.redefineClasses(new ClassDefinition(Class.forName(name), clas.toBytecode()));
            }
            if (fixAMD) {
                name = "org.lwjgl.opengl.Display";
                clas = pool.get(name);
                if (clas.isFrozen()) {
                    clas.defrost();
                }
                meth = clas.getDeclaredMethod("create");
                meth.setBody("{\torg.lwjgl.opengl.PixelFormat pixelformat = new org.lwjgl.opengl.PixelFormat();\tcreate(pixelformat.withDepthBits(24));}");
                inst.redefineClasses(new ClassDefinition(Class.forName(name), clas.toBytecode()));
            }
            if (patchMouse) {
                CtField[] fields = mcclas.getDeclaredFields();
                for (CtField field : fields) {
                    CtConstructor[] constrs;
                    for (CtConstructor constr : constrs = field.getType().getConstructors()) {
                        CtClass[] params = constr.getParameterTypes();
                        if (params.length != 1 || !params[0].getName().equals("java.awt.Component")) continue;
                        mouseHelper = field.getType();
                        System.out.println("found match for mousehelper: " + mouseHelper.getName());
                    }
                }
                if (mouseHelper != null) {
                    CtMethod[] methods = mouseHelper.getDeclaredMethods();
                    methods[0].setBody("{    org.lwjgl.input.Mouse.setGrabbed(true);    $0.a = 0;    $0.b = 0;}");
                    String body2 = "{    $0.a = org.lwjgl.input.Mouse.getDX();    $0.b = org.lwjgl.input.Mouse.getDY();}";
                    String body2invert = "{    $0.a = org.lwjgl.input.Mouse.getDX();    $0.b = -(org.lwjgl.input.Mouse.getDY());}";
                    boolean invert = "invert".equals(System.getProperty("lf.patchMouse"));
                    System.out.println("MOUSE Y INVERT: " + Boolean.toString(invert));
                    if (methods.length == 2) {
                        methods[1].setBody(invert ? body2invert : body2);
                    } else {
                        methods[1].setBody("{    org.lwjgl.input.Mouse.setCursorPosition(org.lwjgl.opengl.Display.getWidth() / 2, org.lwjgl.opengl.Display.getHeight() / 2);    org.lwjgl.input.Mouse.setGrabbed(false);}");
                        methods[2].setBody(invert ? body2invert : body2);
                    }
                    inst.redefineClasses(new ClassDefinition(Class.forName(mouseHelper.getName()), mouseHelper.toBytecode()));
                }
                inst.addTransformer(new ClassFileTransformer(){

                    @Override
                    public byte[] transform(ClassLoader loader, String className, Class<?> classRedefined, ProtectionDomain domain, byte[] classfileBuffer) {
                        CtClass clas = pool.getOrNull(className.replace("/", "."));
                        if (clas == null || clas.getName().startsWith("org.lwjgl") || clas.getName().equals(mouseHelper.getName())) {
                            return null;
                        }
                        try {
                            clas.instrument(new ExprEditor(){

                                public void edit(MethodCall m) throws CannotCompileException {
                                    if ("org.lwjgl.input.Mouse".equals(m.getClassName()) && "getDX".equals(m.getMethodName()) && "()I".equalsIgnoreCase(m.getSignature())) {
                                        mousedxymatched = true;
                                        m.replace("$_ = 0;");
                                        System.out.println("Mouse.getDX() match!");
                                    } else if ("org.lwjgl.input.Mouse".equals(m.getClassName()) && "getDY".equals(m.getMethodName()) && "()I".equalsIgnoreCase(m.getSignature())) {
                                        mousedxymatched = true;
                                        m.replace("$_ = 0;");
                                        System.out.println("Mouse.getDY() match!");
                                    }
                                }
                            });
                            if (mousedxymatched) {
                                mousedxymatched = false;
                                inst.removeTransformer(this);
                                return clas.toBytecode();
                            }
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                        return null;
                    }
                });
                CtClass mouse = pool.get("org.lwjgl.input.Mouse");
                CtClass cursorclas = pool.get("org.lwjgl.input.Cursor");
                CtMethod setcursor = mouse.getDeclaredMethod("setNativeCursor", new CtClass[]{cursorclas});
                setcursor.setBody("{    org.lwjgl.input.Mouse.setGrabbed($1 != null);    if ($1 == null) {        org.lwjgl.input.Mouse.setCursorPosition(org.lwjgl.opengl.Display.getWidth() / 2, org.lwjgl.opengl.Display.getHeight() / 2);    }    return null;}");
                inst.redefineClasses(new ClassDefinition(Class.forName("org.lwjgl.input.Mouse"), mouse.toBytecode()));
            }
            if (fix15aMP) {
                name = "com.mojang.minecraft.c";
                clas = pool.get(name);
                CtMethod setServer = clas.getDeclaredMethod("a", new CtClass[]{string, intclas});
                String server = System.getProperty("server", null);
                String port = System.getProperty("port", "25565");
                if (server == null) {
                    setServer.setBody("{}");
                } else {
                    setServer.setBody("{    if ($1.equals(\"79.136.77.240\") && $2 == 5565) {        return;    }    try {        $0.C = new com.mojang.minecraft.net.b(this, \"" + server + "\", " + port + ", $0.e.a);    } catch (Throwable t) { t.printStackTrace(); }}");
                }
                CtMethod runmeth = clas.getDeclaredMethod("run");
                runmeth.insertBefore("$0.a(\"nothing\", 420);");
                inst.redefineClasses(new ClassDefinition(Class.forName(name), clas.toBytecode()));
            }
            if (fixJ6Refs) {
                name = "com.mojang.a.a";
                clas = pool.get(name);
                clas.instrument(new ExprEditor(){

                    public void edit(MethodCall m) throws CannotCompileException {
                        if (m.getSignature().equals("(Ljava/nio/charset/Charset;)[B")) {
                            m.replace("$_ = $0.getBytes(\"UTF-8\");");
                        }
                    }

                    public void edit(NewExpr m) throws CannotCompileException {
                        try {
                            m.getConstructor();
                        }
                        catch (NotFoundException e) {
                            m.replace("$_ = new java.lang.String($1, \"UTF-8\");");
                        }
                    }
                });
                inst.redefineClasses(new ClassDefinition(Class.forName(name), clas.toBytecode()));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void deAWTPatch(ClassPool pool, ProtectionDomain pdomain) {
        try {
            CtField[] fields;
            CtClass guiScreen = null;
            CtMethod gsInitMethod = null;
            CtField guiscreenfield = null;
            block2: for (CtField field : fields = mcclas.getDeclaredFields()) {
                CtMethod[] methods;
                for (CtMethod method : methods = field.getType().getDeclaredMethods()) {
                    CtClass[] params = method.getParameterTypes();
                    if (params.length != 3 || !params[0].getName().equals(mcclas.getName()) || !params[1].getName().equals("int") || !params[2].getName().equals("int")) continue;
                    guiScreen = field.getType();
                    gsInitMethod = method;
                    guiscreenfield = field;
                    System.out.println("found match for guiscreen: " + guiScreen.getName());
                    continue block2;
                }
            }
            CtClass hud = null;
            CtField hudField = null;
            block4: for (CtField field : fields) {
                CtConstructor[] constrs;
                for (CtConstructor constr : constrs = field.getType().getDeclaredConstructors()) {
                    CtClass[] params = constr.getParameterTypes();
                    if (params.length != 3 || !params[0].getName().equals(mcclas.getName()) || !params[1].getName().equals("int") || !params[2].getName().equals("int")) continue;
                    hud = field.getType();
                    hudField = field;
                    System.out.println("found match for ingamehud: " + field.getName() + " / " + hud.getName());
                    continue block4;
                }
            }
            CtField[] hudResFields = new CtField[]{null, null};
            if (hud != null) {
                int intoccurences = 0;
                for (CtField test : hud.getDeclaredFields()) {
                    String cname = test.getType().getName();
                    if (!cname.equals("int") || intoccurences >= 2) continue;
                    System.out.println("found hud resolution field: " + test.getName());
                    hudResFields[intoccurences] = test;
                    if (++intoccurences > 1) break;
                }
            }
            CtField[] resolutionFields = new CtField[]{null, null};
            int intoccurences = 0;
            for (CtField test : mcclas.getDeclaredFields()) {
                String cname = test.getType().getName();
                if (!cname.equals("int") || intoccurences >= 2) continue;
                System.out.println("found resolution: " + test.getName());
                resolutionFields[intoccurences] = test;
                if (++intoccurences > 1) break;
            }
            CtClass threadclas = pool.get("java.lang.Thread");
            CtClass clas = pool.makeClass("legacyfix.ResizeThread", threadclas);
            CtField threadmcfield = CtField.make("public final " + mcclas.getName() + " mc;", clas);
            clas.addField(threadmcfield);
            CtConstructor constr = new CtConstructor(new CtClass[]{mcclas}, clas);
            constr.setBody("{    $0.mc = $1;}");
            clas.addConstructor(constr);
            String widthFieldName = resolutionFields[0].getName();
            String heightFieldName = resolutionFields[1].getName();
            String hudWidthFieldName = hudResFields[0] != null ? hudResFields[0].getName() : null;
            String hudHeightFieldName = hudResFields[1] != null ? hudResFields[1].getName() : null;
            CtMethod runmeth = CtMethod.make("public void run() {}", clas);
            runmeth.setBody("{" + (guiscreenfield != null ? "    java.lang.reflect.Field guiscreen = ClassLoader.getSystemClassLoader().loadClass(\"" + mcclas.getName() + "\").getDeclaredField(\"" + guiscreenfield.getName() + "\");    guiscreen.setAccessible(true);" : "") + (hudWidthFieldName != null ? "    java.lang.reflect.Field hud = ClassLoader.getSystemClassLoader().loadClass(\"" + mcclas.getName() + "\").getDeclaredField(\"" + hudField.getName() + "\");    hud.setAccessible(true);    java.lang.reflect.Field hudWidth = ClassLoader.getSystemClassLoader().loadClass(\"" + hud.getName() + "\").getDeclaredField(\"" + hudWidthFieldName + "\");    hudWidth.setAccessible(true);    java.lang.reflect.Field hudHeight = ClassLoader.getSystemClassLoader().loadClass(\"" + hud.getName() + "\").getDeclaredField(\"" + hudHeightFieldName + "\");    hudHeight.setAccessible(true);" : "") + "    java.lang.reflect.Field mcwidth = ClassLoader.getSystemClassLoader().loadClass(\"" + mcclas.getName() + "\").getDeclaredField(\"" + widthFieldName + "\");    mcwidth.setAccessible(true);    java.lang.reflect.Field mcheight = ClassLoader.getSystemClassLoader().loadClass(\"" + mcclas.getName() + "\").getDeclaredField(\"" + heightFieldName + "\");    mcheight.setAccessible(true);    while (!org.lwjgl.opengl.Display.isCreated()) {}    while (org.lwjgl.opengl.Display.isCreated()) {        int mcWidth = mcwidth.getInt($0.mc);        int mcHeight = mcheight.getInt($0.mc);        if ((org.lwjgl.opengl.Display.getWidth() != mcWidth || org.lwjgl.opengl.Display.getHeight() != mcHeight)) {            int xtoset = org.lwjgl.opengl.Display.getWidth();            int ytoset = org.lwjgl.opengl.Display.getHeight();            if (xtoset <= 0) {xtoset = 1;}            if (ytoset <= 0) {ytoset = 1;}            mcwidth.setInt($0.mc, xtoset);            mcheight.setInt($0.mc, ytoset);" + (hudWidthFieldName != null ? "            " + hud.getName() + " hudinstance = (" + hud.getName() + ") hud.get($0.mc);            int hudx = xtoset;            int hudy = ytoset;            int factor = 1;            for(; factor < 1000 && hudx / (factor + 1) >= 320 && hudy / (factor + 1) >= 240; factor++) { }            hudx = (int)Math.ceil((double)hudx / (double)factor);            hudy = (int)Math.ceil((double)hudy / (double)factor);            hudWidth.setInt(hudinstance, hudx);            hudHeight.setInt(hudinstance, hudy);" : "") + (guiscreenfield != null ? "            " + guiScreen.getName() + " gsinstance = (" + guiScreen.getName() + ") guiscreen.get($0.mc);            if (gsinstance != null) {                int x = xtoset;                int y = ytoset;                for(xtoset = 1; x / (xtoset + 1) >= 320 && y / (xtoset + 1) >= 240; ++xtoset) {}                x /= xtoset;                y /= xtoset;                gsinstance." + gsInitMethod.getName() + "($0.mc, x, y);            }" : "") + "        }    }}");
            clas.addMethod(runmeth);
            clas.toClass(pool.getClassLoader(), pdomain);
            Class.forName("legacyfix.ResizeThread", true, pool.getClassLoader());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static byte[] deAWTApplet(ClassPool pool) {
        try {
            mcappletname = "net.minecraft.client.MinecraftApplet";
            CtClass clas = pool.getOrNull(mcappletname);
            if (clas == null) {
                mcappletname = "com.mojang.minecraft.MinecraftApplet";
                clas = pool.get(mcappletname);
            }
            CtMethod meth = clas.getDeclaredMethod("init");
            CtField mcfield = null;
            for (CtField test : clas.getDeclaredFields()) {
                String cname = test.getType().getName();
                if (cname.equals("java.awt.Canvas") || cname.equals("java.lang.Thread") || cname.equals("long")) continue;
                mcclas = test.getType();
                mcfield = test;
                System.out.println("found mcclas: " + mcclas.getName());
                break;
            }
            CtField appletmodeField = null;
            for (CtField test : mcclas.getDeclaredFields()) {
                String cname = test.getType().getName();
                if (!cname.equals("boolean") || !Modifier.isPublic(test.getModifiers())) continue;
                appletmodeField = test;
                System.out.println("found appletMode field: " + appletmodeField.getName());
                break;
            }
            meth.insertAfter("java.awt.Component parent = $0;while (parent != null) {    parent.setVisible(false);    if (parent instanceof java.awt.Frame) {        ((java.awt.Frame)parent).dispose();    }    parent = parent.getParent();}$0." + mcfield.getName() + "." + appletmodeField.getName() + " = false;");
            meth.instrument(new ExprEditor(){

                public void edit(NewExpr m) throws CannotCompileException {
                    try {
                        if (m.getConstructor().getLongName().contains("(" + mcappletname + ")") && m.getSignature().equals("(L" + mcappletname.replace(".", "/") + ";)V")) {
                            canvasClassName = m.getClassName();
                            System.out.println("found canvas class name: " + canvasClassName);
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            });
            return clas.toBytecode();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static byte[] deAWTMain(ClassPool pool) {
        try {
            String classname;
            if (mcclas.isFrozen()) {
                mcclas.defrost();
            }
            CtMethod meth = mcclas.getMethod("run", "()V");
            meth.insertBefore("new legacyfix.ResizeThread($0).start();");
            CtConstructor mcconstr = mcclas.getConstructors()[0];
            CtClass[] paramTypes = mcconstr.getParameterTypes();
            String tonull = "";
            for (int i = 0; i < paramTypes.length && !(classname = paramTypes[i].getName()).equals("int"); ++i) {
                if (classname.equals("java.awt.Canvas")) {
                    tonull = tonull + "$" + Integer.toString(i + 1) + " = null;\n";
                    continue;
                }
                if (mcappletname.startsWith("com.mojang") || !classname.equals(mcappletname)) continue;
                tonull = tonull + "$" + Integer.toString(i + 1) + " = null;\n";
            }
            mcconstr.insertBefore(tonull);
            byte[] bytes = mcclas.toBytecode();
            mcclas.defrost();
            return bytes;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static byte[] deAWTCanvas(ClassPool pool) {
        try {
            String name = canvasClassName.replace("/", ".");
            CtClass clas = pool.get(name);
            CtMethod meth = clas.getDeclaredMethod("removeNotify");
            meth.setBody("{    super.removeNotify();}");
            return clas.toBytecode();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }
}

