/*
 * Decompiled with CFR 0.152.
 */
package legacyfix;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import legacyfix.ListLevelsURLConnection;
import legacyfix.LoadLevelURLConnection;

public class SaveLevelURLConnection
extends HttpURLConnection {
    ByteArrayOutputStream levelOutput = new ByteArrayOutputStream();
    Exception exception;

    public SaveLevelURLConnection(URL url) {
        super(url);
    }

    public void connect() {
    }

    public void disconnect() {
    }

    public boolean usingProxy() {
        return false;
    }

    public InputStream getInputStream() throws IOException {
        try {
            String classicLocalSaves = ListLevelsURLConnection.classicLocalSaves;
            if (classicLocalSaves == null) {
                throw new IOException("Save directory is not set");
            }
            File levels = new File(classicLocalSaves);
            byte[] data = this.levelOutput.toByteArray();
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
            String username = in.readUTF();
            String sessionid = in.readUTF();
            String levelName = in.readUTF();
            byte levelId = in.readByte();
            int length = in.readInt();
            byte[] levelData = new byte[length];
            in.read(levelData);
            in.close();
            File level = new File(levels, "level" + levelId + ".dat");
            File levelNames = new File(levels, "levels.txt");
            int maxLevels = 5;
            String[] lvlNames = new String[maxLevels];
            for (int i = 0; i < maxLevels; ++i) {
                lvlNames[i] = "-";
            }
            if (levelNames.exists()) {
                FileInputStream levelNamesStream = new FileInputStream(levelNames);
                lvlNames = new String(LoadLevelURLConnection.readStream(levelNamesStream)).split(";");
                levelNamesStream.close();
            }
            lvlNames[levelId] = levelName;
            if (levelName.equals("---")) {
                level.delete();
                lvlNames[levelId] = "-";
            } else {
                if (!levels.exists()) {
                    levels.mkdirs();
                }
                FileOutputStream fileOutput = new FileOutputStream(level);
                ((OutputStream)fileOutput).write(levelData);
                ((OutputStream)fileOutput).close();
            }
            FileOutputStream outputNames = new FileOutputStream(levelNames);
            String lvls = "";
            for (int i = 0; i < maxLevels; ++i) {
                lvls = lvls + lvlNames[i] + ";";
            }
            outputNames.write(lvls.getBytes());
            outputNames.close();
        }
        catch (Exception e) {
            this.exception = e;
        }
        if (this.exception != null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            String err = "error\n" + this.exception.getMessage();
            this.exception.printStackTrace();
            return new ByteArrayInputStream(err.getBytes());
        }
        return new ByteArrayInputStream("ok".getBytes());
    }

    public OutputStream getOutputStream() throws IOException {
        return this.levelOutput;
    }
}

