/*
 * Decompiled with CFR 0.152.
 */
package uk.betacraft.legacyfix.protocol.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.betacraft.legacyfix.LFLogger;
import uk.betacraft.legacyfix.protocol.impl.LevelHandlerBase;
import uk.betacraft.legacyfix.protocol.impl.LevelListHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LevelLoadHandler
extends LevelHandlerBase {
    private static final Pattern LEVEL_LOAD_PATTERN = Pattern.compile("(http:\\/\\/(www\\.)?minecraft\\.net(:(.+)?)?\\/level\\/load\\.html\\?id=(.+)?&user=(.+)?)");

    public LevelLoadHandler(URL u, Pattern patternUsed) {
        super(u, patternUsed);
        try {
            this.prepare();
        }
        catch (Throwable t) {
            LFLogger.error("Failed to handle level load request");
            LFLogger.error("LevelLoadHandler", t);
        }
    }

    private void prepare() throws IOException {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(data);
        try {
            Matcher matcher = LEVEL_LOAD_PATTERN.matcher(this.getURLString());
            if (!matcher.find()) {
                LFLogger.error("LevelLoadHandler", "No match for load level URL :(");
                throw new MalformedURLException("Query is missing \"id\" parameter");
            }
            int levelId = Integer.parseInt(matcher.group(5));
            File levels = new File(LevelListHandler.LEVELS_DIR_PATH);
            File level = new File(levels, "level" + levelId + ".dat");
            if (!level.exists()) {
                throw new FileNotFoundException("Level doesn't exist");
            }
            DataInputStream in = new DataInputStream(new FileInputStream(level));
            byte[] levelData = LevelLoadHandler.readStream(in);
            output.writeUTF("ok");
            output.write(levelData);
            output.close();
        }
        catch (Exception e) {
            LFLogger.error("LevelLoadHandler", (Throwable)e);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException levelId) {
                // empty catch block
            }
            ByteArrayOutputStream errorData = new ByteArrayOutputStream();
            DataOutputStream errorOutput = new DataOutputStream(errorData);
            errorOutput.writeUTF("error");
            errorOutput.writeUTF(e.getMessage());
            errorOutput.close();
            this.inputStream = new ByteArrayInputStream(errorData.toByteArray());
        }
        this.inputStream = new ByteArrayInputStream(data.toByteArray());
    }

    public static byte[] readStream(InputStream stream) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((nRead = stream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        return buffer.toByteArray();
    }

    public static List<Pattern> regexPatterns() {
        return Arrays.asList(LEVEL_LOAD_PATTERN);
    }
}

