/*
 * Decompiled with CFR 0.152.
 */
package uk.betacraft.legacyfix.patch.impl;

import java.lang.instrument.ClassDefinition;
import java.lang.instrument.Instrumentation;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.expr.ExprEditor;
import javassist.expr.MethodCall;
import uk.betacraft.legacyfix.patch.Patch;
import uk.betacraft.legacyfix.patch.PatchException;

public class BetaForgePatch
extends Patch {
    public BetaForgePatch() {
        super("beta-forge", "Fixes Forge on beta versions of the game", false);
    }

    public void apply(Instrumentation inst) throws Exception {
        CtClass clazz = pool.getOrNull("forge.ForgeHooksClient");
        if (clazz == null) {
            throw new PatchException("ForgeHooksClient not found! Is Forge even present?");
        }
        clazz.instrument(new ExprEditor(){

            public void edit(MethodCall m) throws CannotCompileException {
                if (m.getMethodName().equals("toArray") && m.getSignature().equals("()[Ljava/lang/Object;")) {
                    m.replace("$_ = $0.toArray(new Integer[0]);");
                }
            }
        });
        inst.redefineClasses(new ClassDefinition(Class.forName(clazz.getName()), clazz.toBytecode()));
    }
}

