/*
 * Decompiled with CFR 0.152.
 */
package uk.betacraft.legacyfix.patch;

import java.lang.instrument.Instrumentation;
import javassist.ClassPool;
import uk.betacraft.legacyfix.LegacyFixAgent;
import uk.betacraft.legacyfix.patch.PatchException;

public abstract class Patch {
    private final String id;
    private final String description;
    private final boolean isDefault;
    private final boolean isRequired;
    private Object setting;
    protected static final ClassPool pool = ClassPool.getDefault();

    public Patch(String id, String description, boolean isDefault, boolean isRequired) {
        this.id = id;
        this.description = description;
        this.isDefault = isDefault;
        this.isRequired = false;
    }

    public Patch(String id, String description, boolean isDefault) {
        this(id, description, isDefault, false);
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public Object getSetting() {
        if (this.setting == null) {
            this.setting = LegacyFixAgent.getSettings().get("lf." + this.getId() + (this.isDefault ? ".disable" : ""));
        }
        return this.setting;
    }

    public boolean shouldApply() {
        return this.isRequired || (this.isDefault ? this.getSetting() == null : this.getSetting() != null);
    }

    public abstract void apply(Instrumentation var1) throws PatchException, Exception;
}

