/*
 * Decompiled with CFR 0.152.
 */
package uk.betacraft.legacyfix;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;
import org.json.JSONTokener;
import uk.betacraft.legacyfix.LFLogger;
import uk.betacraft.legacyfix.patch.Patch;
import uk.betacraft.legacyfix.patch.PatchException;
import uk.betacraft.legacyfix.patch.impl.BetaForgePatch;
import uk.betacraft.legacyfix.patch.impl.BitDepthPatch;
import uk.betacraft.legacyfix.patch.impl.ClassicIndevResizePatch;
import uk.betacraft.legacyfix.patch.impl.ClassicPatch;
import uk.betacraft.legacyfix.patch.impl.ClassicProgressRendererPatch;
import uk.betacraft.legacyfix.patch.impl.DeAwtPatch;
import uk.betacraft.legacyfix.patch.impl.DisableControllersPatch;
import uk.betacraft.legacyfix.patch.impl.GameDirPatch;
import uk.betacraft.legacyfix.patch.impl.IndevSoundPatch;
import uk.betacraft.legacyfix.patch.impl.IntelPatch;
import uk.betacraft.legacyfix.patch.impl.Java6PreclassicPatch;
import uk.betacraft.legacyfix.patch.impl.Java6ReferencesPatch;
import uk.betacraft.legacyfix.patch.impl.LWJGLFramePatch;
import uk.betacraft.legacyfix.patch.impl.LauncherPatch;
import uk.betacraft.legacyfix.patch.impl.ModloaderPatch;
import uk.betacraft.legacyfix.patch.impl.MousePatch;
import uk.betacraft.legacyfix.patch.impl.ScreenshotPatch;
import uk.betacraft.legacyfix.patch.impl.SeecretSaturdayPatch;
import uk.betacraft.legacyfix.patch.impl.TexturePackFolderPatch;
import uk.betacraft.legacyfix.patch.impl.VSyncPatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegacyFixAgent {
    private static final Map<String, Object> SETTINGS = new HashMap<String, Object>();
    private static final Patch[] PATCHES;
    private static final JSONObject RELEASE_INFO;
    public static final String VERSION;
    private static Boolean debug;

    public static void premain(String agentArgs, Instrumentation inst) {
        LFLogger.info("Loading build " + VERSION);
        ArrayList<String> patchStates = new ArrayList<String>();
        for (Patch patch : PATCHES) {
            if (!patch.shouldApply()) continue;
            try {
                patch.apply(inst);
                patchStates.add(patch.getId() + " - Applied");
            }
            catch (Throwable e) {
                if (e instanceof PatchException) {
                    patchStates.add(patch.getId() + " - Error: " + e.getMessage());
                } else {
                    patchStates.add(patch.getId() + " - Exception, see stacktrace");
                    LFLogger.error(patch, e);
                }
                if (!patch.isRequired()) continue;
                LFLogger.error("Patch " + patch.getId() + " is required, but failed to apply. Exiting.");
                System.exit(-1);
            }
        }
        if (!patchStates.isEmpty()) {
            LFLogger.logList("Patches:", patchStates);
        } else {
            LFLogger.info("No patches applied");
        }
    }

    public static Map<String, Object> getSettings() {
        return SETTINGS;
    }

    public static String getSetting(String key, String alt) {
        return LegacyFixAgent.getSettings().containsKey(key) ? (String)LegacyFixAgent.getSettings().get(key) : alt;
    }

    public static boolean hasSetting(String key) {
        return LegacyFixAgent.getSettings().containsKey(key);
    }

    public static boolean isDebug() {
        if (debug == null) {
            debug = LegacyFixAgent.hasSetting("lf.debug");
        }
        return debug;
    }

    static {
        RELEASE_INFO = new JSONObject(new JSONTokener(new BufferedReader(new InputStreamReader(LegacyFixAgent.class.getResourceAsStream("/release_info.json")))));
        VERSION = RELEASE_INFO.optString("version", "unknown");
        for (Map.Entry<Object, Object> property : System.getProperties().entrySet()) {
            String propertyKey = String.valueOf(property.getKey());
            if (!propertyKey.startsWith("lf.") || SETTINGS.containsKey(propertyKey)) continue;
            SETTINGS.put(propertyKey, property.getValue());
        }
        PATCHES = new Patch[]{new LauncherPatch(), new DisableControllersPatch(), new TexturePackFolderPatch(), new Java6PreclassicPatch(), new Java6ReferencesPatch(), new SeecretSaturdayPatch(), new LWJGLFramePatch(), new IndevSoundPatch(), new BetaForgePatch(), new ModloaderPatch(), new BitDepthPatch(), new ClassicPatch(), new ClassicIndevResizePatch(), new ClassicProgressRendererPatch(), new GameDirPatch(), new ScreenshotPatch(), new IntelPatch(), new DeAwtPatch(), new MousePatch(), new VSyncPatch()};
    }
}

