/*
 * Decompiled with CFR 0.152.
 */
package uk.betacraft.legacyfix;

import java.util.List;
import uk.betacraft.legacyfix.LegacyFixAgent;
import uk.betacraft.legacyfix.patch.Patch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LFLogger {
    public static void info(String ... lines) {
        LFLogger.log("INFO", lines);
    }

    public static void error(Patch patch, Throwable t) {
        LFLogger.error(patch.getId(), t);
    }

    public static void error(String component, Throwable t) {
        StackTraceElement[] stackTraceElements = t.getStackTrace();
        String[] stackTraceStrings = new String[stackTraceElements.length + 2];
        stackTraceStrings[0] = component;
        stackTraceStrings[1] = t.getMessage();
        for (int i = 0; i < stackTraceElements.length; ++i) {
            stackTraceStrings[i + 2] = stackTraceElements[i].toString();
        }
        LFLogger.error(stackTraceStrings);
        if (t.getCause() != null) {
            LFLogger.error("Caused by:");
            LFLogger.error(component, t.getCause());
        }
    }

    public static void error(String ... lines) {
        LFLogger.log("ERROR", lines);
    }

    public static void log(String prefix, String ... lines) {
        for (int i = 0; i < lines.length; ++i) {
            if (i == 0) {
                System.out.println("[LF] " + prefix + ": " + lines[i]);
                continue;
            }
            System.out.println("        " + lines[i]);
        }
    }

    public static void logList(String header, List<String> lines) {
        System.out.println("[LF] " + header);
        for (String line : lines) {
            System.out.println("        " + line);
        }
    }

    public static void debug(String ... lines) {
        if (LegacyFixAgent.isDebug()) {
            LFLogger.log("DEBUG", lines);
        }
    }
}

