/*
 * Decompiled with CFR 0.152.
 */
package uk.betacraft.legacyfix;

import java.io.File;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import uk.betacraft.legacyfix.LFLogger;
import uk.betacraft.legacyfix.protocol.LegacyURLStreamHandlerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegacyFixLauncher {
    public static List<String> arguments = new LinkedList<String>();

    public static void main(String[] args) {
        for (String arg : args) {
            if (arguments.contains(arg) && arg.startsWith("--")) {
                LFLogger.error("LegacyFixLauncher", "Duplicate argument '" + arg + "'!");
            }
            arguments.add(arg);
        }
        URL.setURLStreamHandlerFactory(new LegacyURLStreamHandlerFactory());
        LegacyFixLauncher.launch();
    }

    private static void launch() {
        String minecraftAppletClassName = LegacyFixLauncher.getValue("appletClass", "net.minecraft.client.MinecraftApplet");
        try {
            Class<?> minecraftAppletClass = ClassLoader.getSystemClassLoader().loadClass(minecraftAppletClassName);
            Object minecraftApplet = minecraftAppletClass.newInstance();
            minecraftAppletClass.getDeclaredMethod("init", new Class[0]).invoke(minecraftApplet, new Object[0]);
        }
        catch (ClassNotFoundException ignored) {
            String mainClassName = LegacyFixLauncher.getValue("mainClass", "net.minecraft.client.main.Main");
            try {
                Class<?> minecraftMainClass = ClassLoader.getSystemClassLoader().loadClass(mainClassName);
                minecraftMainClass.getMethod("main", String[].class).invoke(null, new Object[]{LegacyFixLauncher.getAcceptableArguments()});
            }
            catch (ClassNotFoundException ignored2) {
                LFLogger.error("Failed to find the main class! Tried \"" + minecraftAppletClassName + "\" and \"" + mainClassName + "\"");
            }
            catch (Throwable t) {
                LFLogger.error("Failed to launch Minecraft");
                LFLogger.error("launch", t);
            }
        }
        catch (Throwable t) {
            LFLogger.error("Failed to launch Minecraft");
            LFLogger.error("launch", t);
        }
    }

    private static String[] getAcceptableArguments() {
        LinkedList<String> args = new LinkedList<String>();
        if (LegacyFixLauncher.hasKey("limit13w16a")) {
            args.addAll(LegacyFixLauncher.limit(false));
        } else if (LegacyFixLauncher.hasKey("limit13w23a")) {
            args.addAll(LegacyFixLauncher.limit(true));
        } else {
            args.addAll(arguments);
        }
        return args.toArray(new String[0]);
    }

    private static List<String> limit(boolean is13w23a) {
        LinkedList<String> args = new LinkedList<String>();
        if (LegacyFixLauncher.hasKey("demo")) {
            args.add("--demo");
        }
        if (LegacyFixLauncher.hasKey("fullscreen")) {
            args.add("--fullscreen");
        }
        if (LegacyFixLauncher.hasKey("gameDir")) {
            args.add("--workDir");
            args.add(LegacyFixLauncher.getValue("gameDir", "."));
        }
        if (LegacyFixLauncher.hasKey("server")) {
            args.add("--server");
            args.add(LegacyFixLauncher.getValue("server", "localhost"));
        }
        if (LegacyFixLauncher.hasKey("port")) {
            args.add("--port");
            args.add(LegacyFixLauncher.getValue("port", "25565"));
        }
        if (LegacyFixLauncher.hasKey("username")) {
            args.add("--username");
            args.add(LegacyFixLauncher.getValue("username", "Player"));
        }
        if (LegacyFixLauncher.hasKey("session")) {
            args.add("--session");
            args.add(LegacyFixLauncher.getValue("session", "-"));
        }
        if (is13w23a && LegacyFixLauncher.hasKey("version")) {
            args.add("--version");
            args.add(LegacyFixLauncher.getValue("version", "unknown"));
        }
        return args;
    }

    public static String getValue(String key, String alt) {
        if (!LegacyFixLauncher.hasKey(key)) {
            return alt;
        }
        return arguments.get(arguments.indexOf("--" + key) + 1);
    }

    public static boolean hasKey(String key) {
        return arguments.contains("--" + key);
    }

    public static String getScreenshotsDir() {
        return LegacyFixLauncher.getValue("screenshotsDir", new File(LegacyFixLauncher.getGameDir(), "screenshots").getPath());
    }

    public static String getGameDir() {
        return LegacyFixLauncher.getValue("gameDir", "minecraft");
    }

    public static String getAssetsDir() {
        return LegacyFixLauncher.getValue("assetsDir", "assets");
    }

    public static String getAssetIndexPath() {
        String assetIndex = LegacyFixLauncher.getValue("assetIndex", null);
        if (assetIndex == null) {
            return null;
        }
        return new File(LegacyFixLauncher.getAssetsDir(), "indexes/" + assetIndex + ".json").getAbsolutePath();
    }

    public static int getWidth() {
        return Integer.parseInt(LegacyFixLauncher.getValue("width", "854"));
    }

    public static int getHeight() {
        return Integer.parseInt(LegacyFixLauncher.getValue("height", "480"));
    }

    public static boolean getFullscreen() {
        return LegacyFixLauncher.hasKey("fullscreen");
    }

    public static String getFrameName() {
        return LegacyFixLauncher.getValue("frameName", "Minecraft");
    }
}

